/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.food;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.food.FoodConstants;

public record FoodInfo(int nutrition, float saturation, boolean canAlwaysEat, float eatSeconds, List<b> effects) {
    private static final float DEFAULT_EAT_SECONDS = 1.6f;
    public static final Codec<FoodInfo> DIRECT_CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("nutrition").forGetter(FoodInfo::nutrition), (App)Codec.FLOAT.fieldOf("saturation").forGetter(FoodInfo::saturation), (App)Codec.BOOL.optionalFieldOf("can_always_eat", (Object)false).forGetter(FoodInfo::canAlwaysEat), (App)ExtraCodecs.POSITIVE_FLOAT.optionalFieldOf("eat_seconds", (Object)Float.valueOf(1.6f)).forGetter(FoodInfo::eatSeconds), (App)b.CODEC.listOf().optionalFieldOf("effects", List.of()).forGetter(FoodInfo::effects)).apply((Applicative)var0, FoodInfo::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, FoodInfo> DIRECT_STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.VAR_INT, FoodInfo::nutrition, ByteBufCodecs.FLOAT, FoodInfo::saturation, ByteBufCodecs.BOOL, FoodInfo::canAlwaysEat, ByteBufCodecs.FLOAT, FoodInfo::eatSeconds, b.STREAM_CODEC.apply(ByteBufCodecs.list()), FoodInfo::effects, FoodInfo::new);

    public int eatDurationTicks() {
        return (int)(this.eatSeconds * 20.0f);
    }

    public record b(MobEffect effect, float probability) {
        private final MobEffect effect;
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)MobEffect.CODEC.fieldOf("effect").forGetter(b::effect), (App)Codec.floatRange((float)0.0f, (float)1.0f).optionalFieldOf("probability", (Object)Float.valueOf(1.0f)).forGetter(b::probability)).apply((Applicative)var0, b::new));
        public static final StreamCodec<RegistryFriendlyByteBuf, b> STREAM_CODEC = StreamCodec.composite(MobEffect.STREAM_CODEC, b::effect, ByteBufCodecs.FLOAT, b::probability, b::new);

        public MobEffect effect() {
            return new MobEffect(this.effect);
        }
    }

    public static class a {
        private int nutrition;
        private float saturationModifier;
        private boolean canAlwaysEat;
        private float eatSeconds = 1.6f;
        private final ImmutableList.Builder<b> effects = ImmutableList.builder();

        public a nutrition(int var0) {
            this.nutrition = var0;
            return this;
        }

        public a saturationModifier(float var0) {
            this.saturationModifier = var0;
            return this;
        }

        public a alwaysEdible() {
            this.canAlwaysEat = true;
            return this;
        }

        public a fast() {
            this.eatSeconds = 0.8f;
            return this;
        }

        public a effect(MobEffect var0, float var1) {
            this.effects.add((Object)new b(var0, var1));
            return this;
        }

        public FoodInfo build() {
            float var0 = FoodConstants.saturationByModifier(this.nutrition, this.saturationModifier);
            return new FoodInfo(this.nutrition, var0, this.canAlwaysEat, this.eatSeconds, (List<b>)this.effects.build());
        }
    }
}

