/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAreaEffectCloud;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.EntityProjectileThrowable;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.MovingObjectPosition;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.MovingObjectPositionEntity;

public class EntityPotion
extends EntityProjectileThrowable
implements ItemSupplier {
    public static final double SPLASH_RANGE = 4.0;
    private static final double SPLASH_RANGE_SQ = 16.0;
    public static final Predicate<EntityLiving> WATER_SENSITIVE_OR_ON_FIRE = var0 -> var0.isSensitiveToWater() || var0.isOnFire();

    public EntityPotion(EntityTypes<? extends EntityPotion> var0, World var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)var0, var1);
    }

    public EntityPotion(World var0, EntityLiving var1) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, var1, var0);
    }

    public EntityPotion(World var0, double var1, double var3, double var5) {
        super((EntityTypes<? extends EntityProjectileThrowable>)EntityTypes.POTION, var1, var3, var5, var0);
    }

    @Override
    protected Item getDefaultItem() {
        return Items.SPLASH_POTION;
    }

    @Override
    protected double getDefaultGravity() {
        return 0.05;
    }

    @Override
    protected void onHitBlock(MovingObjectPositionBlock var0) {
        super.onHitBlock(var0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        EnumDirection var2 = var0.getDirection();
        BlockPosition var3 = var0.getBlockPos();
        BlockPosition var4 = var3.relative(var2);
        PotionContents var5 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if (var5.is(Potions.WATER)) {
            this.dowseFire(var4);
            this.dowseFire(var4.relative(var2.getOpposite()));
            for (EnumDirection var7 : EnumDirection.EnumDirectionLimit.HORIZONTAL) {
                this.dowseFire(var4.relative(var7));
            }
        }
    }

    @Override
    protected void onHit(MovingObjectPosition var0) {
        super.onHit(var0);
        if (this.level().isClientSide) {
            return;
        }
        ItemStack var1 = this.getItem();
        PotionContents var2 = var1.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
        if (var2.is(Potions.WATER)) {
            this.applyWater();
        } else if (var2.hasEffects()) {
            if (this.isLingering()) {
                this.makeAreaOfEffectCloud(var2);
            } else {
                this.applySplash(var2.getAllEffects(), var0.getType() == MovingObjectPosition.EnumMovingObjectType.ENTITY ? ((MovingObjectPositionEntity)var0).getEntity() : null);
            }
        }
        int var3 = var2.potion().isPresent() && var2.potion().get().value().hasInstantEffects() ? 2007 : 2002;
        this.level().levelEvent(var3, this.blockPosition(), var2.getColor());
        this.discard();
    }

    private void applyWater() {
        AxisAlignedBB var0 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var1 = this.level().getEntitiesOfClass(EntityLiving.class, var0, WATER_SENSITIVE_OR_ON_FIRE);
        for (EntityLiving var3 : var1) {
            double var4 = this.distanceToSqr(var3);
            if (!(var4 < 16.0)) continue;
            if (var3.isSensitiveToWater()) {
                var3.hurt(this.damageSources().indirectMagic(this, this.getOwner()), 1.0f);
            }
            if (!var3.isOnFire() || !var3.isAlive()) continue;
            var3.extinguishFire();
        }
        List<Axolotl> var2 = this.level().getEntitiesOfClass(Axolotl.class, var0);
        for (Axolotl var4 : var2) {
            var4.rehydrate();
        }
    }

    private void applySplash(Iterable<MobEffect> var0, @Nullable Entity var1) {
        AxisAlignedBB var22 = this.getBoundingBox().inflate(4.0, 2.0, 4.0);
        List<EntityLiving> var3 = this.level().getEntitiesOfClass(EntityLiving.class, var22);
        if (!var3.isEmpty()) {
            Entity var4 = this.getEffectSource();
            for (EntityLiving var6 : var3) {
                double var7;
                if (!var6.isAffectedByPotions() || !((var7 = this.distanceToSqr(var6)) < 16.0)) continue;
                double var9 = var6 == var1 ? 1.0 : 1.0 - Math.sqrt(var7) / 4.0;
                for (MobEffect var12 : var0) {
                    Holder<MobEffectList> var13 = var12.getEffect();
                    if (var13.value().isInstantenous()) {
                        var13.value().applyInstantenousEffect(this, this.getOwner(), var6, var12.getAmplifier(), var9);
                        continue;
                    }
                    int var14 = var12.mapDuration(var2 -> (int)(var9 * (double)var2 + 0.5));
                    MobEffect var15 = new MobEffect(var13, var14, var12.getAmplifier(), var12.isAmbient(), var12.isVisible());
                    if (var15.endsWithin(20)) continue;
                    var6.addEffect(var15, var4);
                }
            }
        }
    }

    private void makeAreaOfEffectCloud(PotionContents var0) {
        EntityAreaEffectCloud var1 = new EntityAreaEffectCloud(this.level(), this.getX(), this.getY(), this.getZ());
        Entity entity = this.getOwner();
        if (entity instanceof EntityLiving) {
            EntityLiving var2 = (EntityLiving)entity;
            var1.setOwner(var2);
        }
        var1.setRadius(3.0f);
        var1.setRadiusOnUse(-0.5f);
        var1.setWaitTime(10);
        var1.setRadiusPerTick(-var1.getRadius() / (float)var1.getDuration());
        var1.setPotionContents(var0);
        this.level().addFreshEntity(var1);
    }

    public boolean isLingering() {
        return this.getItem().is(Items.LINGERING_POTION);
    }

    private void dowseFire(BlockPosition var0) {
        IBlockData var1 = this.level().getBlockState(var0);
        if (var1.is(TagsBlock.FIRE)) {
            this.level().destroyBlock(var0, false, this);
        } else if (AbstractCandleBlock.isLit(var1)) {
            AbstractCandleBlock.extinguish(null, var1, this.level(), var0);
        } else if (BlockCampfire.isLitCampfire(var1)) {
            this.level().levelEvent(null, 1009, var0, 0);
            BlockCampfire.dowse(this.getOwner(), this.level(), var0, var1);
            this.level().setBlockAndUpdate(var0, (IBlockData)var1.setValue(BlockCampfire.LIT, false));
        }
    }
}

