/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.projectile.EntityFireball;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.World;

public abstract class EntityFireballFireball
extends EntityFireball
implements ItemSupplier {
    private static final DataWatcherObject<ItemStack> DATA_ITEM_STACK = DataWatcher.defineId(EntityFireballFireball.class, DataWatcherRegistry.ITEM_STACK);

    public EntityFireballFireball(EntityTypes<? extends EntityFireballFireball> var0, World var1) {
        super((EntityTypes<? extends EntityFireball>)var0, var1);
    }

    public EntityFireballFireball(EntityTypes<? extends EntityFireballFireball> var0, double var1, double var3, double var5, double var7, double var9, double var11, World var13) {
        super(var0, var1, var3, var5, var7, var9, var11, var13);
    }

    public EntityFireballFireball(EntityTypes<? extends EntityFireballFireball> var0, EntityLiving var1, double var2, double var4, double var6, World var8) {
        super(var0, var1, var2, var4, var6, var8);
    }

    public void setItem(ItemStack var0) {
        if (var0.isEmpty()) {
            this.getEntityData().set(DATA_ITEM_STACK, this.getDefaultItem());
        } else {
            this.getEntityData().set(DATA_ITEM_STACK, var0.copyWithCount(1));
        }
    }

    @Override
    public ItemStack getItem() {
        return this.getEntityData().get(DATA_ITEM_STACK);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_ITEM_STACK, this.getDefaultItem());
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.put("Item", this.getItem().save(this.registryAccess()));
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        if (var0.contains("Item", 10)) {
            this.setItem(ItemStack.parse(this.registryAccess(), var0.getCompound("Item")).orElse(this.getDefaultItem()));
        } else {
            this.setItem(this.getDefaultItem());
        }
    }

    private ItemStack getDefaultItem() {
        return new ItemStack(Items.FIRE_CHARGE);
    }

    @Override
    public SlotAccess getSlot(int var0) {
        if (var0 == 0) {
            return SlotAccess.of(this::getItem, this::setItem);
        }
        return super.getSlot(var0);
    }
}

