/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.World;

public class EntityEvokerFangs
extends Entity
implements TraceableEntity {
    public static final int ATTACK_DURATION = 20;
    public static final int LIFE_OFFSET = 2;
    public static final int ATTACK_TRIGGER_TICKS = 14;
    public int warmupDelayTicks;
    private boolean sentSpikeEvent;
    private int lifeTicks = 22;
    private boolean clientSideAttackStarted;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private UUID ownerUUID;

    public EntityEvokerFangs(EntityTypes<? extends EntityEvokerFangs> var0, World var1) {
        super(var0, var1);
    }

    public EntityEvokerFangs(World var0, double var1, double var3, double var5, float var7, int var8, EntityLiving var9) {
        this((EntityTypes<? extends EntityEvokerFangs>)EntityTypes.EVOKER_FANGS, var0);
        this.warmupDelayTicks = var8;
        this.setOwner(var9);
        this.setYRot(var7 * 57.295776f);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
    }

    public void setOwner(@Nullable EntityLiving var0) {
        this.owner = var0;
        this.ownerUUID = var0 == null ? null : var0.getUUID();
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        Entity var0;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof WorldServer && (var0 = ((WorldServer)this.level()).getEntity(this.ownerUUID)) instanceof EntityLiving) {
            this.owner = (EntityLiving)var0;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.warmupDelayTicks = var0.getInt("Warmup");
        if (var0.hasUUID("Owner")) {
            this.ownerUUID = var0.getUUID("Owner");
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putInt("Warmup", this.warmupDelayTicks);
        if (this.ownerUUID != null) {
            var0.putUUID("Owner", this.ownerUUID);
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.level().isClientSide) {
            if (this.clientSideAttackStarted) {
                --this.lifeTicks;
                if (this.lifeTicks == 14) {
                    for (int var0 = 0; var0 < 12; ++var0) {
                        double var1 = this.getX() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double var3 = this.getY() + 0.05 + this.random.nextDouble();
                        double var5 = this.getZ() + (this.random.nextDouble() * 2.0 - 1.0) * (double)this.getBbWidth() * 0.5;
                        double var7 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        double var9 = 0.3 + this.random.nextDouble() * 0.3;
                        double var11 = (this.random.nextDouble() * 2.0 - 1.0) * 0.3;
                        this.level().addParticle(Particles.CRIT, var1, var3 + 1.0, var5, var7, var9, var11);
                    }
                }
            }
        } else if (--this.warmupDelayTicks < 0) {
            if (this.warmupDelayTicks == -8) {
                List<EntityLiving> var0 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox().inflate(0.2, 0.0, 0.2));
                for (EntityLiving var2 : var0) {
                    this.dealDamageTo(var2);
                }
            }
            if (!this.sentSpikeEvent) {
                this.level().broadcastEntityEvent(this, (byte)4);
                this.sentSpikeEvent = true;
            }
            if (--this.lifeTicks < 0) {
                this.discard();
            }
        }
    }

    private void dealDamageTo(EntityLiving var0) {
        EntityLiving var1 = this.getOwner();
        if (!var0.isAlive() || var0.isInvulnerable() || var0 == var1) {
            return;
        }
        if (var1 == null) {
            var0.hurt(this.damageSources().magic(), 6.0f);
        } else {
            if (var1.isAlliedTo(var0)) {
                return;
            }
            var0.hurt(this.damageSources().indirectMagic(this, var1), 6.0f);
        }
    }

    @Override
    public void handleEntityEvent(byte var0) {
        super.handleEntityEvent(var0);
        if (var0 == 4) {
            this.clientSideAttackStarted = true;
            if (!this.isSilent()) {
                this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), SoundEffects.EVOKER_FANGS_ATTACK, this.getSoundSource(), 1.0f, this.random.nextFloat() * 0.2f + 0.85f, false);
            }
        }
    }

    public float getAnimationProgress(float var0) {
        if (!this.clientSideAttackStarted) {
            return 0.0f;
        }
        int var1 = this.lifeTicks - 2;
        if (var1 <= 0) {
            return 1.0f;
        }
        return 1.0f - ((float)var1 - var0) / 20.0f;
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

