/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster.breeze;

import com.mojang.serialization.Dynamic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleParamBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.monster.EntityMonster;
import net.minecraft.world.entity.monster.breeze.BreezeAi;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.entity.projectile.ProjectileDeflection;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.EnumRenderType;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;

public class Breeze
extends EntityMonster {
    private static final int SLIDE_PARTICLES_AMOUNT = 20;
    private static final int IDLE_PARTICLES_AMOUNT = 1;
    private static final int JUMP_DUST_PARTICLES_AMOUNT = 20;
    private static final int JUMP_TRAIL_PARTICLES_AMOUNT = 3;
    private static final int JUMP_TRAIL_DURATION_TICKS = 5;
    private static final int JUMP_CIRCLE_DISTANCE_Y = 10;
    private static final float FALL_DISTANCE_SOUND_TRIGGER_THRESHOLD = 3.0f;
    private static final int WHIRL_SOUND_FREQUENCY_MIN = 1;
    private static final int WHIRL_SOUND_FREQUENCY_MAX = 80;
    public AnimationState idle = new AnimationState();
    public AnimationState slide = new AnimationState();
    public AnimationState slideBack = new AnimationState();
    public AnimationState longJump = new AnimationState();
    public AnimationState shoot = new AnimationState();
    public AnimationState inhale = new AnimationState();
    private int jumpTrailStartedTick = 0;
    private int soundTick = 0;
    private static final ProjectileDeflection PROJECTILE_DEFLECTION = (var0, var1, var2) -> {
        var1.level().playLocalSound(var1, SoundEffects.BREEZE_DEFLECT, var1.getSoundSource(), 1.0f, 1.0f);
        ProjectileDeflection.REVERSE.deflect(var0, var1, var2);
    };

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MOVEMENT_SPEED, 0.63f).add(GenericAttributes.MAX_HEALTH, 30.0).add(GenericAttributes.FOLLOW_RANGE, 24.0).add(GenericAttributes.ATTACK_DAMAGE, 3.0);
    }

    public Breeze(EntityTypes<? extends EntityMonster> var0, World var1) {
        super(var0, var1);
        this.setPathfindingMalus(PathType.DANGER_TRAPDOOR, -1.0f);
        this.setPathfindingMalus(PathType.DAMAGE_FIRE, -1.0f);
        this.xpReward = 10;
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return BreezeAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Breeze> getBrain() {
        return super.getBrain();
    }

    protected BehaviorController.b<Breeze> brainProvider() {
        return BehaviorController.provider(BreezeAi.MEMORY_TYPES, BreezeAi.SENSOR_TYPES);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (this.level().isClientSide() && DATA_POSE.equals(var0)) {
            this.resetAnimations();
            EntityPose var1 = this.getPose();
            switch (var1) {
                case SHOOTING: {
                    this.shoot.startIfStopped(this.tickCount);
                    break;
                }
                case INHALING: {
                    this.longJump.startIfStopped(this.tickCount);
                    break;
                }
                case SLIDING: {
                    this.slide.startIfStopped(this.tickCount);
                }
            }
        }
        super.onSyncedDataUpdated(var0);
    }

    private void resetAnimations() {
        this.shoot.stop();
        this.idle.stop();
        this.inhale.stop();
        this.longJump.stop();
    }

    @Override
    public void tick() {
        EntityPose var0 = this.getPose();
        switch (var0) {
            case SLIDING: {
                this.emitGroundParticles(20);
                break;
            }
            case SHOOTING: 
            case INHALING: 
            case STANDING: {
                this.resetJumpTrail().emitGroundParticles(1 + this.getRandom().nextInt(1));
                break;
            }
            case LONG_JUMPING: {
                this.emitJumpTrailParticles();
            }
        }
        if (var0 != EntityPose.SLIDING && this.slide.isStarted()) {
            this.slideBack.start(this.tickCount);
            this.slide.stop();
        }
        int n2 = this.soundTick = this.soundTick == 0 ? this.random.nextIntBetweenInclusive(1, 80) : this.soundTick - 1;
        if (this.soundTick == 0) {
            this.playWhirlSound();
        }
        super.tick();
    }

    public Breeze resetJumpTrail() {
        this.jumpTrailStartedTick = 0;
        return this;
    }

    public void emitJumpTrailParticles() {
        if (++this.jumpTrailStartedTick > 5) {
            return;
        }
        IBlockData var0 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
        Vec3D var1 = this.getDeltaMovement();
        Vec3D var2 = this.position().add(var1).add(0.0, 0.1f, 0.0);
        for (int var3 = 0; var3 < 3; ++var3) {
            this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var0), var2.x, var2.y, var2.z, 0.0, 0.0, 0.0);
        }
    }

    public void emitGroundParticles(int var0) {
        IBlockData var3;
        if (this.isPassenger()) {
            return;
        }
        Vec3D var1 = this.getBoundingBox().getCenter();
        Vec3D var2 = new Vec3D(var1.x, this.position().y, var1.z);
        IBlockData iBlockData = var3 = !this.getInBlockState().isAir() ? this.getInBlockState() : this.getBlockStateOn();
        if (var3.getRenderShape() == EnumRenderType.INVISIBLE) {
            return;
        }
        for (int var4 = 0; var4 < var0; ++var4) {
            this.level().addParticle(new ParticleParamBlock(Particles.BLOCK, var3), var2.x, var2.y, var2.z, 0.0, 0.0, 0.0);
        }
    }

    @Override
    public void playAmbientSound() {
        if (this.getTarget() != null && this.onGround()) {
            return;
        }
        this.level().playLocalSound(this, this.getAmbientSound(), this.getSoundSource(), 1.0f, 1.0f);
    }

    public void playWhirlSound() {
        float var0 = 0.7f + 0.4f * this.random.nextFloat();
        float var1 = 0.8f + 0.2f * this.random.nextFloat();
        this.level().playLocalSound(this, SoundEffects.BREEZE_WHIRL, this.getSoundSource(), var1, var0);
    }

    @Override
    public ProjectileDeflection deflection(IProjectile var0) {
        if (var0.getType() == EntityTypes.BREEZE_WIND_CHARGE || var0.getType() == EntityTypes.WIND_CHARGE) {
            return ProjectileDeflection.NONE;
        }
        return PROJECTILE_DEFLECTION;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.BREEZE_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.BREEZE_HURT;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return this.onGround() ? SoundEffects.BREEZE_IDLE_GROUND : SoundEffects.BREEZE_IDLE_AIR;
    }

    public Optional<EntityLiving> getHurtBy() {
        return this.getBrain().getMemory(MemoryModuleType.HURT_BY).map(DamageSource::getEntity).filter(var0 -> var0 instanceof EntityLiving).map(var0 -> (EntityLiving)var0);
    }

    public boolean withinInnerCircleRange(Vec3D var0) {
        Vec3D var1 = this.blockPosition().getCenter();
        return var0.closerThan(var1, 4.0, 10.0);
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("breezeBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        this.level().getProfiler().popPush("breezeActivityUpdate");
        BreezeAi.updateActivity(this);
        this.level().getProfiler().pop();
        super.customServerAiStep();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
        PacketDebug.sendBreezeInfo(this);
    }

    @Override
    public boolean canAttackType(EntityTypes<?> var0) {
        return var0 == EntityTypes.PLAYER || var0 == EntityTypes.IRON_GOLEM;
    }

    @Override
    public int getMaxHeadYRot() {
        return 30;
    }

    @Override
    public int getHeadRotSpeed() {
        return 25;
    }

    public double getSnoutYPosition() {
        return this.getEyeY() - 0.4;
    }

    @Override
    public boolean isInvulnerableTo(DamageSource var0) {
        return var0.is(DamageTypeTags.BREEZE_IMMUNE_TO) || var0.getEntity() instanceof Breeze || super.isInvulnerableTo(var0);
    }

    @Override
    public double getFluidJumpThreshold() {
        return this.getEyeHeight();
    }

    @Override
    public boolean causeFallDamage(float var0, float var1, DamageSource var2) {
        if (var0 > 3.0f) {
            this.playSound(SoundEffects.BREEZE_LAND, 1.0f, 1.0f);
        }
        return super.causeFallDamage(var0, var1, var2);
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.EVENTS;
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }
}

