/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.monster;

import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketPlayOutSpawnEntity;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.util.MathHelper;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.ControllerLook;
import net.minecraft.world.entity.ai.control.EntityAIBodyControl;
import net.minecraft.world.entity.ai.goal.PathfinderGoal;
import net.minecraft.world.entity.ai.goal.PathfinderGoalLookAtPlayer;
import net.minecraft.world.entity.ai.goal.PathfinderGoalRandomLookaround;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalHurtByTarget;
import net.minecraft.world.entity.ai.goal.target.PathfinderGoalNearestAttackableTarget;
import net.minecraft.world.entity.animal.EntityGolem;
import net.minecraft.world.entity.monster.IMonster;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.projectile.EntityArrow;
import net.minecraft.world.entity.projectile.EntityShulkerBullet;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class EntityShulker
extends EntityGolem
implements VariantHolder<Optional<EnumColor>>,
IMonster {
    private static final UUID COVERED_ARMOR_MODIFIER_UUID = UUID.fromString("7E0292F2-9434-48D5-A29F-9583AF7DF27F");
    private static final AttributeModifier COVERED_ARMOR_MODIFIER = new AttributeModifier(COVERED_ARMOR_MODIFIER_UUID, "Covered armor bonus", 20.0, AttributeModifier.Operation.ADD_VALUE);
    protected static final DataWatcherObject<EnumDirection> DATA_ATTACH_FACE_ID = DataWatcher.defineId(EntityShulker.class, DataWatcherRegistry.DIRECTION);
    protected static final DataWatcherObject<Byte> DATA_PEEK_ID = DataWatcher.defineId(EntityShulker.class, DataWatcherRegistry.BYTE);
    public static final DataWatcherObject<Byte> DATA_COLOR_ID = DataWatcher.defineId(EntityShulker.class, DataWatcherRegistry.BYTE);
    private static final int TELEPORT_STEPS = 6;
    private static final byte NO_COLOR = 16;
    private static final byte DEFAULT_COLOR = 16;
    private static final int MAX_TELEPORT_DISTANCE = 8;
    private static final int OTHER_SHULKER_SCAN_RADIUS = 8;
    private static final int OTHER_SHULKER_LIMIT = 5;
    private static final float PEEK_PER_TICK = 0.05f;
    static final Vector3f FORWARD = SystemUtils.make(() -> {
        BaseBlockPosition var0 = EnumDirection.SOUTH.getNormal();
        return new Vector3f((float)var0.getX(), (float)var0.getY(), (float)var0.getZ());
    });
    private static final float MAX_SCALE = 3.0f;
    private float currentPeekAmountO;
    private float currentPeekAmount;
    @Nullable
    private BlockPosition clientOldAttachPosition;
    private int clientSideTeleportInterpolation;
    private static final float MAX_LID_OPEN = 1.0f;

    public EntityShulker(EntityTypes<? extends EntityShulker> var0, World var1) {
        super((EntityTypes<? extends EntityGolem>)var0, var1);
        this.xpReward = 5;
        this.lookControl = new d(this);
    }

    @Override
    protected void registerGoals() {
        this.goalSelector.addGoal(1, new PathfinderGoalLookAtPlayer(this, EntityHuman.class, 8.0f, 0.02f, true));
        this.goalSelector.addGoal(4, new a());
        this.goalSelector.addGoal(7, new f());
        this.goalSelector.addGoal(8, new PathfinderGoalRandomLookaround(this));
        this.targetSelector.addGoal(1, new PathfinderGoalHurtByTarget(this, this.getClass()).setAlertOthers(new Class[0]));
        this.targetSelector.addGoal(2, new e(this));
        this.targetSelector.addGoal(3, new c(this));
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public SoundCategory getSoundSource() {
        return SoundCategory.HOSTILE;
    }

    @Override
    protected SoundEffect getAmbientSound() {
        return SoundEffects.SHULKER_AMBIENT;
    }

    @Override
    public void playAmbientSound() {
        if (!this.isClosed()) {
            super.playAmbientSound();
        }
    }

    @Override
    protected SoundEffect getDeathSound() {
        return SoundEffects.SHULKER_DEATH;
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        if (this.isClosed()) {
            return SoundEffects.SHULKER_HURT_CLOSED;
        }
        return SoundEffects.SHULKER_HURT;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_ATTACH_FACE_ID, EnumDirection.DOWN);
        var0.define(DATA_PEEK_ID, (byte)0);
        var0.define(DATA_COLOR_ID, (byte)16);
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 30.0);
    }

    @Override
    protected EntityAIBodyControl createBodyControl() {
        return new b(this);
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setAttachFace(EnumDirection.from3DDataValue(var0.getByte("AttachFace")));
        this.entityData.set(DATA_PEEK_ID, var0.getByte("Peek"));
        if (var0.contains("Color", 99)) {
            this.entityData.set(DATA_COLOR_ID, var0.getByte("Color"));
        }
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putByte("AttachFace", (byte)this.getAttachFace().get3DDataValue());
        var0.putByte("Peek", this.entityData.get(DATA_PEEK_ID));
        var0.putByte("Color", this.entityData.get(DATA_COLOR_ID));
    }

    @Override
    public void tick() {
        super.tick();
        if (!(this.level().isClientSide || this.isPassenger() || this.canStayAt(this.blockPosition(), this.getAttachFace()))) {
            this.findNewAttachment();
        }
        if (this.updatePeekAmount()) {
            this.onPeekAmountChange();
        }
        if (this.level().isClientSide) {
            if (this.clientSideTeleportInterpolation > 0) {
                --this.clientSideTeleportInterpolation;
            } else {
                this.clientOldAttachPosition = null;
            }
        }
    }

    private void findNewAttachment() {
        EnumDirection var0 = this.findAttachableSurface(this.blockPosition());
        if (var0 != null) {
            this.setAttachFace(var0);
        } else {
            this.teleportSomewhere();
        }
    }

    @Override
    protected AxisAlignedBB makeBoundingBox() {
        float var0 = EntityShulker.getPhysicalPeek(this.currentPeekAmount);
        EnumDirection var1 = this.getAttachFace().getOpposite();
        float var2 = this.getBbWidth() / 2.0f;
        return EntityShulker.getProgressAabb(this.getScale(), var1, var0).move(this.getX() - (double)var2, this.getY(), this.getZ() - (double)var2);
    }

    private static float getPhysicalPeek(float var0) {
        return 0.5f - MathHelper.sin((0.5f + var0) * (float)Math.PI) * 0.5f;
    }

    private boolean updatePeekAmount() {
        this.currentPeekAmountO = this.currentPeekAmount;
        float var0 = (float)this.getRawPeekAmount() * 0.01f;
        if (this.currentPeekAmount == var0) {
            return false;
        }
        this.currentPeekAmount = this.currentPeekAmount > var0 ? MathHelper.clamp(this.currentPeekAmount - 0.05f, var0, 1.0f) : MathHelper.clamp(this.currentPeekAmount + 0.05f, 0.0f, var0);
        return true;
    }

    private void onPeekAmountChange() {
        this.reapplyPosition();
        float var02 = EntityShulker.getPhysicalPeek(this.currentPeekAmount);
        float var1 = EntityShulker.getPhysicalPeek(this.currentPeekAmountO);
        EnumDirection var2 = this.getAttachFace().getOpposite();
        float var3 = (var02 - var1) * this.getScale();
        if (var3 <= 0.0f) {
            return;
        }
        List<Entity> var4 = this.level().getEntities(this, EntityShulker.getProgressDeltaAabb(this.getScale(), var2, var1, var02).move(this.getX() - 0.5, this.getY(), this.getZ() - 0.5), IEntitySelector.NO_SPECTATORS.and(var0 -> !var0.isPassengerOfSameVehicle(this)));
        for (Entity var6 : var4) {
            if (var6 instanceof EntityShulker || var6.noPhysics) continue;
            var6.move(EnumMoveType.SHULKER, new Vec3D(var3 * (float)var2.getStepX(), var3 * (float)var2.getStepY(), var3 * (float)var2.getStepZ()));
        }
    }

    public static AxisAlignedBB getProgressAabb(float var0, EnumDirection var1, float var2) {
        return EntityShulker.getProgressDeltaAabb(var0, var1, -1.0f, var2);
    }

    public static AxisAlignedBB getProgressDeltaAabb(float var0, EnumDirection var1, float var2, float var3) {
        AxisAlignedBB var4 = new AxisAlignedBB(0.0, 0.0, 0.0, var0, var0, var0);
        double var5 = Math.max(var2, var3);
        double var7 = Math.min(var2, var3);
        return var4.expandTowards((double)var1.getStepX() * var5 * (double)var0, (double)var1.getStepY() * var5 * (double)var0, (double)var1.getStepZ() * var5 * (double)var0).contract((double)(-var1.getStepX()) * (1.0 + var7) * (double)var0, (double)(-var1.getStepY()) * (1.0 + var7) * (double)var0, (double)(-var1.getStepZ()) * (1.0 + var7) * (double)var0);
    }

    @Override
    public boolean startRiding(Entity var0, boolean var1) {
        if (this.level().isClientSide()) {
            this.clientOldAttachPosition = null;
            this.clientSideTeleportInterpolation = 0;
        }
        this.setAttachFace(EnumDirection.DOWN);
        return super.startRiding(var0, var1);
    }

    @Override
    public void stopRiding() {
        super.stopRiding();
        if (this.level().isClientSide) {
            this.clientOldAttachPosition = this.blockPosition();
        }
        this.yBodyRotO = 0.0f;
        this.yBodyRot = 0.0f;
    }

    @Override
    @Nullable
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        this.setYRot(0.0f);
        this.yHeadRot = this.getYRot();
        this.setOldPosAndRot();
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public void move(EnumMoveType var0, Vec3D var1) {
        if (var0 == EnumMoveType.SHULKER_BOX) {
            this.teleportSomewhere();
        } else {
            super.move(var0, var1);
        }
    }

    @Override
    public Vec3D getDeltaMovement() {
        return Vec3D.ZERO;
    }

    @Override
    public void setDeltaMovement(Vec3D var0) {
    }

    @Override
    public void setPos(double var0, double var2, double var4) {
        BlockPosition var6 = this.blockPosition();
        if (this.isPassenger()) {
            super.setPos(var0, var2, var4);
        } else {
            super.setPos((double)MathHelper.floor(var0) + 0.5, MathHelper.floor(var2 + 0.5), (double)MathHelper.floor(var4) + 0.5);
        }
        if (this.tickCount == 0) {
            return;
        }
        BlockPosition var7 = this.blockPosition();
        if (!var7.equals(var6)) {
            this.entityData.set(DATA_PEEK_ID, (byte)0);
            this.hasImpulse = true;
            if (this.level().isClientSide && !this.isPassenger() && !var7.equals(this.clientOldAttachPosition)) {
                this.clientOldAttachPosition = var6;
                this.clientSideTeleportInterpolation = 6;
                this.xOld = this.getX();
                this.yOld = this.getY();
                this.zOld = this.getZ();
            }
        }
    }

    @Nullable
    protected EnumDirection findAttachableSurface(BlockPosition var0) {
        for (EnumDirection var4 : EnumDirection.values()) {
            if (!this.canStayAt(var0, var4)) continue;
            return var4;
        }
        return null;
    }

    boolean canStayAt(BlockPosition var0, EnumDirection var1) {
        if (this.isPositionBlocked(var0)) {
            return false;
        }
        EnumDirection var2 = var1.getOpposite();
        if (!this.level().loadedAndEntityCanStandOnFace(var0.relative(var1), this, var2)) {
            return false;
        }
        AxisAlignedBB var3 = EntityShulker.getProgressAabb(this.getScale(), var2, 1.0f).move(var0).deflate(1.0E-6);
        return this.level().noCollision(this, var3);
    }

    private boolean isPositionBlocked(BlockPosition var0) {
        IBlockData var1 = this.level().getBlockState(var0);
        if (var1.isAir()) {
            return false;
        }
        boolean var2 = var1.is(Blocks.MOVING_PISTON) && var0.equals(this.blockPosition());
        return !var2;
    }

    protected boolean teleportSomewhere() {
        if (this.isNoAi() || !this.isAlive()) {
            return false;
        }
        BlockPosition var0 = this.blockPosition();
        for (int var1 = 0; var1 < 5; ++var1) {
            EnumDirection var3;
            BlockPosition var2 = var0.offset(MathHelper.randomBetweenInclusive(this.random, -8, 8), MathHelper.randomBetweenInclusive(this.random, -8, 8), MathHelper.randomBetweenInclusive(this.random, -8, 8));
            if (var2.getY() <= this.level().getMinBuildHeight() || !this.level().isEmptyBlock(var2) || !this.level().getWorldBorder().isWithinBounds(var2) || !this.level().noCollision(this, new AxisAlignedBB(var2).deflate(1.0E-6)) || (var3 = this.findAttachableSurface(var2)) == null) continue;
            this.unRide();
            this.setAttachFace(var3);
            this.playSound(SoundEffects.SHULKER_TELEPORT, 1.0f, 1.0f);
            this.setPos((double)var2.getX() + 0.5, var2.getY(), (double)var2.getZ() + 0.5);
            this.level().gameEvent(GameEvent.TELEPORT, var0, GameEvent.a.of(this));
            this.entityData.set(DATA_PEEK_ID, (byte)0);
            this.setTarget(null);
            return true;
        }
        return false;
    }

    @Override
    public void lerpTo(double var0, double var2, double var4, float var6, float var7, int var8) {
        this.lerpSteps = 0;
        this.setPos(var0, var2, var4);
        this.setRot(var6, var7);
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        Entity var2;
        if (this.isClosed() && (var2 = var0.getDirectEntity()) instanceof EntityArrow) {
            return false;
        }
        if (super.hurt(var0, var1)) {
            if ((double)this.getHealth() < (double)this.getMaxHealth() * 0.5 && this.random.nextInt(4) == 0) {
                this.teleportSomewhere();
            } else if (var0.is(DamageTypeTags.IS_PROJECTILE) && (var2 = var0.getDirectEntity()) != null && var2.getType() == EntityTypes.SHULKER_BULLET) {
                this.hitByShulkerBullet();
            }
            return true;
        }
        return false;
    }

    private boolean isClosed() {
        return this.getRawPeekAmount() == 0;
    }

    private void hitByShulkerBullet() {
        Vec3D var0 = this.position();
        AxisAlignedBB var1 = this.getBoundingBox();
        if (this.isClosed() || !this.teleportSomewhere()) {
            return;
        }
        int var2 = this.level().getEntities(EntityTypes.SHULKER, var1.inflate(8.0), Entity::isAlive).size();
        float var3 = (float)(var2 - 1) / 5.0f;
        if (this.level().random.nextFloat() < var3) {
            return;
        }
        EntityShulker var4 = EntityTypes.SHULKER.create(this.level());
        if (var4 != null) {
            var4.setVariant((Optional<EnumColor>)this.getVariant());
            var4.moveTo(var0);
            this.level().addFreshEntity(var4);
        }
    }

    @Override
    public boolean canBeCollidedWith() {
        return this.isAlive();
    }

    public EnumDirection getAttachFace() {
        return this.entityData.get(DATA_ATTACH_FACE_ID);
    }

    public void setAttachFace(EnumDirection var0) {
        this.entityData.set(DATA_ATTACH_FACE_ID, var0);
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_ATTACH_FACE_ID.equals(var0)) {
            this.setBoundingBox(this.makeBoundingBox());
        }
        super.onSyncedDataUpdated(var0);
    }

    public int getRawPeekAmount() {
        return this.entityData.get(DATA_PEEK_ID).byteValue();
    }

    public void setRawPeekAmount(int var0) {
        if (!this.level().isClientSide) {
            this.getAttribute(GenericAttributes.ARMOR).removeModifier(COVERED_ARMOR_MODIFIER.id());
            if (var0 == 0) {
                this.getAttribute(GenericAttributes.ARMOR).addPermanentModifier(COVERED_ARMOR_MODIFIER);
                this.playSound(SoundEffects.SHULKER_CLOSE, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_CLOSE);
            } else {
                this.playSound(SoundEffects.SHULKER_OPEN, 1.0f, 1.0f);
                this.gameEvent(GameEvent.CONTAINER_OPEN);
            }
        }
        this.entityData.set(DATA_PEEK_ID, (byte)var0);
    }

    public float getClientPeekAmount(float var0) {
        return MathHelper.lerp(var0, this.currentPeekAmountO, this.currentPeekAmount);
    }

    @Override
    public void recreateFromPacket(PacketPlayOutSpawnEntity var0) {
        super.recreateFromPacket(var0);
        this.yBodyRot = 0.0f;
        this.yBodyRotO = 0.0f;
    }

    @Override
    public int getMaxHeadXRot() {
        return 180;
    }

    @Override
    public int getMaxHeadYRot() {
        return 180;
    }

    @Override
    public void push(Entity var0) {
    }

    public Optional<Vec3D> getRenderPosition(float var0) {
        if (this.clientOldAttachPosition == null || this.clientSideTeleportInterpolation <= 0) {
            return Optional.empty();
        }
        double var1 = (double)((float)this.clientSideTeleportInterpolation - var0) / 6.0;
        var1 *= var1;
        BlockPosition var3 = this.blockPosition();
        double var4 = (double)(var3.getX() - this.clientOldAttachPosition.getX()) * var1;
        double var6 = (double)(var3.getY() - this.clientOldAttachPosition.getY()) * var1;
        double var8 = (double)(var3.getZ() - this.clientOldAttachPosition.getZ()) * var1;
        return Optional.of(new Vec3D(-var4, -var6, -var8));
    }

    @Override
    protected float sanitizeScale(float var0) {
        return Math.min(var0, 3.0f);
    }

    @Override
    public void setVariant(Optional<EnumColor> var02) {
        this.entityData.set(DATA_COLOR_ID, var02.map(var0 -> (byte)var0.getId()).orElse((byte)16));
    }

    @Override
    public Optional<EnumColor> getVariant() {
        return Optional.ofNullable(this.getColor());
    }

    @Nullable
    public EnumColor getColor() {
        byte var0 = this.entityData.get(DATA_COLOR_ID);
        if (var0 == 16 || var0 > 15) {
            return null;
        }
        return EnumColor.byId(var0);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    class d
    extends ControllerLook {
        public d(EntityInsentient var1) {
            super(var1);
        }

        @Override
        protected void clampHeadRotationToBody() {
        }

        @Override
        protected Optional<Float> getYRotD() {
            EnumDirection var0 = EntityShulker.this.getAttachFace().getOpposite();
            Vector3f var1 = var0.getRotation().transform(new Vector3f((Vector3fc)FORWARD));
            BaseBlockPosition var2 = var0.getNormal();
            Vector3f var3 = new Vector3f((float)var2.getX(), (float)var2.getY(), (float)var2.getZ());
            var3.cross((Vector3fc)var1);
            double var4 = this.wantedX - this.mob.getX();
            double var6 = this.wantedY - this.mob.getEyeY();
            double var8 = this.wantedZ - this.mob.getZ();
            Vector3f var10 = new Vector3f((float)var4, (float)var6, (float)var8);
            float var11 = var3.dot((Vector3fc)var10);
            float var12 = var1.dot((Vector3fc)var10);
            return Math.abs(var11) > 1.0E-5f || Math.abs(var12) > 1.0E-5f ? Optional.of(Float.valueOf((float)(MathHelper.atan2(-var11, var12) * 57.2957763671875))) : Optional.empty();
        }

        @Override
        protected Optional<Float> getXRotD() {
            return Optional.of(Float.valueOf(0.0f));
        }
    }

    class a
    extends PathfinderGoal {
        private int attackTime;

        public a() {
            this.setFlags(EnumSet.of(PathfinderGoal.Type.MOVE, PathfinderGoal.Type.LOOK));
        }

        @Override
        public boolean canUse() {
            EntityLiving var0 = EntityShulker.this.getTarget();
            if (var0 == null || !var0.isAlive()) {
                return false;
            }
            return EntityShulker.this.level().getDifficulty() != EnumDifficulty.PEACEFUL;
        }

        @Override
        public void start() {
            this.attackTime = 20;
            EntityShulker.this.setRawPeekAmount(100);
        }

        @Override
        public void stop() {
            EntityShulker.this.setRawPeekAmount(0);
        }

        @Override
        public boolean requiresUpdateEveryTick() {
            return true;
        }

        @Override
        public void tick() {
            if (EntityShulker.this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
                return;
            }
            --this.attackTime;
            EntityLiving var0 = EntityShulker.this.getTarget();
            if (var0 == null) {
                return;
            }
            EntityShulker.this.getLookControl().setLookAt(var0, 180.0f, 180.0f);
            double var1 = EntityShulker.this.distanceToSqr(var0);
            if (var1 < 400.0) {
                if (this.attackTime <= 0) {
                    this.attackTime = 20 + EntityShulker.this.random.nextInt(10) * 20 / 2;
                    EntityShulker.this.level().addFreshEntity(new EntityShulkerBullet(EntityShulker.this.level(), EntityShulker.this, var0, EntityShulker.this.getAttachFace().getAxis()));
                    EntityShulker.this.playSound(SoundEffects.SHULKER_SHOOT, 2.0f, (EntityShulker.this.random.nextFloat() - EntityShulker.this.random.nextFloat()) * 0.2f + 1.0f);
                }
            } else {
                EntityShulker.this.setTarget(null);
            }
            super.tick();
        }
    }

    class f
    extends PathfinderGoal {
        private int peekTime;

        f() {
        }

        @Override
        public boolean canUse() {
            return EntityShulker.this.getTarget() == null && EntityShulker.this.random.nextInt(f.reducedTickDelay(40)) == 0 && EntityShulker.this.canStayAt(EntityShulker.this.blockPosition(), EntityShulker.this.getAttachFace());
        }

        @Override
        public boolean canContinueToUse() {
            return EntityShulker.this.getTarget() == null && this.peekTime > 0;
        }

        @Override
        public void start() {
            this.peekTime = this.adjustedTickDelay(20 * (1 + EntityShulker.this.random.nextInt(3)));
            EntityShulker.this.setRawPeekAmount(30);
        }

        @Override
        public void stop() {
            if (EntityShulker.this.getTarget() == null) {
                EntityShulker.this.setRawPeekAmount(0);
            }
        }

        @Override
        public void tick() {
            --this.peekTime;
        }
    }

    class e
    extends PathfinderGoalNearestAttackableTarget<EntityHuman> {
        public e(EntityShulker var1) {
            super((EntityInsentient)var1, EntityHuman.class, true);
        }

        @Override
        public boolean canUse() {
            if (EntityShulker.this.level().getDifficulty() == EnumDifficulty.PEACEFUL) {
                return false;
            }
            return super.canUse();
        }

        @Override
        protected AxisAlignedBB getTargetSearchArea(double var0) {
            EnumDirection var2 = ((EntityShulker)this.mob).getAttachFace();
            if (var2.getAxis() == EnumDirection.EnumAxis.X) {
                return this.mob.getBoundingBox().inflate(4.0, var0, var0);
            }
            if (var2.getAxis() == EnumDirection.EnumAxis.Z) {
                return this.mob.getBoundingBox().inflate(var0, var0, 4.0);
            }
            return this.mob.getBoundingBox().inflate(var0, 4.0, var0);
        }
    }

    static class c
    extends PathfinderGoalNearestAttackableTarget<EntityLiving> {
        public c(EntityShulker var02) {
            super(var02, EntityLiving.class, 10, true, false, var0 -> var0 instanceof IMonster);
        }

        @Override
        public boolean canUse() {
            if (this.mob.getTeam() == null) {
                return false;
            }
            return super.canUse();
        }

        @Override
        protected AxisAlignedBB getTargetSearchArea(double var0) {
            EnumDirection var2 = ((EntityShulker)this.mob).getAttachFace();
            if (var2.getAxis() == EnumDirection.EnumAxis.X) {
                return this.mob.getBoundingBox().inflate(4.0, var0, var0);
            }
            if (var2.getAxis() == EnumDirection.EnumAxis.Z) {
                return this.mob.getBoundingBox().inflate(var0, var0, 4.0);
            }
            return this.mob.getBoundingBox().inflate(var0, 4.0, var0);
        }
    }

    static class b
    extends EntityAIBodyControl {
        public b(EntityInsentient var0) {
            super(var0);
        }

        @Override
        public void clientTick() {
        }
    }
}

