/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.item;

import javax.annotation.Nullable;
import net.minecraft.core.particles.Particles;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;

public class EntityTNTPrimed
extends Entity
implements TraceableEntity {
    private static final DataWatcherObject<Integer> DATA_FUSE_ID = DataWatcher.defineId(EntityTNTPrimed.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<IBlockData> DATA_BLOCK_STATE_ID = DataWatcher.defineId(EntityTNTPrimed.class, DataWatcherRegistry.BLOCK_STATE);
    private static final int DEFAULT_FUSE_TIME = 80;
    private static final String TAG_BLOCK_STATE = "block_state";
    public static final String TAG_FUSE = "fuse";
    @Nullable
    public EntityLiving owner;

    public EntityTNTPrimed(EntityTypes<? extends EntityTNTPrimed> var0, World var1) {
        super(var0, var1);
        this.blocksBuilding = true;
    }

    public EntityTNTPrimed(World var0, double var1, double var3, double var5, @Nullable EntityLiving var7) {
        this((EntityTypes<? extends EntityTNTPrimed>)EntityTypes.TNT, var0);
        this.setPos(var1, var3, var5);
        double var8 = var0.random.nextDouble() * 6.2831854820251465;
        this.setDeltaMovement(-Math.sin(var8) * 0.02, 0.2f, -Math.cos(var8) * 0.02);
        this.setFuse(80);
        this.xo = var1;
        this.yo = var3;
        this.zo = var5;
        this.owner = var7;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_FUSE_ID, 80);
        var0.define(DATA_BLOCK_STATE_ID, Blocks.TNT.defaultBlockState());
    }

    @Override
    protected Entity.MovementEmission getMovementEmission() {
        return Entity.MovementEmission.NONE;
    }

    @Override
    public boolean isPickable() {
        return !this.isRemoved();
    }

    @Override
    protected double getDefaultGravity() {
        return 0.04;
    }

    @Override
    public void tick() {
        this.applyGravity();
        this.move(EnumMoveType.SELF, this.getDeltaMovement());
        this.setDeltaMovement(this.getDeltaMovement().scale(0.98));
        if (this.onGround()) {
            this.setDeltaMovement(this.getDeltaMovement().multiply(0.7, -0.5, 0.7));
        }
        int var0 = this.getFuse() - 1;
        this.setFuse(var0);
        if (var0 <= 0) {
            this.discard();
            if (!this.level().isClientSide) {
                this.explode();
            }
        } else {
            this.updateInWaterStateAndDoFluidPushing();
            if (this.level().isClientSide) {
                this.level().addParticle(Particles.SMOKE, this.getX(), this.getY() + 0.5, this.getZ(), 0.0, 0.0, 0.0);
            }
        }
    }

    private void explode() {
        float var0 = 4.0f;
        this.level().explode(this, this.getX(), this.getY(0.0625), this.getZ(), 4.0f, World.a.TNT);
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putShort(TAG_FUSE, (short)this.getFuse());
        var0.put(TAG_BLOCK_STATE, GameProfileSerializer.writeBlockState(this.getBlockState()));
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var0) {
        this.setFuse(var0.getShort(TAG_FUSE));
        if (var0.contains(TAG_BLOCK_STATE, 10)) {
            this.setBlockState(GameProfileSerializer.readBlockState(this.level().holderLookup(Registries.BLOCK), var0.getCompound(TAG_BLOCK_STATE)));
        }
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        return this.owner;
    }

    @Override
    public void restoreFrom(Entity var0) {
        super.restoreFrom(var0);
        if (var0 instanceof EntityTNTPrimed) {
            EntityTNTPrimed var1 = (EntityTNTPrimed)var0;
            this.owner = var1.owner;
        }
    }

    public void setFuse(int var0) {
        this.entityData.set(DATA_FUSE_ID, var0);
    }

    public int getFuse() {
        return this.entityData.get(DATA_FUSE_ID);
    }

    public void setBlockState(IBlockData var0) {
        this.entityData.set(DATA_BLOCK_STATE_ID, var0);
    }

    public IBlockData getBlockState() {
        return this.entityData.get(DATA_BLOCK_STATE_ID);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

