/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal.axolotl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.IntFunction;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsItem;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.INamable;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.EnumHand;
import net.minecraft.world.EnumInteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityAgeable;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.EnumMoveType;
import net.minecraft.world.entity.GroupDataEntity;
import net.minecraft.world.entity.LerpingModel;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import net.minecraft.world.entity.ai.attributes.GenericAttributes;
import net.minecraft.world.entity.ai.control.SmoothSwimmingLookControl;
import net.minecraft.world.entity.ai.control.SmoothSwimmingMoveControl;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.AmphibiousPathNavigation;
import net.minecraft.world.entity.ai.navigation.NavigationAbstract;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.animal.Bucketable;
import net.minecraft.world.entity.animal.EntityAnimal;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldAccess;
import net.minecraft.world.level.pathfinder.PathType;
import net.minecraft.world.phys.Vec3D;
import org.joml.Vector3f;

public class Axolotl
extends EntityAnimal
implements LerpingModel,
VariantHolder<Variant>,
Bucketable {
    public static final int TOTAL_PLAYDEAD_TIME = 200;
    protected static final ImmutableList<? extends SensorType<? extends Sensor<? super Axolotl>>> SENSOR_TYPES = ImmutableList.of(SensorType.NEAREST_LIVING_ENTITIES, SensorType.NEAREST_ADULT, SensorType.HURT_BY, SensorType.AXOLOTL_ATTACKABLES, SensorType.AXOLOTL_TEMPTATIONS);
    protected static final ImmutableList<? extends MemoryModuleType<?>> MEMORY_TYPES = ImmutableList.of(MemoryModuleType.BREED_TARGET, MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, MemoryModuleType.LOOK_TARGET, MemoryModuleType.WALK_TARGET, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE, MemoryModuleType.PATH, MemoryModuleType.ATTACK_TARGET, MemoryModuleType.ATTACK_COOLING_DOWN, MemoryModuleType.NEAREST_VISIBLE_ADULT, (Object[])new MemoryModuleType[]{MemoryModuleType.HURT_BY_ENTITY, MemoryModuleType.PLAY_DEAD_TICKS, MemoryModuleType.NEAREST_ATTACKABLE, MemoryModuleType.TEMPTING_PLAYER, MemoryModuleType.TEMPTATION_COOLDOWN_TICKS, MemoryModuleType.IS_TEMPTED, MemoryModuleType.HAS_HUNTING_COOLDOWN, MemoryModuleType.IS_PANICKING});
    private static final DataWatcherObject<Integer> DATA_VARIANT = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.INT);
    private static final DataWatcherObject<Boolean> DATA_PLAYING_DEAD = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<Boolean> FROM_BUCKET = DataWatcher.defineId(Axolotl.class, DataWatcherRegistry.BOOLEAN);
    public static final double PLAYER_REGEN_DETECTION_RANGE = 20.0;
    public static final int RARE_VARIANT_CHANCE = 1200;
    private static final int AXOLOTL_TOTAL_AIR_SUPPLY = 6000;
    public static final String VARIANT_TAG = "Variant";
    private static final int REHYDRATE_AIR_SUPPLY = 1800;
    private static final int REGEN_BUFF_MAX_DURATION = 2400;
    private final Map<String, Vector3f> modelRotationValues = Maps.newHashMap();
    private static final int REGEN_BUFF_BASE_DURATION = 100;

    public Axolotl(EntityTypes<? extends Axolotl> var0, World var1) {
        super((EntityTypes<? extends EntityAnimal>)var0, var1);
        this.setPathfindingMalus(PathType.WATER, 0.0f);
        this.moveControl = new c(this);
        this.lookControl = new b(this, 20);
    }

    @Override
    public Map<String, Vector3f> getModelRotationValues() {
        return this.modelRotationValues;
    }

    @Override
    public float getWalkTargetValue(BlockPosition var0, IWorldReader var1) {
        return 0.0f;
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        super.defineSynchedData(var0);
        var0.define(DATA_VARIANT, 0);
        var0.define(DATA_PLAYING_DEAD, false);
        var0.define(FROM_BUCKET, false);
    }

    @Override
    public void addAdditionalSaveData(NBTTagCompound var0) {
        super.addAdditionalSaveData(var0);
        var0.putInt(VARIANT_TAG, this.getVariant().getId());
        var0.putBoolean("FromBucket", this.fromBucket());
    }

    @Override
    public void readAdditionalSaveData(NBTTagCompound var0) {
        super.readAdditionalSaveData(var0);
        this.setVariant(Variant.byId(var0.getInt(VARIANT_TAG)));
        this.setFromBucket(var0.getBoolean("FromBucket"));
    }

    @Override
    public void playAmbientSound() {
        if (this.isPlayingDead()) {
            return;
        }
        super.playAmbientSound();
    }

    @Override
    public GroupDataEntity finalizeSpawn(WorldAccess var0, DifficultyDamageScaler var1, EnumMobSpawn var2, @Nullable GroupDataEntity var3) {
        boolean var4 = false;
        if (var2 == EnumMobSpawn.BUCKET) {
            return var3;
        }
        RandomSource var5 = var0.getRandom();
        if (var3 instanceof a) {
            if (((a)var3).getGroupSize() >= 2) {
                var4 = true;
            }
        } else {
            var3 = new a(Variant.getCommonSpawnVariant(var5), Variant.getCommonSpawnVariant(var5));
        }
        this.setVariant(((a)var3).getVariant(var5));
        if (var4) {
            this.setAge(-24000);
        }
        return super.finalizeSpawn(var0, var1, var2, var3);
    }

    @Override
    public void baseTick() {
        int var0 = this.getAirSupply();
        super.baseTick();
        if (!this.isNoAi()) {
            this.handleAirSupply(var0);
        }
    }

    protected void handleAirSupply(int var0) {
        if (this.isAlive() && !this.isInWaterRainOrBubble()) {
            this.setAirSupply(var0 - 1);
            if (this.getAirSupply() == -20) {
                this.setAirSupply(0);
                this.hurt(this.damageSources().dryOut(), 2.0f);
            }
        } else {
            this.setAirSupply(this.getMaxAirSupply());
        }
    }

    public void rehydrate() {
        int var0 = this.getAirSupply() + 1800;
        this.setAirSupply(Math.min(var0, this.getMaxAirSupply()));
    }

    @Override
    public int getMaxAirSupply() {
        return 6000;
    }

    @Override
    public Variant getVariant() {
        return Variant.byId(this.entityData.get(DATA_VARIANT));
    }

    @Override
    public void setVariant(Variant var0) {
        this.entityData.set(DATA_VARIANT, var0.getId());
    }

    private static boolean useRareVariant(RandomSource var0) {
        return var0.nextInt(1200) == 0;
    }

    @Override
    public boolean checkSpawnObstruction(IWorldReader var0) {
        return var0.isUnobstructed(this);
    }

    @Override
    public boolean isPushedByFluid() {
        return false;
    }

    public void setPlayingDead(boolean var0) {
        this.entityData.set(DATA_PLAYING_DEAD, var0);
    }

    public boolean isPlayingDead() {
        return this.entityData.get(DATA_PLAYING_DEAD);
    }

    @Override
    public boolean fromBucket() {
        return this.entityData.get(FROM_BUCKET);
    }

    @Override
    public void setFromBucket(boolean var0) {
        this.entityData.set(FROM_BUCKET, var0);
    }

    @Override
    @Nullable
    public EntityAgeable getBreedOffspring(WorldServer var0, EntityAgeable var1) {
        Axolotl var2 = EntityTypes.AXOLOTL.create(var0);
        if (var2 != null) {
            Variant var3 = Axolotl.useRareVariant(this.random) ? Variant.getRareSpawnVariant(this.random) : (this.random.nextBoolean() ? this.getVariant() : ((Axolotl)var1).getVariant());
            var2.setVariant(var3);
            var2.setPersistenceRequired();
        }
        return var2;
    }

    @Override
    public boolean isFood(ItemStack var0) {
        return var0.is(TagsItem.AXOLOTL_FOOD);
    }

    @Override
    public boolean canBeLeashed(EntityHuman var0) {
        return true;
    }

    @Override
    protected void customServerAiStep() {
        this.level().getProfiler().push("axolotlBrain");
        this.getBrain().tick((WorldServer)this.level(), this);
        this.level().getProfiler().pop();
        this.level().getProfiler().push("axolotlActivityUpdate");
        AxolotlAi.updateActivity(this);
        this.level().getProfiler().pop();
        if (!this.isNoAi()) {
            Optional<Integer> var0 = this.getBrain().getMemory(MemoryModuleType.PLAY_DEAD_TICKS);
            this.setPlayingDead(var0.isPresent() && var0.get() > 0);
        }
    }

    public static AttributeProvider.Builder createAttributes() {
        return EntityInsentient.createMobAttributes().add(GenericAttributes.MAX_HEALTH, 14.0).add(GenericAttributes.MOVEMENT_SPEED, 1.0).add(GenericAttributes.ATTACK_DAMAGE, 2.0).add(GenericAttributes.STEP_HEIGHT, 1.0);
    }

    @Override
    protected NavigationAbstract createNavigation(World var0) {
        return new AmphibiousPathNavigation(this, var0);
    }

    @Override
    public boolean doHurtTarget(Entity var0) {
        boolean var1 = var0.hurt(this.damageSources().mobAttack(this), (int)this.getAttributeValue(GenericAttributes.ATTACK_DAMAGE));
        if (var1) {
            this.doEnchantDamageEffects(this, var0);
            this.playSound(SoundEffects.AXOLOTL_ATTACK, 1.0f, 1.0f);
        }
        return var1;
    }

    @Override
    public boolean hurt(DamageSource var0, float var1) {
        float var2 = this.getHealth();
        if (!(this.level().isClientSide || this.isNoAi() || this.level().random.nextInt(3) != 0 || !((float)this.level().random.nextInt(3) < var1) && !(var2 / this.getMaxHealth() < 0.5f) || !(var1 < var2) || !this.isInWater() || var0.getEntity() == null && var0.getDirectEntity() == null || this.isPlayingDead())) {
            this.brain.setMemory(MemoryModuleType.PLAY_DEAD_TICKS, 200);
        }
        return super.hurt(var0, var1);
    }

    @Override
    public int getMaxHeadXRot() {
        return 1;
    }

    @Override
    public int getMaxHeadYRot() {
        return 1;
    }

    @Override
    public EnumInteractionResult mobInteract(EntityHuman var0, EnumHand var1) {
        return Bucketable.bucketMobPickup(var0, var1, this).orElse(super.mobInteract(var0, var1));
    }

    @Override
    public void saveToBucketTag(ItemStack var02) {
        Bucketable.saveDefaultDataToBucketTag(this, var02);
        CustomData.update(DataComponents.BUCKET_ENTITY_DATA, var02, var0 -> {
            var0.putInt(VARIANT_TAG, this.getVariant().getId());
            var0.putInt("Age", this.getAge());
            BehaviorController<Axolotl> var1 = this.getBrain();
            if (var1.hasMemoryValue(MemoryModuleType.HAS_HUNTING_COOLDOWN)) {
                var0.putLong("HuntingCooldown", var1.getTimeUntilExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN));
            }
        });
    }

    @Override
    public void loadFromBucketTag(NBTTagCompound var0) {
        Bucketable.loadDefaultDataFromBucketTag(this, var0);
        this.setVariant(Variant.byId(var0.getInt(VARIANT_TAG)));
        if (var0.contains("Age")) {
            this.setAge(var0.getInt("Age"));
        }
        if (var0.contains("HuntingCooldown")) {
            this.getBrain().setMemoryWithExpiry(MemoryModuleType.HAS_HUNTING_COOLDOWN, true, var0.getLong("HuntingCooldown"));
        }
    }

    @Override
    public ItemStack getBucketItemStack() {
        return new ItemStack(Items.AXOLOTL_BUCKET);
    }

    @Override
    public SoundEffect getPickupSound() {
        return SoundEffects.BUCKET_FILL_AXOLOTL;
    }

    @Override
    public boolean canBeSeenAsEnemy() {
        return !this.isPlayingDead() && super.canBeSeenAsEnemy();
    }

    public static void onStopAttacking(Axolotl var0, EntityLiving var1) {
        Entity var4;
        DamageSource var3;
        World var2 = var0.level();
        if (var1.isDeadOrDying() && (var3 = var1.getLastDamageSource()) != null && (var4 = var3.getEntity()) != null && var4.getType() == EntityTypes.PLAYER) {
            EntityHuman var5 = (EntityHuman)var4;
            List<EntityHuman> var6 = var2.getEntitiesOfClass(EntityHuman.class, var0.getBoundingBox().inflate(20.0));
            if (var6.contains(var5)) {
                var0.applySupportingEffects(var5);
            }
        }
    }

    public void applySupportingEffects(EntityHuman var0) {
        MobEffect var1 = var0.getEffect(MobEffects.REGENERATION);
        if (var1 == null || var1.endsWithin(2399)) {
            int var2 = var1 != null ? var1.getDuration() : 0;
            int var3 = Math.min(2400, 100 + var2);
            var0.addEffect(new MobEffect(MobEffects.REGENERATION, var3, 0), this);
        }
        var0.removeEffect(MobEffects.DIG_SLOWDOWN);
    }

    @Override
    public boolean requiresCustomPersistence() {
        return super.requiresCustomPersistence() || this.fromBucket();
    }

    @Override
    protected SoundEffect getHurtSound(DamageSource var0) {
        return SoundEffects.AXOLOTL_HURT;
    }

    @Override
    @Nullable
    protected SoundEffect getDeathSound() {
        return SoundEffects.AXOLOTL_DEATH;
    }

    @Override
    @Nullable
    protected SoundEffect getAmbientSound() {
        return this.isInWater() ? SoundEffects.AXOLOTL_IDLE_WATER : SoundEffects.AXOLOTL_IDLE_AIR;
    }

    @Override
    protected SoundEffect getSwimSplashSound() {
        return SoundEffects.AXOLOTL_SPLASH;
    }

    @Override
    protected SoundEffect getSwimSound() {
        return SoundEffects.AXOLOTL_SWIM;
    }

    protected BehaviorController.b<Axolotl> brainProvider() {
        return BehaviorController.provider(MEMORY_TYPES, SENSOR_TYPES);
    }

    @Override
    protected BehaviorController<?> makeBrain(Dynamic<?> var0) {
        return AxolotlAi.makeBrain(this.brainProvider().makeBrain(var0));
    }

    public BehaviorController<Axolotl> getBrain() {
        return super.getBrain();
    }

    @Override
    protected void sendDebugPackets() {
        super.sendDebugPackets();
        PacketDebug.sendEntityBrain(this);
    }

    @Override
    public void travel(Vec3D var0) {
        if (this.isControlledByLocalInstance() && this.isInWater()) {
            this.moveRelative(this.getSpeed(), var0);
            this.move(EnumMoveType.SELF, this.getDeltaMovement());
            this.setDeltaMovement(this.getDeltaMovement().scale(0.9));
        } else {
            super.travel(var0);
        }
    }

    @Override
    protected void usePlayerItem(EntityHuman var0, EnumHand var1, ItemStack var2) {
        if (var2.is(Items.TROPICAL_FISH_BUCKET)) {
            var0.setItemInHand(var1, new ItemStack(Items.WATER_BUCKET));
        } else {
            super.usePlayerItem(var0, var1, var2);
        }
    }

    @Override
    public boolean removeWhenFarAway(double var0) {
        return !this.fromBucket() && !this.hasCustomName();
    }

    @Override
    @Nullable
    public EntityLiving getTarget() {
        return this.getTargetFromBrain();
    }

    public static boolean checkAxolotlSpawnRules(EntityTypes<? extends EntityLiving> var0, WorldAccess var1, EnumMobSpawn var2, BlockPosition var3, RandomSource var4) {
        return var1.getBlockState(var3.below()).is(TagsBlock.AXOLOTLS_SPAWNABLE_ON);
    }

    @Override
    public /* synthetic */ Object getVariant() {
        return this.getVariant();
    }

    static class c
    extends SmoothSwimmingMoveControl {
        private final Axolotl axolotl;

        public c(Axolotl var0) {
            super(var0, 85, 10, 0.1f, 0.5f, false);
            this.axolotl = var0;
        }

        @Override
        public void tick() {
            if (!this.axolotl.isPlayingDead()) {
                super.tick();
            }
        }
    }

    class b
    extends SmoothSwimmingLookControl {
        public b(Axolotl var1, int var2) {
            super(var1, var2);
        }

        @Override
        public void tick() {
            if (!Axolotl.this.isPlayingDead()) {
                super.tick();
            }
        }
    }

    public static final class Variant
    extends Enum<Variant>
    implements INamable {
        public static final /* enum */ Variant LUCY = new Variant(0, "lucy", true);
        public static final /* enum */ Variant WILD = new Variant(1, "wild", true);
        public static final /* enum */ Variant GOLD = new Variant(2, "gold", true);
        public static final /* enum */ Variant CYAN = new Variant(3, "cyan", true);
        public static final /* enum */ Variant BLUE = new Variant(4, "blue", false);
        private static final IntFunction<Variant> BY_ID;
        public static final Codec<Variant> CODEC;
        private final int id;
        private final String name;
        private final boolean common;
        private static final /* synthetic */ Variant[] k;

        public static Variant[] values() {
            return (Variant[])k.clone();
        }

        public static Variant valueOf(String var0) {
            return Enum.valueOf(Variant.class, var0);
        }

        private Variant(int var2, String var3, boolean var4) {
            this.id = var2;
            this.name = var3;
            this.common = var4;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        @Override
        public String getSerializedName() {
            return this.name;
        }

        public static Variant byId(int var0) {
            return BY_ID.apply(var0);
        }

        public static Variant getCommonSpawnVariant(RandomSource var0) {
            return Variant.getSpawnVariant(var0, true);
        }

        public static Variant getRareSpawnVariant(RandomSource var0) {
            return Variant.getSpawnVariant(var0, false);
        }

        private static Variant getSpawnVariant(RandomSource var0, boolean var12) {
            Variant[] var2 = (Variant[])Arrays.stream(Variant.values()).filter(var1 -> var1.common == var12).toArray(Variant[]::new);
            return SystemUtils.getRandom(var2, var0);
        }

        private static /* synthetic */ Variant[] d() {
            return new Variant[]{LUCY, WILD, GOLD, CYAN, BLUE};
        }

        static {
            k = Variant.d();
            BY_ID = ByIdMap.continuous(Variant::getId, Variant.values(), ByIdMap.a.ZERO);
            CODEC = INamable.fromEnum(Variant::values);
        }
    }

    public static class a
    extends EntityAgeable.a {
        public final Variant[] types;

        public a(Variant ... var0) {
            super(false);
            this.types = var0;
        }

        public Variant getVariant(RandomSource var0) {
            return this.types[var0.nextInt(this.types.length)];
        }
    }
}

