/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.animal;

import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.Biomes;

public class WolfVariants {
    public static final ResourceKey<WolfVariant> PALE = WolfVariants.createKey("pale");
    public static final ResourceKey<WolfVariant> SPOTTED = WolfVariants.createKey("spotted");
    public static final ResourceKey<WolfVariant> SNOWY = WolfVariants.createKey("snowy");
    public static final ResourceKey<WolfVariant> BLACK = WolfVariants.createKey("black");
    public static final ResourceKey<WolfVariant> ASHEN = WolfVariants.createKey("ashen");
    public static final ResourceKey<WolfVariant> RUSTY = WolfVariants.createKey("rusty");
    public static final ResourceKey<WolfVariant> WOODS = WolfVariants.createKey("woods");
    public static final ResourceKey<WolfVariant> CHESTNUT = WolfVariants.createKey("chestnut");
    public static final ResourceKey<WolfVariant> STRIPED = WolfVariants.createKey("striped");

    private static ResourceKey<WolfVariant> createKey(String var0) {
        return ResourceKey.create(Registries.WOLF_VARIANT, new MinecraftKey(var0));
    }

    static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, ResourceKey<BiomeBase> var3) {
        WolfVariants.register(var0, var1, var2, HolderSet.direct(var0.lookup(Registries.BIOME).getOrThrow(var3)));
    }

    static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, TagKey<BiomeBase> var3) {
        WolfVariants.register(var0, var1, var2, var0.lookup(Registries.BIOME).getOrThrow(var3));
    }

    static void register(BootstrapContext<WolfVariant> var0, ResourceKey<WolfVariant> var1, String var2, HolderSet<BiomeBase> var3) {
        MinecraftKey var4 = new MinecraftKey("entity/wolf/" + var2);
        MinecraftKey var5 = new MinecraftKey("entity/wolf/" + var2 + "_tame");
        MinecraftKey var6 = new MinecraftKey("entity/wolf/" + var2 + "_angry");
        var0.register(var1, new WolfVariant(var4, var5, var6, var3));
    }

    public static Holder<WolfVariant> getSpawnVariant(IRegistryCustom var0, Holder<BiomeBase> var12) {
        IRegistry<WolfVariant> var2 = var0.registryOrThrow(Registries.WOLF_VARIANT);
        return var2.holders().filter(var1 -> ((WolfVariant)var1.value()).biomes().contains(var12)).findFirst().orElse(var2.getHolderOrThrow(PALE));
    }

    public static void bootstrap(BootstrapContext<WolfVariant> var0) {
        WolfVariants.register(var0, PALE, "wolf", Biomes.TAIGA);
        WolfVariants.register(var0, SPOTTED, "wolf_spotted", BiomeTags.IS_SAVANNA);
        WolfVariants.register(var0, SNOWY, "wolf_snowy", Biomes.GROVE);
        WolfVariants.register(var0, BLACK, "wolf_black", Biomes.OLD_GROWTH_PINE_TAIGA);
        WolfVariants.register(var0, ASHEN, "wolf_ashen", Biomes.SNOWY_TAIGA);
        WolfVariants.register(var0, RUSTY, "wolf_rusty", BiomeTags.IS_JUNGLE);
        WolfVariants.register(var0, WOODS, "wolf_woods", Biomes.FOREST);
        WolfVariants.register(var0, CHESTNUT, "wolf_chestnut", Biomes.OLD_GROWTH_SPRUCE_TAIGA);
        WolfVariants.register(var0, STRIPED, "wolf_striped", BiomeTags.IS_BADLANDS);
    }
}

