/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.sensing;

import java.util.function.Supplier;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.AxolotlAttackablesSensor;
import net.minecraft.world.entity.ai.sensing.BreezeAttackEntitySensor;
import net.minecraft.world.entity.ai.sensing.FrogAttackablesSensor;
import net.minecraft.world.entity.ai.sensing.IsInWaterSensor;
import net.minecraft.world.entity.ai.sensing.MobSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorAdult;
import net.minecraft.world.entity.ai.sensing.SensorDummy;
import net.minecraft.world.entity.ai.sensing.SensorGolemLastSeen;
import net.minecraft.world.entity.ai.sensing.SensorHoglinSpecific;
import net.minecraft.world.entity.ai.sensing.SensorHurtBy;
import net.minecraft.world.entity.ai.sensing.SensorNearestBed;
import net.minecraft.world.entity.ai.sensing.SensorNearestItems;
import net.minecraft.world.entity.ai.sensing.SensorNearestLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorNearestPlayers;
import net.minecraft.world.entity.ai.sensing.SensorPiglinBruteSpecific;
import net.minecraft.world.entity.ai.sensing.SensorPiglinSpecific;
import net.minecraft.world.entity.ai.sensing.SensorSecondaryPlaces;
import net.minecraft.world.entity.ai.sensing.SensorVillagerBabies;
import net.minecraft.world.entity.ai.sensing.SensorVillagerHostiles;
import net.minecraft.world.entity.ai.sensing.TemptingSensor;
import net.minecraft.world.entity.ai.sensing.WardenEntitySensor;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.armadillo.ArmadilloAi;
import net.minecraft.world.entity.animal.axolotl.AxolotlAi;
import net.minecraft.world.entity.animal.camel.CamelAi;
import net.minecraft.world.entity.animal.frog.FrogAi;
import net.minecraft.world.entity.animal.goat.GoatAi;
import net.minecraft.world.entity.animal.sniffer.SnifferAi;

public class SensorType<U extends Sensor<?>> {
    public static final SensorType<SensorDummy> DUMMY = SensorType.register("dummy", SensorDummy::new);
    public static final SensorType<SensorNearestItems> NEAREST_ITEMS = SensorType.register("nearest_items", SensorNearestItems::new);
    public static final SensorType<SensorNearestLivingEntities<EntityLiving>> NEAREST_LIVING_ENTITIES = SensorType.register("nearest_living_entities", SensorNearestLivingEntities::new);
    public static final SensorType<SensorNearestPlayers> NEAREST_PLAYERS = SensorType.register("nearest_players", SensorNearestPlayers::new);
    public static final SensorType<SensorNearestBed> NEAREST_BED = SensorType.register("nearest_bed", SensorNearestBed::new);
    public static final SensorType<SensorHurtBy> HURT_BY = SensorType.register("hurt_by", SensorHurtBy::new);
    public static final SensorType<SensorVillagerHostiles> VILLAGER_HOSTILES = SensorType.register("villager_hostiles", SensorVillagerHostiles::new);
    public static final SensorType<SensorVillagerBabies> VILLAGER_BABIES = SensorType.register("villager_babies", SensorVillagerBabies::new);
    public static final SensorType<SensorSecondaryPlaces> SECONDARY_POIS = SensorType.register("secondary_pois", SensorSecondaryPlaces::new);
    public static final SensorType<SensorGolemLastSeen> GOLEM_DETECTED = SensorType.register("golem_detected", SensorGolemLastSeen::new);
    public static final SensorType<MobSensor<Armadillo>> ARMADILLO_SCARE_DETECTED = SensorType.register("armadillo_scare_detected", () -> new MobSensor<Armadillo>(5, Armadillo::isScaredBy, Armadillo::canStayRolledUp, MemoryModuleType.DANGER_DETECTED_RECENTLY, 80));
    public static final SensorType<SensorPiglinSpecific> PIGLIN_SPECIFIC_SENSOR = SensorType.register("piglin_specific_sensor", SensorPiglinSpecific::new);
    public static final SensorType<SensorPiglinBruteSpecific> PIGLIN_BRUTE_SPECIFIC_SENSOR = SensorType.register("piglin_brute_specific_sensor", SensorPiglinBruteSpecific::new);
    public static final SensorType<SensorHoglinSpecific> HOGLIN_SPECIFIC_SENSOR = SensorType.register("hoglin_specific_sensor", SensorHoglinSpecific::new);
    public static final SensorType<SensorAdult> NEAREST_ADULT = SensorType.register("nearest_adult", SensorAdult::new);
    public static final SensorType<AxolotlAttackablesSensor> AXOLOTL_ATTACKABLES = SensorType.register("axolotl_attackables", AxolotlAttackablesSensor::new);
    public static final SensorType<TemptingSensor> AXOLOTL_TEMPTATIONS = SensorType.register("axolotl_temptations", () -> new TemptingSensor(AxolotlAi.getTemptations()));
    public static final SensorType<TemptingSensor> GOAT_TEMPTATIONS = SensorType.register("goat_temptations", () -> new TemptingSensor(GoatAi.getTemptations()));
    public static final SensorType<TemptingSensor> FROG_TEMPTATIONS = SensorType.register("frog_temptations", () -> new TemptingSensor(FrogAi.getTemptations()));
    public static final SensorType<TemptingSensor> CAMEL_TEMPTATIONS = SensorType.register("camel_temptations", () -> new TemptingSensor(CamelAi.getTemptations()));
    public static final SensorType<TemptingSensor> ARMADILLO_TEMPTATIONS = SensorType.register("armadillo_temptations", () -> new TemptingSensor(ArmadilloAi.getTemptations()));
    public static final SensorType<FrogAttackablesSensor> FROG_ATTACKABLES = SensorType.register("frog_attackables", FrogAttackablesSensor::new);
    public static final SensorType<IsInWaterSensor> IS_IN_WATER = SensorType.register("is_in_water", IsInWaterSensor::new);
    public static final SensorType<WardenEntitySensor> WARDEN_ENTITY_SENSOR = SensorType.register("warden_entity_sensor", WardenEntitySensor::new);
    public static final SensorType<TemptingSensor> SNIFFER_TEMPTATIONS = SensorType.register("sniffer_temptations", () -> new TemptingSensor(SnifferAi.getTemptations()));
    public static final SensorType<BreezeAttackEntitySensor> BREEZE_ATTACK_ENTITY_SENSOR = SensorType.register("breeze_attack_entity_sensor", BreezeAttackEntitySensor::new);
    private final Supplier<U> factory;

    private SensorType(Supplier<U> var0) {
        this.factory = var0;
    }

    public U create() {
        return (U)((Sensor)this.factory.get());
    }

    private static <U extends Sensor<?>> SensorType<U> register(String var0, Supplier<U> var1) {
        return IRegistry.register(BuiltInRegistries.SENSOR_TYPE, new MinecraftKey(var0), new SensorType<U>(var1));
    }
}

