/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.mojang.datafixers.kinds.Applicative;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityCreature;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorTarget;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryTarget;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.phys.shapes.VoxelShapeCollision;
import org.apache.commons.lang3.mutable.MutableLong;

public class TryFindLand {
    private static final int COOLDOWN_TICKS = 60;

    public static BehaviorControl<EntityCreature> create(int var0, float var1) {
        MutableLong var2 = new MutableLong(0L);
        return BehaviorBuilder.create(var32 -> var32.group(var32.absent(MemoryModuleType.ATTACK_TARGET), var32.absent(MemoryModuleType.WALK_TARGET), var32.registered(MemoryModuleType.LOOK_TARGET)).apply((Applicative)var32, (var3, var4, var52) -> (var5, var6, var7) -> {
            if (!var5.getFluidState(var6.blockPosition()).is(TagsFluid.WATER)) {
                return false;
            }
            if (var7 < var2.getValue()) {
                var2.setValue(var7 + 60L);
                return true;
            }
            BlockPosition var9 = var6.blockPosition();
            BlockPosition.MutableBlockPosition var10 = new BlockPosition.MutableBlockPosition();
            VoxelShapeCollision var11 = VoxelShapeCollision.of(var6);
            for (BlockPosition var13 : BlockPosition.withinManhattan(var9, var0, var0, var0)) {
                if (var13.getX() == var9.getX() && var13.getZ() == var9.getZ()) continue;
                IBlockData var14 = var5.getBlockState(var13);
                IBlockData var15 = var5.getBlockState(var10.setWithOffset((BaseBlockPosition)var13, EnumDirection.DOWN));
                if (var14.is(Blocks.WATER) || !var5.getFluidState(var13).isEmpty() || !var14.getCollisionShape(var5, var13, var11).isEmpty() || !var15.isFaceSturdy(var5, var10, EnumDirection.UP)) continue;
                BlockPosition var16 = var13.immutable();
                var52.set(new BehaviorTarget(var16));
                var4.set(new MemoryTarget(new BehaviorTarget(var16), var1, 1));
                break;
            }
            var2.setValue(var7 + 60L);
            return true;
        }));
    }
}

