/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.kinds.OptionalBox;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.GlobalPos;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.BehaviorController;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.behavior.declarative.MemoryAccessor;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.level.block.BlockDoor;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.level.pathfinder.PathPoint;
import org.apache.commons.lang3.mutable.MutableInt;
import org.apache.commons.lang3.mutable.MutableObject;

public class BehaviorInteractDoor {
    private static final int COOLDOWN_BEFORE_RERUNNING_IN_SAME_NODE = 20;
    private static final double SKIP_CLOSING_DOOR_IF_FURTHER_AWAY_THAN = 3.0;
    private static final double MAX_DISTANCE_TO_HOLD_DOOR_OPEN_FOR_OTHER_MOBS = 2.0;

    public static BehaviorControl<EntityLiving> create() {
        MutableObject var0 = new MutableObject(null);
        MutableInt var1 = new MutableInt(0);
        return BehaviorBuilder.create(var2 -> var2.group(var2.present(MemoryModuleType.PATH), var2.registered(MemoryModuleType.DOORS_TO_CLOSE), var2.registered(MemoryModuleType.NEAREST_LIVING_ENTITIES)).apply((Applicative)var2, (var3, var4, var5) -> (var62, var7, var8) -> {
            BlockDoor var18;
            IBlockData var17;
            Object var16;
            PathEntity var10 = (PathEntity)var2.get(var3);
            Optional<Set<GlobalPos>> var11 = var2.tryGet(var4);
            if (var10.notStarted() || var10.isDone()) {
                return false;
            }
            if (Objects.equals(var0.getValue(), var10.getNextNode())) {
                var1.setValue(20);
            } else if (var1.decrementAndGet() > 0) {
                return false;
            }
            var0.setValue((Object)var10.getNextNode());
            PathPoint var12 = var10.getPreviousNode();
            PathPoint var13 = var10.getNextNode();
            BlockPosition var14 = var12.asBlockPos();
            IBlockData var15 = var62.getBlockState(var14);
            if (var15.is(TagsBlock.WOODEN_DOORS, var0 -> var0.getBlock() instanceof BlockDoor)) {
                var16 = (BlockDoor)var15.getBlock();
                if (!((BlockDoor)var16).isOpen(var15)) {
                    ((BlockDoor)var16).setOpen(var7, var62, var15, var14, true);
                }
                var11 = BehaviorInteractDoor.rememberDoorToClose(var4, var11, var62, var14);
            }
            if ((var17 = var62.getBlockState((BlockPosition)(var16 = var13.asBlockPos()))).is(TagsBlock.WOODEN_DOORS, var0 -> var0.getBlock() instanceof BlockDoor) && !(var18 = (BlockDoor)var17.getBlock()).isOpen(var17)) {
                var18.setOpen(var7, var62, var17, (BlockPosition)var16, true);
                var11 = BehaviorInteractDoor.rememberDoorToClose(var4, var11, var62, (BlockPosition)var16);
            }
            var11.ifPresent(var6 -> BehaviorInteractDoor.closeDoorsThatIHaveOpenedOrPassedThrough(var62, var7, var12, var13, var6, var2.tryGet(var5)));
            return true;
        }));
    }

    public static void closeDoorsThatIHaveOpenedOrPassedThrough(WorldServer var02, EntityLiving var1, @Nullable PathPoint var2, @Nullable PathPoint var3, Set<GlobalPos> var4, Optional<List<EntityLiving>> var5) {
        Iterator<GlobalPos> var6 = var4.iterator();
        while (var6.hasNext()) {
            GlobalPos var7 = var6.next();
            BlockPosition var8 = var7.pos();
            if (var2 != null && var2.asBlockPos().equals(var8) || var3 != null && var3.asBlockPos().equals(var8)) continue;
            if (BehaviorInteractDoor.isDoorTooFarAway(var02, var1, var7)) {
                var6.remove();
                continue;
            }
            IBlockData var9 = var02.getBlockState(var8);
            if (!var9.is(TagsBlock.WOODEN_DOORS, var0 -> var0.getBlock() instanceof BlockDoor)) {
                var6.remove();
                continue;
            }
            BlockDoor var10 = (BlockDoor)var9.getBlock();
            if (!var10.isOpen(var9)) {
                var6.remove();
                continue;
            }
            if (BehaviorInteractDoor.areOtherMobsComingThroughDoor(var1, var8, var5)) {
                var6.remove();
                continue;
            }
            var10.setOpen(var1, var02, var9, var8, false);
            var6.remove();
        }
    }

    private static boolean areOtherMobsComingThroughDoor(EntityLiving var0, BlockPosition var12, Optional<List<EntityLiving>> var2) {
        if (var2.isEmpty()) {
            return false;
        }
        return var2.get().stream().filter(var1 -> var1.getType() == var0.getType()).filter(var1 -> var12.closerToCenterThan(var1.position(), 2.0)).anyMatch(var1 -> BehaviorInteractDoor.isMobComingThroughDoor(var1.getBrain(), var12));
    }

    private static boolean isMobComingThroughDoor(BehaviorController<?> var0, BlockPosition var1) {
        if (!var0.hasMemoryValue(MemoryModuleType.PATH)) {
            return false;
        }
        PathEntity var2 = var0.getMemory(MemoryModuleType.PATH).get();
        if (var2.isDone()) {
            return false;
        }
        PathPoint var3 = var2.getPreviousNode();
        if (var3 == null) {
            return false;
        }
        PathPoint var4 = var2.getNextNode();
        return var1.equals(var3.asBlockPos()) || var1.equals(var4.asBlockPos());
    }

    private static boolean isDoorTooFarAway(WorldServer var0, EntityLiving var1, GlobalPos var2) {
        return var2.dimension() != var0.dimension() || !var2.pos().closerToCenterThan(var1.position(), 3.0);
    }

    private static Optional<Set<GlobalPos>> rememberDoorToClose(MemoryAccessor<OptionalBox.Mu, Set<GlobalPos>> var0, Optional<Set<GlobalPos>> var12, WorldServer var2, BlockPosition var3) {
        GlobalPos var4 = GlobalPos.of(var2.dimension(), var3);
        return Optional.of(var12.map(var1 -> {
            var1.add(var4);
            return var1;
        }).orElseGet(() -> {
            HashSet var2 = Sets.newHashSet((Object[])new GlobalPos[]{var4});
            var0.set(var2);
            return var2;
        }));
    }
}

