/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.core.component.DataComponents;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorPositionEntity;
import net.minecraft.world.entity.ai.behavior.BehaviorUtil;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.ICrossbow;
import net.minecraft.world.entity.monster.IRangedEntity;
import net.minecraft.world.entity.projectile.ProjectileHelper;
import net.minecraft.world.item.ItemCrossbow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.ChargedProjectiles;

public class BehaviorCrossbowAttack<E extends EntityInsentient, T extends EntityLiving>
extends Behavior<E> {
    private static final int TIMEOUT = 1200;
    private int attackDelay;
    private BowState crossbowState = BowState.UNCHARGED;

    public BehaviorCrossbowAttack() {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.LOOK_TARGET, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.ATTACK_TARGET, (Object)((Object)MemoryStatus.VALUE_PRESENT)), 1200);
    }

    @Override
    protected boolean checkExtraStartConditions(WorldServer var0, E var1) {
        EntityLiving var2 = BehaviorCrossbowAttack.getAttackTarget(var1);
        return ((EntityLiving)var1).isHolding(Items.CROSSBOW) && BehaviorUtil.canSee(var1, var2) && BehaviorUtil.isWithinAttackRange(var1, var2, 0);
    }

    @Override
    protected boolean canStillUse(WorldServer var0, E var1, long var2) {
        return ((EntityLiving)var1).getBrain().hasMemoryValue(MemoryModuleType.ATTACK_TARGET) && this.checkExtraStartConditions(var0, var1);
    }

    @Override
    protected void tick(WorldServer var0, E var1, long var2) {
        EntityLiving var4 = BehaviorCrossbowAttack.getAttackTarget(var1);
        this.lookAtTarget((EntityInsentient)var1, var4);
        this.crossbowAttack(var1, var4);
    }

    @Override
    protected void stop(WorldServer var0, E var1, long var2) {
        if (((EntityLiving)var1).isUsingItem()) {
            ((EntityLiving)var1).stopUsingItem();
        }
        if (((EntityLiving)var1).isHolding(Items.CROSSBOW)) {
            ((ICrossbow)var1).setChargingCrossbow(false);
            ((EntityLiving)var1).getUseItem().set(DataComponents.CHARGED_PROJECTILES, ChargedProjectiles.EMPTY);
        }
    }

    private void crossbowAttack(E var0, EntityLiving var1) {
        if (this.crossbowState == BowState.UNCHARGED) {
            ((EntityLiving)var0).startUsingItem(ProjectileHelper.getWeaponHoldingHand(var0, Items.CROSSBOW));
            this.crossbowState = BowState.CHARGING;
            ((ICrossbow)var0).setChargingCrossbow(true);
        } else if (this.crossbowState == BowState.CHARGING) {
            ItemStack var3;
            int var2;
            if (!((EntityLiving)var0).isUsingItem()) {
                this.crossbowState = BowState.UNCHARGED;
            }
            if ((var2 = ((EntityLiving)var0).getTicksUsingItem()) >= ItemCrossbow.getChargeDuration(var3 = ((EntityLiving)var0).getUseItem())) {
                ((EntityLiving)var0).releaseUsingItem();
                this.crossbowState = BowState.CHARGED;
                this.attackDelay = 20 + ((EntityLiving)var0).getRandom().nextInt(20);
                ((ICrossbow)var0).setChargingCrossbow(false);
            }
        } else if (this.crossbowState == BowState.CHARGED) {
            --this.attackDelay;
            if (this.attackDelay == 0) {
                this.crossbowState = BowState.READY_TO_ATTACK;
            }
        } else if (this.crossbowState == BowState.READY_TO_ATTACK) {
            ((IRangedEntity)var0).performRangedAttack(var1, 1.0f);
            this.crossbowState = BowState.UNCHARGED;
        }
    }

    private void lookAtTarget(EntityInsentient var0, EntityLiving var1) {
        var0.getBrain().setMemory(MemoryModuleType.LOOK_TARGET, new BehaviorPositionEntity(var1, true));
    }

    private static EntityLiving getAttackTarget(EntityLiving var0) {
        return var0.getBrain().getMemory(MemoryModuleType.ATTACK_TARGET).get();
    }

    @Override
    protected /* synthetic */ void stop(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.stop(worldServer, (E)((EntityInsentient)entityLiving), l2);
    }

    @Override
    protected /* synthetic */ void tick(WorldServer worldServer, EntityLiving entityLiving, long l2) {
        this.tick(worldServer, (E)((EntityInsentient)entityLiving), l2);
    }

    static final class BowState
    extends Enum<BowState> {
        public static final /* enum */ BowState UNCHARGED = new BowState();
        public static final /* enum */ BowState CHARGING = new BowState();
        public static final /* enum */ BowState CHARGED = new BowState();
        public static final /* enum */ BowState READY_TO_ATTACK = new BowState();
        private static final /* synthetic */ BowState[] e;

        public static BowState[] values() {
            return (BowState[])e.clone();
        }

        public static BowState valueOf(String var0) {
            return Enum.valueOf(BowState.class, var0);
        }

        private static /* synthetic */ BowState[] a() {
            return new BowState[]{UNCHARGED, CHARGING, CHARGED, READY_TO_ATTACK};
        }

        static {
            e = BowState.a();
        }
    }
}

