/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.attributes;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifiable;
import net.minecraft.world.entity.ai.attributes.AttributeProvider;
import org.slf4j.Logger;

public class AttributeMapBase {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<Holder<AttributeBase>, AttributeModifiable> attributes = new Object2ObjectOpenHashMap();
    private final Set<AttributeModifiable> dirtyAttributes = new ObjectOpenHashSet();
    private final AttributeProvider supplier;

    public AttributeMapBase(AttributeProvider var0) {
        this.supplier = var0;
    }

    private void onAttributeModified(AttributeModifiable var0) {
        if (var0.getAttribute().value().isClientSyncable()) {
            this.dirtyAttributes.add(var0);
        }
    }

    public Set<AttributeModifiable> getDirtyAttributes() {
        return this.dirtyAttributes;
    }

    public Collection<AttributeModifiable> getSyncableAttributes() {
        return this.attributes.values().stream().filter(var0 -> var0.getAttribute().value().isClientSyncable()).collect(Collectors.toList());
    }

    @Nullable
    public AttributeModifiable getInstance(Holder<AttributeBase> var02) {
        return this.attributes.computeIfAbsent(var02, var0 -> this.supplier.createInstance(this::onAttributeModified, (Holder<AttributeBase>)var0));
    }

    public boolean hasAttribute(Holder<AttributeBase> var0) {
        return this.attributes.get(var0) != null || this.supplier.hasAttribute(var0);
    }

    public boolean hasModifier(Holder<AttributeBase> var0, UUID var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1) != null : this.supplier.hasModifier(var0, var1);
    }

    public double getValue(Holder<AttributeBase> var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getValue() : this.supplier.getValue(var0);
    }

    public double getBaseValue(Holder<AttributeBase> var0) {
        AttributeModifiable var1 = this.attributes.get(var0);
        return var1 != null ? var1.getBaseValue() : this.supplier.getBaseValue(var0);
    }

    public double getModifierValue(Holder<AttributeBase> var0, UUID var1) {
        AttributeModifiable var2 = this.attributes.get(var0);
        return var2 != null ? var2.getModifier(var1).amount() : this.supplier.getModifierValue(var0, var1);
    }

    public void assignValues(AttributeMapBase var02) {
        var02.attributes.values().forEach(var0 -> {
            AttributeModifiable var1 = this.getInstance(var0.getAttribute());
            if (var1 != null) {
                var1.replaceFrom((AttributeModifiable)var0);
            }
        });
    }

    public NBTTagList save() {
        NBTTagList var0 = new NBTTagList();
        for (AttributeModifiable var2 : this.attributes.values()) {
            var0.add(var2.save());
        }
        return var0;
    }

    public void load(NBTTagList var0) {
        for (int var12 = 0; var12 < var0.size(); ++var12) {
            NBTTagCompound var2 = var0.getCompound(var12);
            String var3 = var2.getString("Name");
            MinecraftKey var4 = MinecraftKey.tryParse(var3);
            if (var4 != null) {
                SystemUtils.ifElse(BuiltInRegistries.ATTRIBUTE.getHolder(var4), var1 -> {
                    AttributeModifiable var2 = this.getInstance((Holder<AttributeBase>)var1);
                    if (var2 != null) {
                        var2.load(var2);
                    }
                }, () -> LOGGER.warn("Ignoring unknown attribute '{}'", (Object)var4));
                continue;
            }
            LOGGER.warn("Ignoring malformed attribute '{}'", (Object)var3);
        }
    }
}

