/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ColorParticleOption;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.particles.Particles;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.syncher.DataWatcher;
import net.minecraft.network.syncher.DataWatcherObject;
import net.minecraft.network.syncher.DataWatcherRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.MathHelper;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityPose;
import net.minecraft.world.entity.EntitySize;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.TraceableEntity;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import org.slf4j.Logger;

public class EntityAreaEffectCloud
extends Entity
implements TraceableEntity {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int TIME_BETWEEN_APPLICATIONS = 5;
    private static final DataWatcherObject<Float> DATA_RADIUS = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.FLOAT);
    private static final DataWatcherObject<Boolean> DATA_WAITING = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.BOOLEAN);
    private static final DataWatcherObject<ParticleParam> DATA_PARTICLE = DataWatcher.defineId(EntityAreaEffectCloud.class, DataWatcherRegistry.PARTICLE);
    private static final float MAX_RADIUS = 32.0f;
    private static final float MINIMAL_RADIUS = 0.5f;
    private static final float DEFAULT_RADIUS = 3.0f;
    public static final float DEFAULT_WIDTH = 6.0f;
    public static final float HEIGHT = 0.5f;
    public PotionContents potionContents = PotionContents.EMPTY;
    private final Map<Entity, Integer> victims = Maps.newHashMap();
    private int duration = 600;
    public int waitTime = 20;
    public int reapplicationDelay = 20;
    public int durationOnUse;
    public float radiusOnUse;
    public float radiusPerTick;
    @Nullable
    private EntityLiving owner;
    @Nullable
    private UUID ownerUUID;

    public EntityAreaEffectCloud(EntityTypes<? extends EntityAreaEffectCloud> var0, World var1) {
        super(var0, var1);
        this.noPhysics = true;
    }

    public EntityAreaEffectCloud(World var0, double var1, double var3, double var5) {
        this((EntityTypes<? extends EntityAreaEffectCloud>)EntityTypes.AREA_EFFECT_CLOUD, var0);
        this.setPos(var1, var3, var5);
    }

    @Override
    protected void defineSynchedData(DataWatcher.a var0) {
        var0.define(DATA_RADIUS, Float.valueOf(3.0f));
        var0.define(DATA_WAITING, false);
        var0.define(DATA_PARTICLE, ColorParticleOption.create(Particles.ENTITY_EFFECT, -1));
    }

    public void setRadius(float var0) {
        if (!this.level().isClientSide) {
            this.getEntityData().set(DATA_RADIUS, Float.valueOf(MathHelper.clamp(var0, 0.0f, 32.0f)));
        }
    }

    @Override
    public void refreshDimensions() {
        double var0 = this.getX();
        double var2 = this.getY();
        double var4 = this.getZ();
        super.refreshDimensions();
        this.setPos(var0, var2, var4);
    }

    public float getRadius() {
        return this.getEntityData().get(DATA_RADIUS).floatValue();
    }

    public void setPotionContents(PotionContents var0) {
        this.potionContents = var0;
        this.updateColor();
    }

    public void updateColor() {
        ParticleParam var0 = this.entityData.get(DATA_PARTICLE);
        if (var0 instanceof ColorParticleOption) {
            ColorParticleOption var1 = (ColorParticleOption)var0;
            int var2 = this.potionContents.equals(PotionContents.EMPTY) ? 0 : this.potionContents.getColor();
            this.entityData.set(DATA_PARTICLE, ColorParticleOption.create(var1.getType(), ColorUtil.b.opaque(var2)));
        }
    }

    public void addEffect(MobEffect var0) {
        this.setPotionContents(this.potionContents.withEffectAdded(var0));
    }

    public ParticleParam getParticle() {
        return this.getEntityData().get(DATA_PARTICLE);
    }

    public void setParticle(ParticleParam var0) {
        this.getEntityData().set(DATA_PARTICLE, var0);
    }

    protected void setWaiting(boolean var0) {
        this.getEntityData().set(DATA_WAITING, var0);
    }

    public boolean isWaiting() {
        return this.getEntityData().get(DATA_WAITING);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int var0) {
        this.duration = var0;
    }

    @Override
    public void tick() {
        block20: {
            float var1;
            block21: {
                boolean var2;
                boolean var02;
                block19: {
                    float var4;
                    int var3;
                    super.tick();
                    var02 = this.isWaiting();
                    var1 = this.getRadius();
                    if (!this.level().isClientSide) break block19;
                    if (var02 && this.random.nextBoolean()) {
                        return;
                    }
                    ParticleParam var22 = this.getParticle();
                    if (var02) {
                        var3 = 2;
                        var4 = 0.2f;
                    } else {
                        var3 = MathHelper.ceil((float)Math.PI * var1 * var1);
                        var4 = var1;
                    }
                    for (int var5 = 0; var5 < var3; ++var5) {
                        float var6 = this.random.nextFloat() * ((float)Math.PI * 2);
                        float var7 = MathHelper.sqrt(this.random.nextFloat()) * var4;
                        double var8 = this.getX() + (double)(MathHelper.cos(var6) * var7);
                        double var10 = this.getY();
                        double var12 = this.getZ() + (double)(MathHelper.sin(var6) * var7);
                        if (var22.getType() == Particles.ENTITY_EFFECT) {
                            if (var02 && this.random.nextBoolean()) {
                                this.level().addAlwaysVisibleParticle(ColorParticleOption.create(Particles.ENTITY_EFFECT, -1), var8, var10, var12, 0.0, 0.0, 0.0);
                                continue;
                            }
                            this.level().addAlwaysVisibleParticle(var22, var8, var10, var12, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (var02) {
                            this.level().addAlwaysVisibleParticle(var22, var8, var10, var12, 0.0, 0.0, 0.0);
                            continue;
                        }
                        this.level().addAlwaysVisibleParticle(var22, var8, var10, var12, (0.5 - this.random.nextDouble()) * 0.15, 0.01f, (0.5 - this.random.nextDouble()) * 0.15);
                    }
                    break block20;
                }
                if (this.tickCount >= this.waitTime + this.duration) {
                    this.discard();
                    return;
                }
                boolean bl = var2 = this.tickCount < this.waitTime;
                if (var02 != var2) {
                    this.setWaiting(var2);
                }
                if (var2) {
                    return;
                }
                if (this.radiusPerTick != 0.0f) {
                    if ((var1 += this.radiusPerTick) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(var1);
                }
                if (this.tickCount % 5 != 0) break block20;
                this.victims.entrySet().removeIf(var0 -> this.tickCount >= (Integer)var0.getValue());
                if (this.potionContents.hasEffects()) break block21;
                this.victims.clear();
                break block20;
            }
            ArrayList var3 = Lists.newArrayList();
            if (this.potionContents.potion().isPresent()) {
                for (MobEffect var5 : this.potionContents.potion().get().value().getEffects()) {
                    var3.add(new MobEffect(var5.getEffect(), var5.mapDuration(var0 -> var0 / 4), var5.getAmplifier(), var5.isAmbient(), var5.isVisible()));
                }
            }
            var3.addAll(this.potionContents.customEffects());
            List<EntityLiving> var4 = this.level().getEntitiesOfClass(EntityLiving.class, this.getBoundingBox());
            if (var4.isEmpty()) break block20;
            Iterator iterator = var4.iterator();
            while (iterator.hasNext()) {
                double var9;
                double var7;
                double var11;
                EntityLiving var6 = (EntityLiving)iterator.next();
                if (this.victims.containsKey(var6) || !var6.isAffectedByPotions() || !((var11 = (var7 = var6.getX() - this.getX()) * var7 + (var9 = var6.getZ() - this.getZ()) * var9) <= (double)(var1 * var1))) continue;
                this.victims.put(var6, this.tickCount + this.reapplicationDelay);
                for (MobEffect var14 : var3) {
                    if (var14.getEffect().value().isInstantenous()) {
                        var14.getEffect().value().applyInstantenousEffect(this, this.getOwner(), var6, var14.getAmplifier(), 0.5);
                        continue;
                    }
                    var6.addEffect(new MobEffect(var14), this);
                }
                if (this.radiusOnUse != 0.0f) {
                    if ((var1 += this.radiusOnUse) < 0.5f) {
                        this.discard();
                        return;
                    }
                    this.setRadius(var1);
                }
                if (this.durationOnUse == 0) continue;
                this.duration += this.durationOnUse;
                if (this.duration > 0) continue;
                this.discard();
                return;
            }
        }
    }

    public float getRadiusOnUse() {
        return this.radiusOnUse;
    }

    public void setRadiusOnUse(float var0) {
        this.radiusOnUse = var0;
    }

    public float getRadiusPerTick() {
        return this.radiusPerTick;
    }

    public void setRadiusPerTick(float var0) {
        this.radiusPerTick = var0;
    }

    public int getDurationOnUse() {
        return this.durationOnUse;
    }

    public void setDurationOnUse(int var0) {
        this.durationOnUse = var0;
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int var0) {
        this.waitTime = var0;
    }

    public void setOwner(@Nullable EntityLiving var0) {
        this.owner = var0;
        this.ownerUUID = var0 == null ? null : var0.getUUID();
    }

    @Override
    @Nullable
    public EntityLiving getOwner() {
        Entity var0;
        if (this.owner == null && this.ownerUUID != null && this.level() instanceof WorldServer && (var0 = ((WorldServer)this.level()).getEntity(this.ownerUUID)) instanceof EntityLiving) {
            this.owner = (EntityLiving)var0;
        }
        return this.owner;
    }

    @Override
    protected void readAdditionalSaveData(NBTTagCompound var02) {
        this.tickCount = var02.getInt("Age");
        this.duration = var02.getInt("Duration");
        this.waitTime = var02.getInt("WaitTime");
        this.reapplicationDelay = var02.getInt("ReapplicationDelay");
        this.durationOnUse = var02.getInt("DurationOnUse");
        this.radiusOnUse = var02.getFloat("RadiusOnUse");
        this.radiusPerTick = var02.getFloat("RadiusPerTick");
        this.setRadius(var02.getFloat("Radius"));
        if (var02.hasUUID("Owner")) {
            this.ownerUUID = var02.getUUID("Owner");
        }
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        if (var02.contains("Particle", 10)) {
            Particles.CODEC.parse(var1, (Object)var02.get("Particle")).resultOrPartial(var0 -> LOGGER.warn("Failed to parse area effect cloud particle options: '{}'", var0)).ifPresent(this::setParticle);
        }
        if (var02.contains("potion_contents")) {
            PotionContents.CODEC.parse(var1, (Object)var02.get("potion_contents")).resultOrPartial(var0 -> LOGGER.warn("Failed to parse area effect cloud potions: '{}'", var0)).ifPresent(this::setPotionContents);
        }
    }

    @Override
    protected void addAdditionalSaveData(NBTTagCompound var0) {
        var0.putInt("Age", this.tickCount);
        var0.putInt("Duration", this.duration);
        var0.putInt("WaitTime", this.waitTime);
        var0.putInt("ReapplicationDelay", this.reapplicationDelay);
        var0.putInt("DurationOnUse", this.durationOnUse);
        var0.putFloat("RadiusOnUse", this.radiusOnUse);
        var0.putFloat("RadiusPerTick", this.radiusPerTick);
        var0.putFloat("Radius", this.getRadius());
        RegistryOps<NBTBase> var1 = this.registryAccess().createSerializationContext(DynamicOpsNBT.INSTANCE);
        var0.put("Particle", (NBTBase)Particles.CODEC.encodeStart(var1, (Object)this.getParticle()).getOrThrow());
        if (this.ownerUUID != null) {
            var0.putUUID("Owner", this.ownerUUID);
        }
        if (!this.potionContents.equals(PotionContents.EMPTY)) {
            NBTBase var2 = (NBTBase)PotionContents.CODEC.encodeStart(var1, (Object)this.potionContents).getOrThrow();
            var0.put("potion_contents", var2);
        }
    }

    @Override
    public void onSyncedDataUpdated(DataWatcherObject<?> var0) {
        if (DATA_RADIUS.equals(var0)) {
            this.refreshDimensions();
        }
        super.onSyncedDataUpdated(var0);
    }

    @Override
    public EnumPistonReaction getPistonPushReaction() {
        return EnumPistonReaction.IGNORE;
    }

    @Override
    public EntitySize getDimensions(EntityPose var0) {
        return EntitySize.scalable(this.getRadius() * 2.0f, 0.5f);
    }

    @Override
    @Nullable
    public /* synthetic */ Entity getOwner() {
        return this.getOwner();
    }
}

