/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.effect;

import com.google.common.collect.ComparisonChain;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.ints.Int2IntFunction;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.MathHelper;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectList;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import org.slf4j.Logger;

public class MobEffect
implements Comparable<MobEffect> {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int INFINITE_DURATION = -1;
    public static final int MIN_AMPLIFIER = 0;
    public static final int MAX_AMPLIFIER = 255;
    public static final Codec<MobEffect> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.MOB_EFFECT.holderByNameCodec().fieldOf("id").forGetter(MobEffect::getEffect), (App)b.MAP_CODEC.forGetter(MobEffect::asDetails)).apply((Applicative)var0, MobEffect::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, MobEffect> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.holderRegistry(Registries.MOB_EFFECT), MobEffect::getEffect, b.STREAM_CODEC, MobEffect::asDetails, MobEffect::new);
    private final Holder<MobEffectList> effect;
    private int duration;
    private int amplifier;
    private boolean ambient;
    private boolean visible;
    private boolean showIcon;
    @Nullable
    private MobEffect hiddenEffect;
    private final a blendState = new a();

    public MobEffect(Holder<MobEffectList> var0) {
        this(var0, 0, 0);
    }

    public MobEffect(Holder<MobEffectList> var0, int var1) {
        this(var0, var1, 0);
    }

    public MobEffect(Holder<MobEffectList> var0, int var1, int var2) {
        this(var0, var1, var2, false, true);
    }

    public MobEffect(Holder<MobEffectList> var0, int var1, int var2, boolean var3, boolean var4) {
        this(var0, var1, var2, var3, var4, var4);
    }

    public MobEffect(Holder<MobEffectList> var0, int var1, int var2, boolean var3, boolean var4, boolean var5) {
        this(var0, var1, var2, var3, var4, var5, null);
    }

    public MobEffect(Holder<MobEffectList> var0, int var1, int var2, boolean var3, boolean var4, boolean var5, @Nullable MobEffect var6) {
        this.effect = var0;
        this.duration = var1;
        this.amplifier = MathHelper.clamp(var2, 0, 255);
        this.ambient = var3;
        this.visible = var4;
        this.showIcon = var5;
        this.hiddenEffect = var6;
    }

    public MobEffect(MobEffect var0) {
        this.effect = var0.effect;
        this.setDetailsFrom(var0);
    }

    private MobEffect(Holder<MobEffectList> var0, b var12) {
        this(var0, var12.duration(), var12.amplifier(), var12.ambient(), var12.showParticles(), var12.showIcon(), var12.hiddenEffect().map(var1 -> new MobEffect(var0, (b)var1)).orElse(null));
    }

    private b asDetails() {
        return new b(this.getAmplifier(), this.getDuration(), this.isAmbient(), this.isVisible(), this.showIcon(), Optional.ofNullable(this.hiddenEffect).map(MobEffect::asDetails));
    }

    public float getBlendFactor(EntityLiving var0, float var1) {
        return this.blendState.getFactor(var0, var1);
    }

    public ParticleParam getParticleOptions() {
        return this.effect.value().createParticleOptions(this);
    }

    void setDetailsFrom(MobEffect var0) {
        this.duration = var0.duration;
        this.amplifier = var0.amplifier;
        this.ambient = var0.ambient;
        this.visible = var0.visible;
        this.showIcon = var0.showIcon;
    }

    public boolean update(MobEffect var0) {
        if (!this.effect.equals(var0.effect)) {
            LOGGER.warn("This method should only be called for matching effects!");
        }
        boolean var1 = false;
        if (var0.amplifier > this.amplifier) {
            if (var0.isShorterDurationThan(this)) {
                MobEffect var2 = this.hiddenEffect;
                this.hiddenEffect = new MobEffect(this);
                this.hiddenEffect.hiddenEffect = var2;
            }
            this.amplifier = var0.amplifier;
            this.duration = var0.duration;
            var1 = true;
        } else if (this.isShorterDurationThan(var0)) {
            if (var0.amplifier == this.amplifier) {
                this.duration = var0.duration;
                var1 = true;
            } else if (this.hiddenEffect == null) {
                this.hiddenEffect = new MobEffect(var0);
            } else {
                this.hiddenEffect.update(var0);
            }
        }
        if (!var0.ambient && this.ambient || var1) {
            this.ambient = var0.ambient;
            var1 = true;
        }
        if (var0.visible != this.visible) {
            this.visible = var0.visible;
            var1 = true;
        }
        if (var0.showIcon != this.showIcon) {
            this.showIcon = var0.showIcon;
            var1 = true;
        }
        return var1;
    }

    private boolean isShorterDurationThan(MobEffect var0) {
        return !this.isInfiniteDuration() && (this.duration < var0.duration || var0.isInfiniteDuration());
    }

    public boolean isInfiniteDuration() {
        return this.duration == -1;
    }

    public boolean endsWithin(int var0) {
        return !this.isInfiniteDuration() && this.duration <= var0;
    }

    public int mapDuration(Int2IntFunction var0) {
        if (this.isInfiniteDuration() || this.duration == 0) {
            return this.duration;
        }
        return var0.applyAsInt(this.duration);
    }

    public Holder<MobEffectList> getEffect() {
        return this.effect;
    }

    public int getDuration() {
        return this.duration;
    }

    public int getAmplifier() {
        return this.amplifier;
    }

    public boolean isAmbient() {
        return this.ambient;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public boolean showIcon() {
        return this.showIcon;
    }

    public boolean tick(EntityLiving var0, Runnable var1) {
        if (this.hasRemainingDuration()) {
            int var2;
            int n2 = var2 = this.isInfiniteDuration() ? var0.tickCount : this.duration;
            if (this.effect.value().shouldApplyEffectTickThisTick(var2, this.amplifier) && !this.effect.value().applyEffectTick(var0, this.amplifier)) {
                var0.removeEffect(this.effect);
            }
            this.tickDownDuration();
            if (this.duration == 0 && this.hiddenEffect != null) {
                this.setDetailsFrom(this.hiddenEffect);
                this.hiddenEffect = this.hiddenEffect.hiddenEffect;
                var1.run();
            }
        }
        this.blendState.tick(this);
        return this.hasRemainingDuration();
    }

    private boolean hasRemainingDuration() {
        return this.isInfiniteDuration() || this.duration > 0;
    }

    private int tickDownDuration() {
        if (this.hiddenEffect != null) {
            this.hiddenEffect.tickDownDuration();
        }
        this.duration = this.mapDuration(var0 -> var0 - 1);
        return this.duration;
    }

    public void onEffectStarted(EntityLiving var0) {
        this.effect.value().onEffectStarted(var0, this.amplifier);
    }

    public void onMobRemoved(EntityLiving var0, Entity.RemovalReason var1) {
        this.effect.value().onMobRemoved(var0, this.amplifier, var1);
    }

    public void onMobHurt(EntityLiving var0, DamageSource var1, float var2) {
        this.effect.value().onMobHurt(var0, this.amplifier, var1, var2);
    }

    public String getDescriptionId() {
        return this.effect.value().getDescriptionId();
    }

    public String toString() {
        String var0 = this.amplifier > 0 ? this.getDescriptionId() + " x " + (this.amplifier + 1) + ", Duration: " + this.describeDuration() : this.getDescriptionId() + ", Duration: " + this.describeDuration();
        if (!this.visible) {
            var0 = var0 + ", Particles: false";
        }
        if (!this.showIcon) {
            var0 = var0 + ", Show Icon: false";
        }
        return var0;
    }

    private String describeDuration() {
        if (this.isInfiniteDuration()) {
            return "infinite";
        }
        return Integer.toString(this.duration);
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        if (var0 instanceof MobEffect) {
            MobEffect var1 = (MobEffect)var0;
            return this.duration == var1.duration && this.amplifier == var1.amplifier && this.ambient == var1.ambient && this.effect.equals(var1.effect);
        }
        return false;
    }

    public int hashCode() {
        int var0 = this.effect.hashCode();
        var0 = 31 * var0 + this.duration;
        var0 = 31 * var0 + this.amplifier;
        var0 = 31 * var0 + (this.ambient ? 1 : 0);
        return var0;
    }

    public NBTBase save() {
        return (NBTBase)CODEC.encodeStart((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)this).getOrThrow();
    }

    @Nullable
    public static MobEffect load(NBTTagCompound var0) {
        return CODEC.parse((DynamicOps)DynamicOpsNBT.INSTANCE, (Object)var0).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElse(null);
    }

    @Override
    public int compareTo(MobEffect var0) {
        int var1 = 32147;
        if (this.getDuration() > 32147 && var0.getDuration() > 32147 || this.isAmbient() && var0.isAmbient()) {
            return ComparisonChain.start().compare(Boolean.valueOf(this.isAmbient()), Boolean.valueOf(var0.isAmbient())).compare(this.getEffect().value().getColor(), var0.getEffect().value().getColor()).result();
        }
        return ComparisonChain.start().compareFalseFirst(this.isAmbient(), var0.isAmbient()).compareFalseFirst(this.isInfiniteDuration(), var0.isInfiniteDuration()).compare(this.getDuration(), var0.getDuration()).compare(this.getEffect().value().getColor(), var0.getEffect().value().getColor()).result();
    }

    public void onEffectAdded(EntityLiving var0) {
        this.effect.value().onEffectAdded(var0, this.amplifier);
    }

    public boolean is(Holder<MobEffectList> var0) {
        return this.effect.equals(var0);
    }

    public void copyBlendState(MobEffect var0) {
        this.blendState.copyFrom(var0.blendState);
    }

    public void skipBlending() {
        this.blendState.setImmediate(this);
    }

    @Override
    public /* synthetic */ int compareTo(Object object) {
        return this.compareTo((MobEffect)object);
    }

    static class a {
        private float factor;
        private float factorPreviousFrame;

        a() {
        }

        public void setImmediate(MobEffect var0) {
            this.factorPreviousFrame = this.factor = a.computeTarget(var0);
        }

        public void copyFrom(a var0) {
            this.factor = var0.factor;
            this.factorPreviousFrame = var0.factorPreviousFrame;
        }

        public void tick(MobEffect var0) {
            this.factorPreviousFrame = this.factor;
            int var1 = a.getBlendDuration(var0);
            if (var1 == 0) {
                this.factor = 1.0f;
                return;
            }
            float var2 = a.computeTarget(var0);
            if (this.factor != var2) {
                float var3 = 1.0f / (float)var1;
                this.factor += MathHelper.clamp(var2 - this.factor, -var3, var3);
            }
        }

        private static float computeTarget(MobEffect var0) {
            boolean var1 = !var0.endsWithin(a.getBlendDuration(var0));
            return var1 ? 1.0f : 0.0f;
        }

        private static int getBlendDuration(MobEffect var0) {
            return var0.getEffect().value().getBlendDurationTicks();
        }

        public float getFactor(EntityLiving var0, float var1) {
            if (var0.isRemoved()) {
                this.factorPreviousFrame = this.factor;
            }
            return MathHelper.lerp(var1, this.factorPreviousFrame, this.factor);
        }
    }

    record b(int amplifier, int duration, boolean ambient, boolean showParticles, boolean showIcon, Optional<b> hiddenEffect) {
        public static final MapCodec<b> MAP_CODEC = MapCodec.recursive((String)"MobEffectInstance.Details", var0 -> RecordCodecBuilder.mapCodec(var1 -> var1.group((App)ExtraCodecs.UNSIGNED_BYTE.optionalFieldOf("amplifier", (Object)0).forGetter(b::amplifier), (App)Codec.INT.optionalFieldOf("duration", (Object)0).forGetter(b::duration), (App)Codec.BOOL.optionalFieldOf("ambient", (Object)false).forGetter(b::ambient), (App)Codec.BOOL.optionalFieldOf("show_particles", (Object)true).forGetter(b::showParticles), (App)Codec.BOOL.optionalFieldOf("show_icon").forGetter(var0 -> Optional.of(var0.showIcon())), (App)var0.optionalFieldOf("hidden_effect").forGetter(b::hiddenEffect)).apply((Applicative)var1, b::create)));
        public static final StreamCodec<ByteBuf, b> STREAM_CODEC = StreamCodec.recursive(var0 -> StreamCodec.composite(ByteBufCodecs.VAR_INT, b::amplifier, ByteBufCodecs.VAR_INT, b::duration, ByteBufCodecs.BOOL, b::ambient, ByteBufCodecs.BOOL, b::showParticles, ByteBufCodecs.BOOL, b::showIcon, var0.apply(ByteBufCodecs::optional), b::hiddenEffect, b::new));

        private static b create(int var0, int var1, boolean var2, boolean var3, Optional<Boolean> var4, Optional<b> var5) {
            return new b(var0, var1, var2, var3, var4.orElse(var3), var5);
        }
    }
}

