/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.random;

import java.util.List;
import java.util.Optional;
import net.minecraft.SystemUtils;
import net.minecraft.util.RandomSource;
import net.minecraft.util.random.WeightedEntry;

public class WeightedRandom2 {
    private WeightedRandom2() {
    }

    public static int getTotalWeight(List<? extends WeightedEntry> var0) {
        long var1 = 0L;
        for (WeightedEntry weightedEntry : var0) {
            var1 += (long)weightedEntry.getWeight().asInt();
        }
        if (var1 > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)var1;
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource var0, List<T> var1, int var2) {
        if (var2 < 0) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (var2 == 0) {
            return Optional.empty();
        }
        int var3 = var0.nextInt(var2);
        return WeightedRandom2.getWeightedItem(var1, var3);
    }

    public static <T extends WeightedEntry> Optional<T> getWeightedItem(List<T> var0, int var1) {
        for (WeightedEntry var3 : var0) {
            if ((var1 -= var3.getWeight().asInt()) >= 0) continue;
            return Optional.of(var3);
        }
        return Optional.empty();
    }

    public static <T extends WeightedEntry> Optional<T> getRandomItem(RandomSource var0, List<T> var1) {
        return WeightedRandom2.getRandomItem(var0, var1, WeightedRandom2.getTotalWeight(var1));
    }
}

