/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.repository;

import com.google.common.annotations.VisibleForTesting;
import java.nio.file.Path;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.packs.BuiltInMetadata;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.FeatureFlagsMetadataSection;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.PackLocationInfo;
import net.minecraft.server.packs.PackSelectionConfig;
import net.minecraft.server.packs.ResourcePackVanilla;
import net.minecraft.server.packs.VanillaPackResourcesBuilder;
import net.minecraft.server.packs.metadata.pack.ResourcePackInfo;
import net.minecraft.server.packs.repository.BuiltInPackSource;
import net.minecraft.server.packs.repository.KnownPack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.repository.ResourcePackSourceFolder;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.validation.DirectoryValidator;

public class ResourcePackSourceVanilla
extends BuiltInPackSource {
    private static final ResourcePackInfo VERSION_METADATA_SECTION = new ResourcePackInfo(IChatBaseComponent.translatable("dataPack.vanilla.description"), SharedConstants.getCurrentVersion().getPackVersion(EnumResourcePackType.SERVER_DATA), Optional.empty());
    private static final FeatureFlagsMetadataSection FEATURE_FLAGS_METADATA_SECTION = new FeatureFlagsMetadataSection(FeatureFlags.DEFAULT_FLAGS);
    private static final BuiltInMetadata BUILT_IN_METADATA = BuiltInMetadata.of(ResourcePackInfo.TYPE, VERSION_METADATA_SECTION, FeatureFlagsMetadataSection.TYPE, FEATURE_FLAGS_METADATA_SECTION);
    private static final PackLocationInfo VANILLA_PACK_INFO = new PackLocationInfo("vanilla", IChatBaseComponent.translatable("dataPack.vanilla.name"), PackSource.BUILT_IN, Optional.of(CORE_PACK_INFO));
    private static final PackSelectionConfig VANILLA_SELECTION_CONFIG = new PackSelectionConfig(false, ResourcePackLoader.Position.BOTTOM, false);
    private static final PackSelectionConfig FEATURE_SELECTION_CONFIG = new PackSelectionConfig(false, ResourcePackLoader.Position.TOP, false);
    private static final MinecraftKey PACKS_DIR = new MinecraftKey("minecraft", "datapacks");

    public ResourcePackSourceVanilla(DirectoryValidator var0) {
        super(EnumResourcePackType.SERVER_DATA, ResourcePackSourceVanilla.createVanillaPackSource(), PACKS_DIR, var0);
    }

    private static PackLocationInfo createBuiltInPackLocation(String var0, IChatBaseComponent var1) {
        return new PackLocationInfo(var0, var1, PackSource.FEATURE, Optional.of(KnownPack.vanilla(var0)));
    }

    @VisibleForTesting
    public static ResourcePackVanilla createVanillaPackSource() {
        return new VanillaPackResourcesBuilder().setMetadata(BUILT_IN_METADATA).exposeNamespace("minecraft").applyDevelopmentConfig().pushJarResources().build(VANILLA_PACK_INFO);
    }

    @Override
    protected IChatBaseComponent getPackTitle(String var0) {
        return IChatBaseComponent.literal(var0);
    }

    @Override
    @Nullable
    protected ResourcePackLoader createVanillaPack(IResourcePack var0) {
        return ResourcePackLoader.readMetaAndCreate(VANILLA_PACK_INFO, ResourcePackSourceVanilla.fixedResources(var0), EnumResourcePackType.SERVER_DATA, VANILLA_SELECTION_CONFIG);
    }

    @Override
    @Nullable
    protected ResourcePackLoader createBuiltinPack(String var0, ResourcePackLoader.c var1, IChatBaseComponent var2) {
        return ResourcePackLoader.readMetaAndCreate(ResourcePackSourceVanilla.createBuiltInPackLocation(var0, var2), var1, EnumResourcePackType.SERVER_DATA, FEATURE_SELECTION_CONFIG);
    }

    public static ResourcePackRepository createPackRepository(Path var0, DirectoryValidator var1) {
        return new ResourcePackRepository(new ResourcePackSourceVanilla(var1), new ResourcePackSourceFolder(var0, EnumResourcePackType.SERVER_DATA, PackSource.WORLD, var1));
    }

    public static ResourcePackRepository createVanillaTrustedRepository() {
        return new ResourcePackRepository(new ResourcePackSourceVanilla(new DirectoryValidator(var0 -> true)));
    }

    public static ResourcePackRepository createPackRepository(Convertable.ConversionSession var0) {
        return ResourcePackSourceVanilla.createPackRepository(var0.getLevelPath(SavedFile.DATAPACK_DIR), var0.parent().getWorldDirValidator());
    }
}

