/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.mojang.logging.LogUtils;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.SystemUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.util.MathHelper;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyDamageScaler;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.GeneratorAccessSeed;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ITileEntity;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.chunk.IChunkProvider;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.status.ChunkType;
import net.minecraft.world.level.dimension.DimensionManager;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.lighting.LevelLightEngine;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import net.minecraft.world.ticks.LevelTickAccess;
import net.minecraft.world.ticks.TickListWorldGen;
import org.slf4j.Logger;

public class RegionLimitedWorldAccess
implements GeneratorAccessSeed {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final List<IChunkAccess> cache;
    private final IChunkAccess center;
    private final int size;
    private final WorldServer level;
    private final long seed;
    private final WorldData levelData;
    private final RandomSource random;
    private final DimensionManager dimensionType;
    private final TickListWorldGen<Block> blockTicks = new TickListWorldGen(var0 -> this.getChunk((BlockPosition)var0).getBlockTicks());
    private final TickListWorldGen<FluidType> fluidTicks = new TickListWorldGen(var0 -> this.getChunk((BlockPosition)var0).getFluidTicks());
    private final BiomeManager biomeManager;
    private final ChunkCoordIntPair firstPos;
    private final ChunkCoordIntPair lastPos;
    private final ChunkStatus generatingStatus;
    private final int writeRadiusCutoff;
    @Nullable
    private Supplier<String> currentlyGenerating;
    private final AtomicLong subTickCount = new AtomicLong();
    private static final MinecraftKey WORLDGEN_REGION_RANDOM = new MinecraftKey("worldgen_region_random");

    public RegionLimitedWorldAccess(WorldServer var02, List<IChunkAccess> var1, ChunkStatus var2, int var3) {
        this.generatingStatus = var2;
        this.writeRadiusCutoff = var3;
        int var4 = MathHelper.floor(Math.sqrt(var1.size()));
        if (var4 * var4 != var1.size()) {
            throw SystemUtils.pauseInIde(new IllegalStateException("Cache size is not a square."));
        }
        this.cache = var1;
        this.center = var1.get(var1.size() / 2);
        this.size = var4;
        this.level = var02;
        this.seed = var02.getSeed();
        this.levelData = var02.getLevelData();
        this.random = var02.getChunkSource().randomState().getOrCreateRandomFactory(WORLDGEN_REGION_RANDOM).at(this.center.getPos().getWorldPosition());
        this.dimensionType = var02.dimensionType();
        this.biomeManager = new BiomeManager(this, BiomeManager.obfuscateSeed(this.seed));
        this.firstPos = var1.get(0).getPos();
        this.lastPos = var1.get(var1.size() - 1).getPos();
    }

    public boolean isOldChunkAround(ChunkCoordIntPair var0, int var1) {
        return this.level.getChunkSource().chunkMap.isOldChunkAround(var0, var1);
    }

    public ChunkCoordIntPair getCenter() {
        return this.center.getPos();
    }

    @Override
    public void setCurrentlyGenerating(@Nullable Supplier<String> var0) {
        this.currentlyGenerating = var0;
    }

    @Override
    public IChunkAccess getChunk(int var0, int var1) {
        return this.getChunk(var0, var1, ChunkStatus.EMPTY);
    }

    @Override
    @Nullable
    public IChunkAccess getChunk(int var0, int var1, ChunkStatus var2, boolean var3) {
        IChunkAccess var4;
        if (this.hasChunk(var0, var1)) {
            int var5 = var0 - this.firstPos.x;
            int var6 = var1 - this.firstPos.z;
            var4 = this.cache.get(var5 + var6 * this.size);
            if (var4.getStatus().isOrAfter(var2)) {
                return var4;
            }
        } else {
            var4 = null;
        }
        CrashReport var5 = CrashReport.forThrowable(new IllegalStateException("Requested chunk unavailable during world generation"), "Exception generating new chunk");
        CrashReportSystemDetails var6 = var5.addCategory("Chunk request details");
        var6.setDetail("Requested chunk", String.format(Locale.ROOT, "%d, %d", var0, var1));
        var6.setDetail("Requested status", () -> BuiltInRegistries.CHUNK_STATUS.getKey(var2).toString());
        var6.setDetail("Actual status", () -> var4 == null ? "[out of region bounds]" : BuiltInRegistries.CHUNK_STATUS.getKey(var4.getStatus()).toString());
        var6.setDetail("loadOrGenerate", var3);
        var6.setDetail("Generating chunk", () -> this.center.getPos().toString());
        var6.setDetail("Region start", this.firstPos);
        var6.setDetail("Region end", this.lastPos);
        throw new ReportedException(var5);
    }

    @Override
    public boolean hasChunk(int var0, int var1) {
        return var0 >= this.firstPos.x && var0 <= this.lastPos.x && var1 >= this.firstPos.z && var1 <= this.lastPos.z;
    }

    @Override
    public IBlockData getBlockState(BlockPosition var0) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ())).getBlockState(var0);
    }

    @Override
    public Fluid getFluidState(BlockPosition var0) {
        return this.getChunk(var0).getFluidState(var0);
    }

    @Override
    @Nullable
    public EntityHuman getNearestPlayer(double var0, double var2, double var4, double var6, Predicate<Entity> var8) {
        return null;
    }

    @Override
    public int getSkyDarken() {
        return 0;
    }

    @Override
    public BiomeManager getBiomeManager() {
        return this.biomeManager;
    }

    @Override
    public Holder<BiomeBase> getUncachedNoiseBiome(int var0, int var1, int var2) {
        return this.level.getUncachedNoiseBiome(var0, var1, var2);
    }

    @Override
    public float getShade(EnumDirection var0, boolean var1) {
        return 1.0f;
    }

    @Override
    public LevelLightEngine getLightEngine() {
        return this.level.getLightEngine();
    }

    @Override
    public boolean destroyBlock(BlockPosition var0, boolean var1, @Nullable Entity var2, int var3) {
        IBlockData var4 = this.getBlockState(var0);
        if (var4.isAir()) {
            return false;
        }
        if (var1) {
            TileEntity var5 = var4.hasBlockEntity() ? this.getBlockEntity(var0) : null;
            Block.dropResources(var4, this.level, var0, var5, var2, ItemStack.EMPTY);
        }
        return this.setBlock(var0, Blocks.AIR.defaultBlockState(), 3, var3);
    }

    @Override
    @Nullable
    public TileEntity getBlockEntity(BlockPosition var0) {
        IChunkAccess var1 = this.getChunk(var0);
        TileEntity var2 = var1.getBlockEntity(var0);
        if (var2 != null) {
            return var2;
        }
        NBTTagCompound var3 = var1.getBlockEntityNbt(var0);
        IBlockData var4 = var1.getBlockState(var0);
        if (var3 != null) {
            if ("DUMMY".equals(var3.getString("id"))) {
                if (!var4.hasBlockEntity()) {
                    return null;
                }
                var2 = ((ITileEntity)((Object)var4.getBlock())).newBlockEntity(var0, var4);
            } else {
                var2 = TileEntity.loadStatic(var0, var4, var3, this.level.registryAccess());
            }
            if (var2 != null) {
                var1.setBlockEntity(var2);
                return var2;
            }
        }
        if (var4.hasBlockEntity()) {
            LOGGER.warn("Tried to access a block entity before it was created. {}", (Object)var0);
        }
        return null;
    }

    @Override
    public boolean ensureCanWrite(BlockPosition var0) {
        int var1 = SectionPosition.blockToSectionCoord(var0.getX());
        int var2 = SectionPosition.blockToSectionCoord(var0.getZ());
        ChunkCoordIntPair var3 = this.getCenter();
        int var4 = Math.abs(var3.x - var1);
        int var5 = Math.abs(var3.z - var2);
        if (var4 > this.writeRadiusCutoff || var5 > this.writeRadiusCutoff) {
            SystemUtils.logAndPauseIfInIde("Detected setBlock in a far chunk [" + var1 + ", " + var2 + "], pos: " + String.valueOf(var0) + ", status: " + String.valueOf(this.generatingStatus) + (String)(this.currentlyGenerating == null ? "" : ", currently generating: " + this.currentlyGenerating.get()));
            return false;
        }
        if (this.center.isUpgrading()) {
            LevelHeightAccessor var6 = this.center.getHeightAccessorForGeneration();
            if (var0.getY() < var6.getMinBuildHeight() || var0.getY() >= var6.getMaxBuildHeight()) {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean setBlock(BlockPosition var0, IBlockData var1, int var2, int var3) {
        if (!this.ensureCanWrite(var0)) {
            return false;
        }
        IChunkAccess var4 = this.getChunk(var0);
        IBlockData var5 = var4.setBlockState(var0, var1, false);
        if (var5 != null) {
            this.level.onBlockStateChange(var0, var5, var1);
        }
        if (var1.hasBlockEntity()) {
            if (var4.getStatus().getChunkType() == ChunkType.LEVELCHUNK) {
                TileEntity var6 = ((ITileEntity)((Object)var1.getBlock())).newBlockEntity(var0, var1);
                if (var6 != null) {
                    var4.setBlockEntity(var6);
                } else {
                    var4.removeBlockEntity(var0);
                }
            } else {
                NBTTagCompound var6 = new NBTTagCompound();
                var6.putInt("x", var0.getX());
                var6.putInt("y", var0.getY());
                var6.putInt("z", var0.getZ());
                var6.putString("id", "DUMMY");
                var4.setBlockEntityNbt(var6);
            }
        } else if (var5 != null && var5.hasBlockEntity()) {
            var4.removeBlockEntity(var0);
        }
        if (var1.hasPostProcess(this, var0)) {
            this.markPosForPostprocessing(var0);
        }
        return true;
    }

    private void markPosForPostprocessing(BlockPosition var0) {
        this.getChunk(var0).markPosForPostprocessing(var0);
    }

    @Override
    public boolean addFreshEntity(Entity var0) {
        int var1 = SectionPosition.blockToSectionCoord(var0.getBlockX());
        int var2 = SectionPosition.blockToSectionCoord(var0.getBlockZ());
        this.getChunk(var1, var2).addEntity(var0);
        return true;
    }

    @Override
    public boolean removeBlock(BlockPosition var0, boolean var1) {
        return this.setBlock(var0, Blocks.AIR.defaultBlockState(), 3);
    }

    @Override
    public WorldBorder getWorldBorder() {
        return this.level.getWorldBorder();
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    @Deprecated
    public WorldServer getLevel() {
        return this.level;
    }

    @Override
    public IRegistryCustom registryAccess() {
        return this.level.registryAccess();
    }

    @Override
    public FeatureFlagSet enabledFeatures() {
        return this.level.enabledFeatures();
    }

    @Override
    public WorldData getLevelData() {
        return this.levelData;
    }

    @Override
    public DifficultyDamageScaler getCurrentDifficultyAt(BlockPosition var0) {
        if (!this.hasChunk(SectionPosition.blockToSectionCoord(var0.getX()), SectionPosition.blockToSectionCoord(var0.getZ()))) {
            throw new RuntimeException("We are asking a region for a chunk out of bound");
        }
        return new DifficultyDamageScaler(this.level.getDifficulty(), this.level.getDayTime(), 0L, this.level.getMoonBrightness());
    }

    @Override
    @Nullable
    public MinecraftServer getServer() {
        return this.level.getServer();
    }

    @Override
    public IChunkProvider getChunkSource() {
        return this.level.getChunkSource();
    }

    @Override
    public long getSeed() {
        return this.seed;
    }

    @Override
    public LevelTickAccess<Block> getBlockTicks() {
        return this.blockTicks;
    }

    @Override
    public LevelTickAccess<FluidType> getFluidTicks() {
        return this.fluidTicks;
    }

    @Override
    public int getSeaLevel() {
        return this.level.getSeaLevel();
    }

    @Override
    public RandomSource getRandom() {
        return this.random;
    }

    @Override
    public int getHeight(HeightMap.Type var0, int var1, int var2) {
        return this.getChunk(SectionPosition.blockToSectionCoord(var1), SectionPosition.blockToSectionCoord(var2)).getHeight(var0, var1 & 0xF, var2 & 0xF) + 1;
    }

    @Override
    public void playSound(@Nullable EntityHuman var0, BlockPosition var1, SoundEffect var2, SoundCategory var3, float var4, float var5) {
    }

    @Override
    public void addParticle(ParticleParam var0, double var1, double var3, double var5, double var7, double var9, double var11) {
    }

    @Override
    public void levelEvent(@Nullable EntityHuman var0, int var1, BlockPosition var2, int var3) {
    }

    @Override
    public void gameEvent(Holder<GameEvent> var0, Vec3D var1, GameEvent.a var2) {
    }

    @Override
    public DimensionManager dimensionType() {
        return this.dimensionType;
    }

    @Override
    public boolean isStateAtPosition(BlockPosition var0, Predicate<IBlockData> var1) {
        return var1.test(this.getBlockState(var0));
    }

    @Override
    public boolean isFluidAtPosition(BlockPosition var0, Predicate<Fluid> var1) {
        return var1.test(this.getFluidState(var0));
    }

    @Override
    public <T extends Entity> List<T> getEntities(EntityTypeTest<Entity, T> var0, AxisAlignedBB var1, Predicate<? super T> var2) {
        return Collections.emptyList();
    }

    @Override
    public List<Entity> getEntities(@Nullable Entity var0, AxisAlignedBB var1, @Nullable Predicate<? super Entity> var2) {
        return Collections.emptyList();
    }

    public List<EntityHuman> players() {
        return Collections.emptyList();
    }

    @Override
    public int getMinBuildHeight() {
        return this.level.getMinBuildHeight();
    }

    @Override
    public int getHeight() {
        return this.level.getHeight();
    }

    @Override
    public long nextSubTickCount() {
        return this.subTickCount.getAndIncrement();
    }
}

