/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.Optional;
import net.minecraft.ResourceKeyInvalidException;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentMinecraftKeyRegistered;
import net.minecraft.commands.arguments.ResourceKeyArgument;
import net.minecraft.commands.arguments.TemplateMirrorArgument;
import net.minecraft.commands.arguments.TemplateRotationArgument;
import net.minecraft.commands.arguments.coordinates.ArgumentPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.block.EnumBlockMirror;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructureJigsawPlacement;
import net.minecraft.world.level.levelgen.structure.pools.WorldGenFeatureDefinedStructurePoolTemplate;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructure;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureInfo;
import net.minecraft.world.level.levelgen.structure.templatesystem.DefinedStructureProcessorRotation;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;

public class PlaceCommand {
    private static final SimpleCommandExceptionType ERROR_FEATURE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.feature.failed"));
    private static final SimpleCommandExceptionType ERROR_JIGSAW_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.jigsaw.failed"));
    private static final SimpleCommandExceptionType ERROR_STRUCTURE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.structure.failed"));
    private static final DynamicCommandExceptionType ERROR_TEMPLATE_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("commands.place.template.invalid", var0));
    private static final SimpleCommandExceptionType ERROR_TEMPLATE_FAILED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("commands.place.template.failed"));
    private static final SuggestionProvider<CommandListenerWrapper> SUGGEST_TEMPLATES = (var0, var1) -> {
        StructureTemplateManager var2 = ((CommandListenerWrapper)var0.getSource()).getLevel().getStructureManager();
        return ICompletionProvider.suggestResource(var2.listTemplates(), var1);
    };

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("place").requires(var0 -> var0.hasPermission(2))).then(net.minecraft.commands.CommandDispatcher.literal("feature").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("feature", ResourceKeyArgument.key(Registries.CONFIGURED_FEATURE)).executes(var0 -> PlaceCommand.placeFeature((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)var0, "feature"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> PlaceCommand.placeFeature((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getConfiguredFeature((CommandContext<CommandListenerWrapper>)var0, "feature"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.literal("jigsaw").then(net.minecraft.commands.CommandDispatcher.argument("pool", ResourceKeyArgument.key(Registries.TEMPLATE_POOL)).then(net.minecraft.commands.CommandDispatcher.argument("target", ArgumentMinecraftKeyRegistered.id()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("max_depth", IntegerArgumentType.integer((int)1, (int)20)).executes(var0 -> PlaceCommand.placeJigsaw((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandListenerWrapper>)var0, "pool"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"max_depth"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("position", ArgumentPosition.blockPos()).executes(var0 -> PlaceCommand.placeJigsaw((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getStructureTemplatePool((CommandContext<CommandListenerWrapper>)var0, "pool"), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "target"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"max_depth"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "position"))))))))).then(net.minecraft.commands.CommandDispatcher.literal("structure").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("structure", ResourceKeyArgument.key(Registries.STRUCTURE)).executes(var0 -> PlaceCommand.placeStructure((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandListenerWrapper>)var0, "structure"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition())))).then(net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> PlaceCommand.placeStructure((CommandListenerWrapper)var0.getSource(), ResourceKeyArgument.getStructure((CommandContext<CommandListenerWrapper>)var0, "structure"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"))))))).then(net.minecraft.commands.CommandDispatcher.literal("template").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("template", ArgumentMinecraftKeyRegistered.id()).suggests(SUGGEST_TEMPLATES).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), BlockPosition.containing(((CommandListenerWrapper)var0.getSource()).getPosition()), EnumBlockRotation.NONE, EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("pos", ArgumentPosition.blockPos()).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), EnumBlockRotation.NONE, EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotation", TemplateRotationArgument.templateRotation()).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation"), EnumBlockMirror.NONE, 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("mirror", TemplateMirrorArgument.templateMirror()).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)var0, "mirror"), 1.0f, 0))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("integrity", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)var0, "mirror"), FloatArgumentType.getFloat((CommandContext)var0, (String)"integrity"), 0))).then(net.minecraft.commands.CommandDispatcher.argument("seed", IntegerArgumentType.integer()).executes(var0 -> PlaceCommand.placeTemplate((CommandListenerWrapper)var0.getSource(), ArgumentMinecraftKeyRegistered.getId((CommandContext<CommandListenerWrapper>)var0, "template"), ArgumentPosition.getLoadedBlockPos((CommandContext<CommandListenerWrapper>)var0, "pos"), TemplateRotationArgument.getRotation((CommandContext<CommandListenerWrapper>)var0, "rotation"), TemplateMirrorArgument.getMirror((CommandContext<CommandListenerWrapper>)var0, "mirror"), FloatArgumentType.getFloat((CommandContext)var0, (String)"integrity"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"seed")))))))))));
    }

    public static int placeFeature(CommandListenerWrapper var0, Holder.c<WorldGenFeatureConfigured<?, ?>> var1, BlockPosition var2) throws CommandSyntaxException {
        WorldServer var3 = var0.getLevel();
        WorldGenFeatureConfigured<?, ?> var4 = var1.value();
        ChunkCoordIntPair var5 = new ChunkCoordIntPair(var2);
        PlaceCommand.checkLoaded(var3, new ChunkCoordIntPair(var5.x - 1, var5.z - 1), new ChunkCoordIntPair(var5.x + 1, var5.z + 1));
        if (!var4.place(var3, var3.getChunkSource().getGenerator(), var3.getRandom(), var2)) {
            throw ERROR_FEATURE_FAILED.create();
        }
        String var6 = var1.key().location().toString();
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.feature.success", var6, var2.getX(), var2.getY(), var2.getZ()), true);
        return 1;
    }

    public static int placeJigsaw(CommandListenerWrapper var0, Holder<WorldGenFeatureDefinedStructurePoolTemplate> var1, MinecraftKey var2, int var3, BlockPosition var4) throws CommandSyntaxException {
        WorldServer var5 = var0.getLevel();
        ChunkCoordIntPair var6 = new ChunkCoordIntPair(var4);
        PlaceCommand.checkLoaded(var5, var6, var6);
        if (!WorldGenFeatureDefinedStructureJigsawPlacement.generateJigsaw(var5, var1, var2, var3, var4, false)) {
            throw ERROR_JIGSAW_FAILED.create();
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.jigsaw.success", var4.getX(), var4.getY(), var4.getZ()), true);
        return 1;
    }

    public static int placeStructure(CommandListenerWrapper var02, Holder.c<Structure> var1, BlockPosition var2) throws CommandSyntaxException {
        WorldServer var32 = var02.getLevel();
        Structure var4 = var1.value();
        ChunkGenerator var5 = var32.getChunkSource().getGenerator();
        StructureStart var6 = var4.generate(var02.registryAccess(), var5, var5.getBiomeSource(), var32.getChunkSource().randomState(), var32.getStructureManager(), var32.getSeed(), new ChunkCoordIntPair(var2), 0, var32, var0 -> true);
        if (!var6.isValid()) {
            throw ERROR_STRUCTURE_FAILED.create();
        }
        StructureBoundingBox var7 = var6.getBoundingBox();
        ChunkCoordIntPair var8 = new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(var7.minX()), SectionPosition.blockToSectionCoord(var7.minZ()));
        ChunkCoordIntPair var9 = new ChunkCoordIntPair(SectionPosition.blockToSectionCoord(var7.maxX()), SectionPosition.blockToSectionCoord(var7.maxZ()));
        PlaceCommand.checkLoaded(var32, var8, var9);
        ChunkCoordIntPair.rangeClosed(var8, var9).forEach(var3 -> var6.placeInChunk(var32, var32.structureManager(), var5, var32.getRandom(), new StructureBoundingBox(var3.getMinBlockX(), var32.getMinBuildHeight(), var3.getMinBlockZ(), var3.getMaxBlockX(), var32.getMaxBuildHeight(), var3.getMaxBlockZ()), (ChunkCoordIntPair)var3));
        String var10 = var1.key().location().toString();
        var02.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.structure.success", var10, var2.getX(), var2.getY(), var2.getZ()), true);
        return 1;
    }

    public static int placeTemplate(CommandListenerWrapper var0, MinecraftKey var1, BlockPosition var2, EnumBlockRotation var3, EnumBlockMirror var4, float var5, int var6) throws CommandSyntaxException {
        boolean var12;
        Optional<DefinedStructure> var9;
        WorldServer var7 = var0.getLevel();
        StructureTemplateManager var8 = var7.getStructureManager();
        try {
            var9 = var8.get(var1);
        }
        catch (ResourceKeyInvalidException var10) {
            throw ERROR_TEMPLATE_INVALID.create((Object)var1);
        }
        if (var9.isEmpty()) {
            throw ERROR_TEMPLATE_INVALID.create((Object)var1);
        }
        DefinedStructure var10 = var9.get();
        PlaceCommand.checkLoaded(var7, new ChunkCoordIntPair(var2), new ChunkCoordIntPair(var2.offset(var10.getSize())));
        DefinedStructureInfo var11 = new DefinedStructureInfo().setMirror(var4).setRotation(var3);
        if (var5 < 1.0f) {
            var11.clearProcessors().addProcessor(new DefinedStructureProcessorRotation(var5)).setRandom(TileEntityStructure.createRandom(var6));
        }
        if (!(var12 = var10.placeInWorld(var7, var2, var2, var11, TileEntityStructure.createRandom(var6), 2))) {
            throw ERROR_TEMPLATE_FAILED.create();
        }
        var0.sendSuccess(() -> IChatBaseComponent.translatable("commands.place.template.success", IChatBaseComponent.translationArg(var1), var2.getX(), var2.getY(), var2.getZ()), true);
        return 1;
    }

    private static void checkLoaded(WorldServer var0, ChunkCoordIntPair var12, ChunkCoordIntPair var2) throws CommandSyntaxException {
        if (ChunkCoordIntPair.rangeClosed(var12, var2).filter(var1 -> !var0.isLoaded(var1.getWorldPosition())).findAny().isPresent()) {
            throw ArgumentPosition.ERROR_NOT_LOADED.create();
        }
    }
}

