/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.bossevents;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.bossevents.BossBattleCustom;
import net.minecraft.server.level.EntityPlayer;

public class BossBattleCustomData {
    private final Map<MinecraftKey, BossBattleCustom> events = Maps.newHashMap();

    @Nullable
    public BossBattleCustom get(MinecraftKey var0) {
        return this.events.get(var0);
    }

    public BossBattleCustom create(MinecraftKey var0, IChatBaseComponent var1) {
        BossBattleCustom var2 = new BossBattleCustom(var0, var1);
        this.events.put(var0, var2);
        return var2;
    }

    public void remove(BossBattleCustom var0) {
        this.events.remove(var0.getTextId());
    }

    public Collection<MinecraftKey> getIds() {
        return this.events.keySet();
    }

    public Collection<BossBattleCustom> getEvents() {
        return this.events.values();
    }

    public NBTTagCompound save(HolderLookup.a var0) {
        NBTTagCompound var1 = new NBTTagCompound();
        for (BossBattleCustom var3 : this.events.values()) {
            var1.put(var3.getTextId().toString(), var3.save(var0));
        }
        return var1;
    }

    public void load(NBTTagCompound var0, HolderLookup.a var1) {
        for (String var3 : var0.getAllKeys()) {
            MinecraftKey var4 = new MinecraftKey(var3);
            this.events.put(var4, BossBattleCustom.load(var0.getCompound(var3), var4, var1));
        }
    }

    public void onPlayerConnect(EntityPlayer var0) {
        for (BossBattleCustom var2 : this.events.values()) {
            var2.onPlayerConnect(var0);
        }
    }

    public void onPlayerDisconnect(EntityPlayer var0) {
        for (BossBattleCustom var2 : this.events.values()) {
            var2.onPlayerDisconnect(var0);
        }
    }
}

