/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.datafixers.DataFixer;
import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.lang.invoke.MethodHandle;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.runtime.ObjectMethods;
import java.net.Proxy;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.KeyPair;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.imageio.ImageIO;
import net.minecraft.CrashReport;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.SystemReport;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICommandListener;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.features.MiscOverworldFeatures;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.network.chat.ChatDecorator;
import net.minecraft.network.chat.ChatMessageType;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.game.PacketPlayOutServerDifficulty;
import net.minecraft.network.protocol.game.PacketPlayOutUpdateTime;
import net.minecraft.network.protocol.status.ServerPing;
import net.minecraft.obfuscate.DontObfuscate;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionData;
import net.minecraft.server.DataPackResources;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.ScoreboardServer;
import net.minecraft.server.ServerInfo;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.server.Services;
import net.minecraft.server.TickTask;
import net.minecraft.server.WorldStem;
import net.minecraft.server.bossevents.BossBattleCustomData;
import net.minecraft.server.level.ChunkProviderServer;
import net.minecraft.server.level.DemoPlayerInteractManager;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.PlayerInteractManager;
import net.minecraft.server.level.WorldProviderNormal;
import net.minecraft.server.level.WorldServer;
import net.minecraft.server.level.progress.WorldLoadListener;
import net.minecraft.server.level.progress.WorldLoadListenerFactory;
import net.minecraft.server.network.ITextFilter;
import net.minecraft.server.network.ServerConnection;
import net.minecraft.server.packs.EnumResourcePackType;
import net.minecraft.server.packs.IResourcePack;
import net.minecraft.server.packs.repository.PackSource;
import net.minecraft.server.packs.repository.ResourcePackLoader;
import net.minecraft.server.packs.repository.ResourcePackRepository;
import net.minecraft.server.packs.resources.IReloadableResourceManager;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.players.OpListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.UserCache;
import net.minecraft.server.players.WhiteList;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.util.ModCheck;
import net.minecraft.util.NativeModuleLister;
import net.minecraft.util.RandomSource;
import net.minecraft.util.SignatureValidator;
import net.minecraft.util.TimeRange;
import net.minecraft.util.debugchart.RemoteDebugSampleType;
import net.minecraft.util.debugchart.SampleLogger;
import net.minecraft.util.debugchart.TpsDebugDimensions;
import net.minecraft.util.profiling.GameProfilerFiller;
import net.minecraft.util.profiling.GameProfilerTick;
import net.minecraft.util.profiling.MethodProfilerResults;
import net.minecraft.util.profiling.MethodProfilerResultsEmpty;
import net.minecraft.util.profiling.MethodProfilerResultsField;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.util.profiling.jfr.callback.ProfiledDuration;
import net.minecraft.util.profiling.metrics.profiling.ActiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.InactiveMetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.MetricsRecorder;
import net.minecraft.util.profiling.metrics.profiling.ServerMetricsSamplersProvider;
import net.minecraft.util.profiling.metrics.storage.MetricsPersister;
import net.minecraft.util.thread.IAsyncTaskHandlerReentrant;
import net.minecraft.world.EnumDifficulty;
import net.minecraft.world.RandomSequences;
import net.minecraft.world.entity.ai.village.VillageSiege;
import net.minecraft.world.entity.npc.MobSpawnerCat;
import net.minecraft.world.entity.npc.MobSpawnerTrader;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.item.alchemy.PotionBrewer;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.DataPackConfiguration;
import net.minecraft.world.level.EnumGamemode;
import net.minecraft.world.level.ForcedChunk;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.MobSpawner;
import net.minecraft.world.level.World;
import net.minecraft.world.level.WorldDataConfiguration;
import net.minecraft.world.level.WorldSettings;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.border.IWorldBorderListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.WorldDimension;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.MobSpawnerPatrol;
import net.minecraft.world.level.levelgen.MobSpawnerPhantom;
import net.minecraft.world.level.levelgen.WorldOptions;
import net.minecraft.world.level.levelgen.feature.WorldGenFeatureConfigured;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplateManager;
import net.minecraft.world.level.storage.Convertable;
import net.minecraft.world.level.storage.IWorldDataServer;
import net.minecraft.world.level.storage.PersistentCommandStorage;
import net.minecraft.world.level.storage.SaveData;
import net.minecraft.world.level.storage.SavedFile;
import net.minecraft.world.level.storage.SecondaryWorldData;
import net.minecraft.world.level.storage.WorldData;
import net.minecraft.world.level.storage.WorldNBTStorage;
import net.minecraft.world.level.storage.WorldPersistentData;
import net.minecraft.world.phys.Vec2F;
import net.minecraft.world.phys.Vec3D;
import org.slf4j.Logger;

public abstract class MinecraftServer
extends IAsyncTaskHandlerReentrant<TickTask>
implements ServerInfo,
ICommandListener,
AutoCloseable {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final String VANILLA_BRAND = "vanilla";
    private static final float AVERAGE_TICK_TIME_SMOOTHING = 0.8f;
    private static final int TICK_STATS_SPAN = 100;
    private static final long OVERLOADED_THRESHOLD_NANOS = 20L * TimeRange.NANOSECONDS_PER_SECOND / 20L;
    private static final int OVERLOADED_TICKS_THRESHOLD = 20;
    private static final long OVERLOADED_WARNING_INTERVAL_NANOS = 10L * TimeRange.NANOSECONDS_PER_SECOND;
    private static final int OVERLOADED_TICKS_WARNING_INTERVAL = 100;
    private static final long STATUS_EXPIRE_TIME_NANOS = 5L * TimeRange.NANOSECONDS_PER_SECOND;
    private static final long PREPARE_LEVELS_DEFAULT_DELAY_NANOS = 10L * TimeRange.NANOSECONDS_PER_MILLISECOND;
    private static final int MAX_STATUS_PLAYER_SAMPLE = 12;
    private static final int SPAWN_POSITION_SEARCH_RADIUS = 5;
    private static final int AUTOSAVE_INTERVAL = 6000;
    private static final int MIMINUM_AUTOSAVE_TICKS = 100;
    private static final int MAX_TICK_LATENCY = 3;
    public static final int ABSOLUTE_MAX_WORLD_SIZE = 29999984;
    public static final WorldSettings DEMO_SETTINGS = new WorldSettings("Demo World", EnumGamemode.SURVIVAL, false, EnumDifficulty.NORMAL, false, new GameRules(), WorldDataConfiguration.DEFAULT);
    public static final GameProfile ANONYMOUS_PLAYER_PROFILE = new GameProfile(SystemUtils.NIL_UUID, "Anonymous Player");
    public Convertable.ConversionSession storageSource;
    public final WorldNBTStorage playerDataStorage;
    private final List<Runnable> tickables = Lists.newArrayList();
    private MetricsRecorder metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    private GameProfilerFiller profiler = this.metricsRecorder.getProfiler();
    private Consumer<MethodProfilerResults> onMetricsRecordingStopped = var0 -> this.stopRecordingMetrics();
    private Consumer<Path> onMetricsRecordingFinished = var0 -> {};
    private boolean willStartRecordingMetrics;
    @Nullable
    private TimeProfiler debugCommandProfiler;
    private boolean debugCommandProfilerDelayStart;
    private ServerConnection connection;
    public final WorldLoadListenerFactory progressListenerFactory;
    @Nullable
    private ServerPing status;
    @Nullable
    private ServerPing.a statusIcon;
    private final RandomSource random = RandomSource.create();
    public final DataFixer fixerUpper;
    private String localIp;
    private int port = -1;
    private final LayeredRegistryAccess<RegistryLayer> registries;
    private Map<ResourceKey<World>, WorldServer> levels = Maps.newLinkedHashMap();
    private PlayerList playerList;
    private volatile boolean running = true;
    private boolean stopped;
    private int tickCount;
    private int ticksUntilAutosave = 6000;
    protected final Proxy proxy;
    private boolean onlineMode;
    private boolean preventProxyConnections;
    private boolean pvp;
    private boolean allowFlight;
    @Nullable
    private String motd;
    private int playerIdleTimeout;
    private final long[] tickTimesNanos = new long[100];
    private long aggregatedTickTimesNanos = 0L;
    @Nullable
    private KeyPair keyPair;
    @Nullable
    private GameProfile singleplayerProfile;
    private boolean isDemo;
    private volatile boolean isReady;
    private long lastOverloadWarningNanos;
    protected final Services services;
    private long lastServerStatus;
    public final Thread serverThread;
    private long lastTickNanos = SystemUtils.getNanos();
    private long taskExecutionStartNanos = SystemUtils.getNanos();
    private long idleTimeNanos;
    private long nextTickTimeNanos = SystemUtils.getNanos();
    private long delayedTasksMaxNextTickTimeNanos;
    private boolean mayHaveDelayedTasks;
    private final ResourcePackRepository packRepository;
    private final ScoreboardServer scoreboard = new ScoreboardServer(this);
    @Nullable
    private PersistentCommandStorage commandStorage;
    private final BossBattleCustomData customBossEvents = new BossBattleCustomData();
    private final CustomFunctionData functionManager;
    private boolean enforceWhitelist;
    private float smoothedTickTimeMillis;
    public final Executor executor;
    @Nullable
    private String serverId;
    public ReloadableResources resources;
    private final StructureTemplateManager structureTemplateManager;
    private final ServerTickRateManager tickRateManager;
    protected SaveData worldData;
    private final PotionBrewer potionBrewing;
    private volatile boolean isSaving;

    public static <S extends MinecraftServer> S spin(Function<Thread, S> var02) {
        AtomicReference<MinecraftServer> var12 = new AtomicReference<MinecraftServer>();
        Thread var2 = new Thread(() -> ((MinecraftServer)var12.get()).runServer(), "Server thread");
        var2.setUncaughtExceptionHandler((var0, var1) -> LOGGER.error("Uncaught exception in server thread", var1));
        if (Runtime.getRuntime().availableProcessors() > 4) {
            var2.setPriority(8);
        }
        MinecraftServer var3 = (MinecraftServer)var02.apply(var2);
        var12.set(var3);
        var2.start();
        return (S)var3;
    }

    public MinecraftServer(Thread var02, Convertable.ConversionSession var1, ResourcePackRepository var2, WorldStem var3, Proxy var4, DataFixer var5, Services var6, WorldLoadListenerFactory var7) {
        super("Server");
        this.registries = var3.registries();
        this.worldData = var3.worldData();
        if (!this.registries.compositeAccess().registryOrThrow(Registries.LEVEL_STEM).containsKey(WorldDimension.OVERWORLD)) {
            throw new IllegalStateException("Missing Overworld dimension data");
        }
        this.proxy = var4;
        this.packRepository = var2;
        this.resources = new ReloadableResources(var3.resourceManager(), var3.dataPackResources());
        this.services = var6;
        if (var6.profileCache() != null) {
            var6.profileCache().setExecutor(this);
        }
        this.connection = new ServerConnection(this);
        this.tickRateManager = new ServerTickRateManager(this);
        this.progressListenerFactory = var7;
        this.storageSource = var1;
        this.playerDataStorage = var1.createPlayerStorage();
        this.fixerUpper = var5;
        this.functionManager = new CustomFunctionData(this, this.resources.managers.getFunctionLibrary());
        HolderLookup.b<Block> var8 = this.registries.compositeAccess().registryOrThrow(Registries.BLOCK).asLookup().filterFeatures(this.worldData.enabledFeatures());
        this.structureTemplateManager = new StructureTemplateManager(var3.resourceManager(), var1, var5, var8);
        this.serverThread = var02;
        this.executor = SystemUtils.backgroundExecutor();
        this.potionBrewing = PotionBrewer.bootstrap(this.worldData.enabledFeatures());
    }

    private void readScoreboard(WorldPersistentData var0) {
        var0.computeIfAbsent(this.getScoreboard().dataFactory(), "scoreboard");
    }

    protected abstract boolean initServer() throws IOException;

    protected void loadLevel() {
        if (!JvmProfiler.INSTANCE.isRunning()) {
            // empty if block
        }
        boolean var0 = false;
        ProfiledDuration var1 = JvmProfiler.INSTANCE.onWorldLoadedStarted();
        this.worldData.setModdedInfo(this.getServerModName(), this.getModdedStatus().shouldReportAsModified());
        WorldLoadListener var2 = this.progressListenerFactory.create(this.worldData.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS));
        this.createLevels(var2);
        this.forceDifficulty();
        this.prepareLevels(var2);
        if (var1 != null) {
            var1.finish();
        }
        if (var0) {
            try {
                JvmProfiler.INSTANCE.stop();
            }
            catch (Throwable var3) {
                LOGGER.warn("Failed to stop JFR profiling", var3);
            }
        }
    }

    protected void forceDifficulty() {
    }

    protected void createLevels(WorldLoadListener var0) {
        IWorldDataServer var1 = this.worldData.overworldData();
        boolean var2 = this.worldData.isDebugWorld();
        IRegistry<WorldDimension> var3 = this.registries.compositeAccess().registryOrThrow(Registries.LEVEL_STEM);
        WorldOptions var4 = this.worldData.worldGenOptions();
        long var5 = var4.seed();
        long var7 = BiomeManager.obfuscateSeed(var5);
        ImmutableList var9 = ImmutableList.of((Object)new MobSpawnerPhantom(), (Object)new MobSpawnerPatrol(), (Object)new MobSpawnerCat(), (Object)new VillageSiege(), (Object)new MobSpawnerTrader(var1));
        WorldDimension var10 = var3.get(WorldDimension.OVERWORLD);
        WorldServer var11 = new WorldServer(this, this.executor, this.storageSource, var1, World.OVERWORLD, var10, var0, var2, var7, (List<MobSpawner>)var9, true, null);
        this.levels.put(World.OVERWORLD, var11);
        WorldPersistentData var12 = var11.getDataStorage();
        this.readScoreboard(var12);
        this.commandStorage = new PersistentCommandStorage(var12);
        WorldBorder var13 = var11.getWorldBorder();
        if (!var1.isInitialized()) {
            try {
                MinecraftServer.setInitialSpawn(var11, var1, var4.generateBonusChest(), var2);
                var1.setInitialized(true);
                if (var2) {
                    this.setupDebugLevel(this.worldData);
                }
            }
            catch (Throwable var14) {
                CrashReport var15 = CrashReport.forThrowable(var14, "Exception initializing level");
                try {
                    var11.fillReportDetails(var15);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                throw new ReportedException(var15);
            }
            var1.setInitialized(true);
        }
        this.getPlayerList().addWorldborderListener(var11);
        if (this.worldData.getCustomBossEvents() != null) {
            this.getCustomBossEvents().load(this.worldData.getCustomBossEvents(), this.registryAccess());
        }
        RandomSequences var14 = var11.getRandomSequences();
        for (Map.Entry<ResourceKey<WorldDimension>, WorldDimension> var16 : var3.entrySet()) {
            ResourceKey<WorldDimension> var17 = var16.getKey();
            if (var17 == WorldDimension.OVERWORLD) continue;
            ResourceKey<World> var18 = ResourceKey.create(Registries.DIMENSION, var17.location());
            SecondaryWorldData var19 = new SecondaryWorldData(this.worldData, var1);
            WorldServer var20 = new WorldServer(this, this.executor, this.storageSource, var19, var18, var16.getValue(), var0, var2, var7, (List<MobSpawner>)ImmutableList.of(), false, var14);
            var13.addListener(new IWorldBorderListener.a(var20.getWorldBorder()));
            this.levels.put(var18, var20);
        }
        var13.applySettings(var1.getWorldBorder());
    }

    private static void setInitialSpawn(WorldServer var02, IWorldDataServer var1, boolean var2, boolean var32) {
        if (var32) {
            var1.setSpawn(BlockPosition.ZERO.above(80), 0.0f);
            return;
        }
        ChunkProviderServer var4 = var02.getChunkSource();
        ChunkCoordIntPair var5 = new ChunkCoordIntPair(var4.randomState().sampler().findSpawnPosition());
        int var6 = var4.getGenerator().getSpawnHeight(var02);
        if (var6 < var02.getMinBuildHeight()) {
            BlockPosition var7 = var5.getWorldPosition();
            var6 = var02.getHeight(HeightMap.Type.WORLD_SURFACE, var7.getX() + 8, var7.getZ() + 8);
        }
        var1.setSpawn(var5.getWorldPosition().offset(8, var6, 8), 0.0f);
        int var7 = 0;
        int var8 = 0;
        int var9 = 0;
        int var10 = -1;
        for (int var11 = 0; var11 < MathHelper.square(11); ++var11) {
            BlockPosition var12;
            if (var7 >= -5 && var7 <= 5 && var8 >= -5 && var8 <= 5 && (var12 = WorldProviderNormal.getSpawnPosInChunk(var02, new ChunkCoordIntPair(var5.x + var7, var5.z + var8))) != null) {
                var1.setSpawn(var12, 0.0f);
                break;
            }
            if (var7 == var8 || var7 < 0 && var7 == -var8 || var7 > 0 && var7 == 1 - var8) {
                int var122 = var9;
                var9 = -var10;
                var10 = var122;
            }
            var7 += var9;
            var8 += var10;
        }
        if (var2) {
            var02.registryAccess().registry(Registries.CONFIGURED_FEATURE).flatMap(var0 -> var0.getHolder(MiscOverworldFeatures.BONUS_CHEST)).ifPresent(var3 -> ((WorldGenFeatureConfigured)var3.value()).place(var02, var4.getGenerator(), var0.random, var1.getSpawnPos()));
        }
    }

    private void setupDebugLevel(SaveData var0) {
        var0.setDifficulty(EnumDifficulty.PEACEFUL);
        var0.setDifficultyLocked(true);
        IWorldDataServer var1 = var0.overworldData();
        var1.setRaining(false);
        var1.setThundering(false);
        var1.setClearWeatherTime(1000000000);
        var1.setDayTime(6000L);
        var1.setGameType(EnumGamemode.SPECTATOR);
    }

    public void prepareLevels(WorldLoadListener var0) {
        int var5;
        WorldServer var1 = this.overworld();
        LOGGER.info("Preparing start region for dimension {}", (Object)var1.dimension().location());
        BlockPosition var2 = var1.getSharedSpawnPos();
        var0.updateSpawnPos(new ChunkCoordIntPair(var2));
        ChunkProviderServer var3 = var1.getChunkSource();
        this.nextTickTimeNanos = SystemUtils.getNanos();
        var1.setDefaultSpawnPos(var2, var1.getSharedSpawnAngle());
        int var4 = this.getGameRules().getInt(GameRules.RULE_SPAWN_CHUNK_RADIUS);
        int n2 = var5 = var4 > 0 ? MathHelper.square(WorldLoadListener.calculateDiameter(var4)) : 0;
        while (var3.getTickingGenerated() < var5) {
            this.nextTickTimeNanos = SystemUtils.getNanos() + PREPARE_LEVELS_DEFAULT_DELAY_NANOS;
            this.waitUntilNextTick();
        }
        this.nextTickTimeNanos = SystemUtils.getNanos() + PREPARE_LEVELS_DEFAULT_DELAY_NANOS;
        this.waitUntilNextTick();
        for (WorldServer var7 : this.levels.values()) {
            ForcedChunk var8 = var7.getDataStorage().get(ForcedChunk.factory(), "chunks");
            if (var8 == null) continue;
            LongIterator var9 = var8.getChunks().iterator();
            while (var9.hasNext()) {
                long var10 = var9.nextLong();
                ChunkCoordIntPair var12 = new ChunkCoordIntPair(var10);
                var7.getChunkSource().updateChunkForced(var12, true);
            }
        }
        this.nextTickTimeNanos = SystemUtils.getNanos() + PREPARE_LEVELS_DEFAULT_DELAY_NANOS;
        this.waitUntilNextTick();
        var0.stop();
        this.updateMobSpawningFlags();
    }

    public EnumGamemode getDefaultGameType() {
        return this.worldData.getGameType();
    }

    public boolean isHardcore() {
        return this.worldData.isHardcore();
    }

    public abstract int getOperatorUserPermissionLevel();

    public abstract int getFunctionCompilationLevel();

    public abstract boolean shouldRconBroadcast();

    public boolean saveAllChunks(boolean var0, boolean var1, boolean var2) {
        boolean var3 = false;
        for (WorldServer worldServer : this.getAllLevels()) {
            if (!var0) {
                LOGGER.info("Saving chunks for level '{}'/{}", (Object)worldServer, (Object)worldServer.dimension().location());
            }
            worldServer.save(null, var1, worldServer.noSave && !var2);
            var3 = true;
        }
        WorldServer var4 = this.overworld();
        IWorldDataServer iWorldDataServer = this.worldData.overworldData();
        iWorldDataServer.setWorldBorder(var4.getWorldBorder().createSettings());
        this.worldData.setCustomBossEvents(this.getCustomBossEvents().save(this.registryAccess()));
        this.storageSource.saveDataTag(this.registryAccess(), this.worldData, this.getPlayerList().getSingleplayerData());
        if (var1) {
            for (WorldServer var7 : this.getAllLevels()) {
                LOGGER.info("ThreadedAnvilChunkStorage ({}): All chunks are saved", (Object)var7.getChunkSource().chunkMap.getStorageName());
            }
            LOGGER.info("ThreadedAnvilChunkStorage: All dimensions are saved");
        }
        return var3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveEverything(boolean var0, boolean var1, boolean var2) {
        try {
            this.isSaving = true;
            this.getPlayerList().saveAll();
            boolean bl = this.saveAllChunks(var0, var1, var2);
            return bl;
        }
        finally {
            this.isSaving = false;
        }
    }

    @Override
    public void close() {
        this.stopServer();
    }

    public void stopServer() {
        if (this.metricsRecorder.isRecording()) {
            this.cancelRecordingMetrics();
        }
        LOGGER.info("Stopping server");
        this.getConnection().stop();
        this.isSaving = true;
        if (this.playerList != null) {
            LOGGER.info("Saving players");
            this.playerList.saveAll();
            this.playerList.removeAll();
        }
        LOGGER.info("Saving worlds");
        for (WorldServer var1 : this.getAllLevels()) {
            if (var1 == null) continue;
            var1.noSave = false;
        }
        while (this.levels.values().stream().anyMatch(var0 -> var0.getChunkSource().chunkMap.hasWork())) {
            this.nextTickTimeNanos = SystemUtils.getNanos() + TimeRange.NANOSECONDS_PER_MILLISECOND;
            for (WorldServer var1 : this.getAllLevels()) {
                var1.getChunkSource().removeTicketsOnClosing();
                var1.getChunkSource().tick(() -> true, false);
            }
            this.waitUntilNextTick();
        }
        this.saveAllChunks(false, true, false);
        for (WorldServer var1 : this.getAllLevels()) {
            if (var1 == null) continue;
            try {
                var1.close();
            }
            catch (IOException var2) {
                LOGGER.error("Exception closing the level", (Throwable)var2);
            }
        }
        this.isSaving = false;
        this.resources.close();
        try {
            this.storageSource.close();
        }
        catch (IOException var02) {
            LOGGER.error("Failed to unlock level {}", (Object)this.storageSource.getLevelId(), (Object)var02);
        }
    }

    public String getLocalIp() {
        return this.localIp;
    }

    public void setLocalIp(String var0) {
        this.localIp = var0;
    }

    public boolean isRunning() {
        return this.running;
    }

    public void halt(boolean var0) {
        this.running = false;
        if (var0) {
            try {
                this.serverThread.join();
            }
            catch (InterruptedException var1) {
                LOGGER.error("Error while shutting down", (Throwable)var1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runServer() {
        block28: {
            try {
                if (this.initServer()) {
                    this.nextTickTimeNanos = SystemUtils.getNanos();
                    this.statusIcon = this.loadStatusIcon().orElse(null);
                    this.status = this.buildServerStatus();
                    while (this.running) {
                        boolean var2;
                        long var0;
                        if (!this.isPaused() && this.tickRateManager.isSprinting() && this.tickRateManager.checkShouldSprintThisTick()) {
                            var0 = 0L;
                            this.lastOverloadWarningNanos = this.nextTickTimeNanos = SystemUtils.getNanos();
                        } else {
                            var0 = this.tickRateManager.nanosecondsPerTick();
                            long var22 = SystemUtils.getNanos() - this.nextTickTimeNanos;
                            if (var22 > OVERLOADED_THRESHOLD_NANOS + 20L * var0 && this.nextTickTimeNanos - this.lastOverloadWarningNanos >= OVERLOADED_WARNING_INTERVAL_NANOS + 100L * var0) {
                                long var4 = var22 / var0;
                                LOGGER.warn("Can't keep up! Is the server overloaded? Running {}ms or {} ticks behind", (Object)(var22 / TimeRange.NANOSECONDS_PER_MILLISECOND), (Object)var4);
                                this.nextTickTimeNanos += var4 * var0;
                                this.lastOverloadWarningNanos = this.nextTickTimeNanos;
                            }
                        }
                        boolean bl = var2 = var0 == 0L;
                        if (this.debugCommandProfilerDelayStart) {
                            this.debugCommandProfilerDelayStart = false;
                            this.debugCommandProfiler = new TimeProfiler(SystemUtils.getNanos(), this.tickCount);
                        }
                        this.nextTickTimeNanos += var0;
                        this.startMetricsRecordingTick();
                        this.profiler.push("tick");
                        this.tickServer(var2 ? () -> false : this::haveTime);
                        this.profiler.popPush("nextTickWait");
                        this.mayHaveDelayedTasks = true;
                        this.delayedTasksMaxNextTickTimeNanos = Math.max(SystemUtils.getNanos() + var0, this.nextTickTimeNanos);
                        this.startMeasuringTaskExecutionTime();
                        this.waitUntilNextTick();
                        this.finishMeasuringTaskExecutionTime();
                        if (var2) {
                            this.tickRateManager.endTickWork();
                        }
                        this.profiler.pop();
                        this.logFullTickTime();
                        this.endMetricsRecordingTick();
                        this.isReady = true;
                        JvmProfiler.INSTANCE.onServerTick(this.smoothedTickTimeMillis);
                    }
                    break block28;
                }
                throw new IllegalStateException("Failed to initialize server");
            }
            catch (Throwable var0) {
                LOGGER.error("Encountered an unexpected exception", var0);
                CrashReport var1 = MinecraftServer.constructOrExtractCrashReport(var0);
                this.fillSystemReport(var1.getSystemReport());
                File var2 = new File(new File(this.getServerDirectory(), "crash-reports"), "crash-" + SystemUtils.getFilenameFormattedDateTime() + "-server.txt");
                if (var1.saveToFile(var2)) {
                    LOGGER.error("This crash report has been saved to: {}", (Object)var2.getAbsolutePath());
                } else {
                    LOGGER.error("We were unable to save this crash report to disk.");
                }
                this.onServerCrash(var1);
            }
            finally {
                try {
                    this.stopped = true;
                    this.stopServer();
                }
                catch (Throwable var0) {
                    LOGGER.error("Exception stopping the server", var0);
                }
                finally {
                    if (this.services.profileCache() != null) {
                        this.services.profileCache().clearExecutor();
                    }
                    this.onServerExit();
                }
            }
        }
    }

    private void logFullTickTime() {
        long var0 = SystemUtils.getNanos();
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logSample(var0 - this.lastTickNanos);
        }
        this.lastTickNanos = var0;
    }

    private void startMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            this.taskExecutionStartNanos = SystemUtils.getNanos();
            this.idleTimeNanos = 0L;
        }
    }

    private void finishMeasuringTaskExecutionTime() {
        if (this.isTickTimeLoggingEnabled()) {
            SampleLogger var0 = this.getTickTimeLogger();
            var0.logPartialSample(SystemUtils.getNanos() - this.taskExecutionStartNanos - this.idleTimeNanos, TpsDebugDimensions.SCHEDULED_TASKS.ordinal());
            var0.logPartialSample(this.idleTimeNanos, TpsDebugDimensions.IDLE.ordinal());
        }
    }

    private static CrashReport constructOrExtractCrashReport(Throwable var0) {
        Object var3;
        Object var1 = null;
        for (Throwable var2 = var0; var2 != null; var2 = var2.getCause()) {
            if (!(var2 instanceof ReportedException)) continue;
            var1 = var3 = (ReportedException)var2;
        }
        if (var1 != null) {
            var3 = ((ReportedException)var1).getReport();
            if (var1 != var0) {
                ((CrashReport)var3).addCategory("Wrapped in").setDetailError("Wrapping exception", var0);
            }
        } else {
            var3 = new CrashReport("Exception in server tick loop", var0);
        }
        return var3;
    }

    private boolean haveTime() {
        return this.runningTask() || SystemUtils.getNanos() < (this.mayHaveDelayedTasks ? this.delayedTasksMaxNextTickTimeNanos : this.nextTickTimeNanos);
    }

    protected void waitUntilNextTick() {
        this.runAllTasks();
        this.managedBlock(() -> !this.haveTime());
    }

    @Override
    public void waitForTasks() {
        boolean var0 = this.isTickTimeLoggingEnabled();
        long var1 = var0 ? SystemUtils.getNanos() : 0L;
        super.waitForTasks();
        if (var0) {
            this.idleTimeNanos += SystemUtils.getNanos() - var1;
        }
    }

    @Override
    public TickTask wrapRunnable(Runnable var0) {
        return new TickTask(this.tickCount, var0);
    }

    @Override
    protected boolean shouldRun(TickTask var0) {
        return var0.getTick() + 3 < this.tickCount || this.haveTime();
    }

    @Override
    public boolean pollTask() {
        boolean var0;
        this.mayHaveDelayedTasks = var0 = this.pollTaskInternal();
        return var0;
    }

    private boolean pollTaskInternal() {
        if (super.pollTask()) {
            return true;
        }
        if (this.tickRateManager.isSprinting() || this.haveTime()) {
            for (WorldServer var1 : this.getAllLevels()) {
                if (!var1.getChunkSource().pollTask()) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    protected void doRunTask(TickTask var0) {
        this.getProfiler().incrementCounter("runTask");
        super.doRunTask(var0);
    }

    private Optional<ServerPing.a> loadStatusIcon() {
        Optional<Path> var02 = Optional.of(this.getFile("server-icon.png").toPath()).filter(var0 -> Files.isRegularFile(var0, new LinkOption[0])).or(() -> this.storageSource.getIconFile().filter(var0 -> Files.isRegularFile(var0, new LinkOption[0])));
        return var02.flatMap(var0 -> {
            try {
                BufferedImage var1 = ImageIO.read(var0.toFile());
                Preconditions.checkState((var1.getWidth() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels wide");
                Preconditions.checkState((var1.getHeight() == 64 ? 1 : 0) != 0, (Object)"Must be 64 pixels high");
                ByteArrayOutputStream var2 = new ByteArrayOutputStream();
                ImageIO.write((RenderedImage)var1, "PNG", var2);
                return Optional.of(new ServerPing.a(var2.toByteArray()));
            }
            catch (Exception var1) {
                LOGGER.error("Couldn't load server icon", (Throwable)var1);
                return Optional.empty();
            }
        });
    }

    public Optional<Path> getWorldScreenshotFile() {
        return this.storageSource.getIconFile();
    }

    public File getServerDirectory() {
        return new File(".");
    }

    public void onServerCrash(CrashReport var0) {
    }

    public void onServerExit() {
    }

    public boolean isPaused() {
        return false;
    }

    public void tickServer(BooleanSupplier var0) {
        long var1 = SystemUtils.getNanos();
        ++this.tickCount;
        this.tickRateManager.tick();
        this.tickChildren(var0);
        if (var1 - this.lastServerStatus >= STATUS_EXPIRE_TIME_NANOS) {
            this.lastServerStatus = var1;
            this.status = this.buildServerStatus();
        }
        --this.ticksUntilAutosave;
        if (this.ticksUntilAutosave <= 0) {
            this.ticksUntilAutosave = this.computeNextAutosaveInterval();
            LOGGER.debug("Autosave started");
            this.profiler.push("save");
            this.saveEverything(true, false, false);
            this.profiler.pop();
            LOGGER.debug("Autosave finished");
        }
        this.profiler.push("tallying");
        long var3 = SystemUtils.getNanos() - var1;
        int var5 = this.tickCount % 100;
        this.aggregatedTickTimesNanos -= this.tickTimesNanos[var5];
        this.aggregatedTickTimesNanos += var3;
        this.tickTimesNanos[var5] = var3;
        this.smoothedTickTimeMillis = this.smoothedTickTimeMillis * 0.8f + (float)var3 / (float)TimeRange.NANOSECONDS_PER_MILLISECOND * 0.19999999f;
        this.logTickMethodTime(var1);
        this.profiler.pop();
    }

    private void logTickMethodTime(long var0) {
        if (this.isTickTimeLoggingEnabled()) {
            this.getTickTimeLogger().logPartialSample(SystemUtils.getNanos() - var0, TpsDebugDimensions.TICK_SERVER_METHOD.ordinal());
        }
    }

    private int computeNextAutosaveInterval() {
        float var0;
        if (this.tickRateManager.isSprinting()) {
            long var1 = this.getAverageTickTimeNanos() + 1L;
            var0 = (float)TimeRange.NANOSECONDS_PER_SECOND / (float)var1;
        } else {
            var0 = this.tickRateManager.tickrate();
        }
        int var1 = 300;
        return Math.max(100, (int)(var0 * 300.0f));
    }

    public void onTickRateChanged() {
        int var0 = this.computeNextAutosaveInterval();
        if (var0 < this.ticksUntilAutosave) {
            this.ticksUntilAutosave = var0;
        }
    }

    protected abstract SampleLogger getTickTimeLogger();

    public abstract boolean isTickTimeLoggingEnabled();

    private ServerPing buildServerStatus() {
        ServerPing.ServerPingPlayerSample var0 = this.buildPlayerStatus();
        return new ServerPing(IChatBaseComponent.nullToEmpty(this.motd), Optional.of(var0), Optional.of(ServerPing.ServerData.current()), Optional.ofNullable(this.statusIcon), this.enforceSecureProfile());
    }

    private ServerPing.ServerPingPlayerSample buildPlayerStatus() {
        List<EntityPlayer> var0 = this.playerList.getPlayers();
        int var1 = this.getMaxPlayers();
        if (this.hidesOnlinePlayers()) {
            return new ServerPing.ServerPingPlayerSample(var1, var0.size(), List.of());
        }
        int var2 = Math.min(var0.size(), 12);
        ObjectArrayList var3 = new ObjectArrayList(var2);
        int var4 = MathHelper.nextInt(this.random, 0, var0.size() - var2);
        for (int var5 = 0; var5 < var2; ++var5) {
            EntityPlayer var6 = var0.get(var4 + var5);
            var3.add((Object)(var6.allowsListing() ? var6.getGameProfile() : ANONYMOUS_PLAYER_PROFILE));
        }
        SystemUtils.shuffle(var3, this.random);
        return new ServerPing.ServerPingPlayerSample(var1, var0.size(), (List<GameProfile>)var3);
    }

    public void tickChildren(BooleanSupplier var02) {
        this.getPlayerList().getPlayers().forEach(var0 -> var0.connection.suspendFlushing());
        this.profiler.push("commandFunctions");
        this.getFunctions().tick();
        this.profiler.popPush("levels");
        for (WorldServer worldServer : this.getAllLevels()) {
            this.profiler.push(() -> String.valueOf(worldServer) + " " + String.valueOf(worldServer.dimension().location()));
            if (this.tickCount % 20 == 0) {
                this.profiler.push("timeSync");
                this.synchronizeTime(worldServer);
                this.profiler.pop();
            }
            this.profiler.push("tick");
            try {
                worldServer.tick(var02);
            }
            catch (Throwable var3) {
                CrashReport var4 = CrashReport.forThrowable(var3, "Exception ticking world");
                worldServer.fillReportDetails(var4);
                throw new ReportedException(var4);
            }
            this.profiler.pop();
            this.profiler.pop();
        }
        this.profiler.popPush("connection");
        this.getConnection().tick();
        this.profiler.popPush("players");
        this.playerList.tick();
        if (SharedConstants.IS_RUNNING_IN_IDE && this.tickRateManager.runsNormally()) {
            GameTestHarnessTicker.SINGLETON.tick();
        }
        this.profiler.popPush("server gui refresh");
        for (int var1 = 0; var1 < this.tickables.size(); ++var1) {
            this.tickables.get(var1).run();
        }
        this.profiler.popPush("send chunks");
        for (EntityPlayer entityPlayer : this.playerList.getPlayers()) {
            entityPlayer.connection.chunkSender.sendNextChunks(entityPlayer);
            entityPlayer.connection.resumeFlushing();
        }
        this.profiler.pop();
    }

    private void synchronizeTime(WorldServer var0) {
        this.playerList.broadcastAll(new PacketPlayOutUpdateTime(var0.getGameTime(), var0.getDayTime(), var0.getGameRules().getBoolean(GameRules.RULE_DAYLIGHT)), var0.dimension());
    }

    public void forceTimeSynchronization() {
        this.profiler.push("timeSync");
        for (WorldServer var1 : this.getAllLevels()) {
            this.synchronizeTime(var1);
        }
        this.profiler.pop();
    }

    public boolean isNetherEnabled() {
        return true;
    }

    public void addTickable(Runnable var0) {
        this.tickables.add(var0);
    }

    protected void setId(String var0) {
        this.serverId = var0;
    }

    public boolean isShutdown() {
        return !this.serverThread.isAlive();
    }

    public File getFile(String var0) {
        return new File(this.getServerDirectory(), var0);
    }

    public final WorldServer overworld() {
        return this.levels.get(World.OVERWORLD);
    }

    @Nullable
    public WorldServer getLevel(ResourceKey<World> var0) {
        return this.levels.get(var0);
    }

    public Set<ResourceKey<World>> levelKeys() {
        return this.levels.keySet();
    }

    public Iterable<WorldServer> getAllLevels() {
        return this.levels.values();
    }

    @Override
    public String getServerVersion() {
        return SharedConstants.getCurrentVersion().getName();
    }

    @Override
    public int getPlayerCount() {
        return this.playerList.getPlayerCount();
    }

    @Override
    public int getMaxPlayers() {
        return this.playerList.getMaxPlayers();
    }

    public String[] getPlayerNames() {
        return this.playerList.getPlayerNamesArray();
    }

    @DontObfuscate
    public String getServerModName() {
        return VANILLA_BRAND;
    }

    public SystemReport fillSystemReport(SystemReport var0) {
        var0.setDetail("Server Running", () -> Boolean.toString(this.running));
        if (this.playerList != null) {
            var0.setDetail("Player Count", () -> this.playerList.getPlayerCount() + " / " + this.playerList.getMaxPlayers() + "; " + String.valueOf(this.playerList.getPlayers()));
        }
        var0.setDetail("Active Data Packs", () -> ResourcePackRepository.displayPackList(this.packRepository.getSelectedPacks()));
        var0.setDetail("Available Data Packs", () -> ResourcePackRepository.displayPackList(this.packRepository.getAvailablePacks()));
        var0.setDetail("Enabled Feature Flags", () -> FeatureFlags.REGISTRY.toNames(this.worldData.enabledFeatures()).stream().map(MinecraftKey::toString).collect(Collectors.joining(", ")));
        var0.setDetail("World Generation", () -> this.worldData.worldGenSettingsLifecycle().toString());
        var0.setDetail("World Seed", () -> String.valueOf(this.worldData.worldGenOptions().seed()));
        if (this.serverId != null) {
            var0.setDetail("Server Id", () -> this.serverId);
        }
        return this.fillServerSystemReport(var0);
    }

    public abstract SystemReport fillServerSystemReport(SystemReport var1);

    public ModCheck getModdedStatus() {
        return ModCheck.identify(VANILLA_BRAND, this::getServerModName, "Server", MinecraftServer.class);
    }

    @Override
    public void sendSystemMessage(IChatBaseComponent var0) {
        LOGGER.info(var0.getString());
    }

    public KeyPair getKeyPair() {
        return this.keyPair;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int var0) {
        this.port = var0;
    }

    @Nullable
    public GameProfile getSingleplayerProfile() {
        return this.singleplayerProfile;
    }

    public void setSingleplayerProfile(@Nullable GameProfile var0) {
        this.singleplayerProfile = var0;
    }

    public boolean isSingleplayer() {
        return this.singleplayerProfile != null;
    }

    protected void initializeKeyPair() {
        LOGGER.info("Generating keypair");
        try {
            this.keyPair = MinecraftEncryption.generateKeyPair();
        }
        catch (CryptographyException var0) {
            throw new IllegalStateException("Failed to generate key pair", var0);
        }
    }

    public void setDifficulty(EnumDifficulty var0, boolean var1) {
        if (!var1 && this.worldData.isDifficultyLocked()) {
            return;
        }
        this.worldData.setDifficulty(this.worldData.isHardcore() ? EnumDifficulty.HARD : var0);
        this.updateMobSpawningFlags();
        this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
    }

    public int getScaledTrackingDistance(int var0) {
        return var0;
    }

    private void updateMobSpawningFlags() {
        for (WorldServer var1 : this.getAllLevels()) {
            var1.setSpawnSettings(this.isSpawningMonsters(), this.isSpawningAnimals());
        }
    }

    public void setDifficultyLocked(boolean var0) {
        this.worldData.setDifficultyLocked(var0);
        this.getPlayerList().getPlayers().forEach(this::sendDifficultyUpdate);
    }

    private void sendDifficultyUpdate(EntityPlayer var0) {
        WorldData var1 = var0.level().getLevelData();
        var0.connection.send(new PacketPlayOutServerDifficulty(var1.getDifficulty(), var1.isDifficultyLocked()));
    }

    public boolean isSpawningMonsters() {
        return this.worldData.getDifficulty() != EnumDifficulty.PEACEFUL;
    }

    public boolean isDemo() {
        return this.isDemo;
    }

    public void setDemo(boolean var0) {
        this.isDemo = var0;
    }

    public Optional<ServerResourcePackInfo> getServerResourcePack() {
        return Optional.empty();
    }

    public boolean isResourcePackRequired() {
        return this.getServerResourcePack().filter(ServerResourcePackInfo::isRequired).isPresent();
    }

    public abstract boolean isDedicatedServer();

    public abstract int getRateLimitPacketsPerSecond();

    public boolean usesAuthentication() {
        return this.onlineMode;
    }

    public void setUsesAuthentication(boolean var0) {
        this.onlineMode = var0;
    }

    public boolean getPreventProxyConnections() {
        return this.preventProxyConnections;
    }

    public void setPreventProxyConnections(boolean var0) {
        this.preventProxyConnections = var0;
    }

    public boolean isSpawningAnimals() {
        return true;
    }

    public boolean areNpcsEnabled() {
        return true;
    }

    public abstract boolean isEpollEnabled();

    public boolean isPvpAllowed() {
        return this.pvp;
    }

    public void setPvpAllowed(boolean var0) {
        this.pvp = var0;
    }

    public boolean isFlightAllowed() {
        return this.allowFlight;
    }

    public void setFlightAllowed(boolean var0) {
        this.allowFlight = var0;
    }

    public abstract boolean isCommandBlockEnabled();

    @Override
    public String getMotd() {
        return this.motd;
    }

    public void setMotd(String var0) {
        this.motd = var0;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public PlayerList getPlayerList() {
        return this.playerList;
    }

    public void setPlayerList(PlayerList var0) {
        this.playerList = var0;
    }

    public abstract boolean isPublished();

    public void setDefaultGameType(EnumGamemode var0) {
        this.worldData.setGameType(var0);
    }

    public ServerConnection getConnection() {
        return this.connection;
    }

    public boolean isReady() {
        return this.isReady;
    }

    public boolean hasGui() {
        return false;
    }

    public boolean publishServer(@Nullable EnumGamemode var0, boolean var1, int var2) {
        return false;
    }

    public int getTickCount() {
        return this.tickCount;
    }

    public int getSpawnProtectionRadius() {
        return 16;
    }

    public boolean isUnderSpawnProtection(WorldServer var0, BlockPosition var1, EntityHuman var2) {
        return false;
    }

    public boolean repliesToStatus() {
        return true;
    }

    public boolean hidesOnlinePlayers() {
        return false;
    }

    public Proxy getProxy() {
        return this.proxy;
    }

    public int getPlayerIdleTimeout() {
        return this.playerIdleTimeout;
    }

    public void setPlayerIdleTimeout(int var0) {
        this.playerIdleTimeout = var0;
    }

    public MinecraftSessionService getSessionService() {
        return this.services.sessionService();
    }

    @Nullable
    public SignatureValidator getProfileKeySignatureValidator() {
        return this.services.profileKeySignatureValidator();
    }

    public GameProfileRepository getProfileRepository() {
        return this.services.profileRepository();
    }

    @Nullable
    public UserCache getProfileCache() {
        return this.services.profileCache();
    }

    @Nullable
    public ServerPing getStatus() {
        return this.status;
    }

    public void invalidateStatus() {
        this.lastServerStatus = 0L;
    }

    public int getAbsoluteMaxWorldSize() {
        return 29999984;
    }

    @Override
    public boolean scheduleExecutables() {
        return super.scheduleExecutables() && !this.isStopped();
    }

    @Override
    public void executeIfPossible(Runnable var0) {
        if (this.isStopped()) {
            throw new RejectedExecutionException("Server already shutting down");
        }
        super.executeIfPossible(var0);
    }

    @Override
    public Thread getRunningThread() {
        return this.serverThread;
    }

    public int getCompressionThreshold() {
        return 256;
    }

    public boolean enforceSecureProfile() {
        return false;
    }

    public long getNextTickTime() {
        return this.nextTickTimeNanos;
    }

    public DataFixer getFixerUpper() {
        return this.fixerUpper;
    }

    public int getSpawnRadius(@Nullable WorldServer var0) {
        if (var0 != null) {
            return var0.getGameRules().getInt(GameRules.RULE_SPAWN_RADIUS);
        }
        return 10;
    }

    public AdvancementDataWorld getAdvancements() {
        return this.resources.managers.getAdvancements();
    }

    public CustomFunctionData getFunctions() {
        return this.functionManager;
    }

    public CompletableFuture<Void> reloadResources(Collection<String> var02) {
        CompletionStage var12 = ((CompletableFuture)CompletableFuture.supplyAsync(() -> (ImmutableList)var02.stream().map(this.packRepository::getPack).filter(Objects::nonNull).map(ResourcePackLoader::open).collect(ImmutableList.toImmutableList()), this).thenCompose(var0 -> {
            ResourceManager var12 = new ResourceManager(EnumResourcePackType.SERVER_DATA, (List<IResourcePack>)var0);
            return ((CompletableFuture)DataPackResources.loadResources(var12, this.registries, this.worldData.enabledFeatures(), this.isDedicatedServer() ? CommandDispatcher.ServerType.DEDICATED : CommandDispatcher.ServerType.INTEGRATED, this.getFunctionCompilationLevel(), this.executor, this).whenComplete((var1, var2) -> {
                if (var2 != null) {
                    var12.close();
                }
            })).thenApply(var1 -> new ReloadableResources(var12, (DataPackResources)var1));
        })).thenAcceptAsync(var1 -> {
            this.resources.close();
            this.resources = var1;
            this.packRepository.setSelected(var02);
            WorldDataConfiguration var2 = new WorldDataConfiguration(MinecraftServer.getSelectedPacks(this.packRepository, true), this.worldData.enabledFeatures());
            this.worldData.setDataConfiguration(var2);
            this.resources.managers.updateRegistryTags();
            this.getPlayerList().saveAll();
            this.getPlayerList().reloadResources();
            this.functionManager.replaceLibrary(this.resources.managers.getFunctionLibrary());
            this.structureTemplateManager.onResourceManagerReload(this.resources.resourceManager);
        }, (Executor)this);
        if (this.isSameThread()) {
            this.managedBlock(((CompletableFuture)var12)::isDone);
        }
        return var12;
    }

    public static WorldDataConfiguration configurePackRepository(ResourcePackRepository var0, WorldDataConfiguration var1, boolean var2, boolean var3) {
        DataPackConfiguration var4 = var1.dataPacks();
        FeatureFlagSet var5 = var2 ? FeatureFlagSet.of() : var1.enabledFeatures();
        FeatureFlagSet var6 = var2 ? FeatureFlags.REGISTRY.allFlags() : var1.enabledFeatures();
        var0.reload();
        if (var3) {
            return MinecraftServer.configureRepositoryWithSelection(var0, List.of(VANILLA_BRAND), var5, false);
        }
        LinkedHashSet var7 = Sets.newLinkedHashSet();
        for (String string : var4.getEnabled()) {
            if (var0.isAvailable(string)) {
                var7.add(string);
                continue;
            }
            LOGGER.warn("Missing data pack {}", (Object)string);
        }
        for (ResourcePackLoader resourcePackLoader : var0.getAvailablePacks()) {
            String var10 = resourcePackLoader.getId();
            if (var4.getDisabled().contains(var10)) continue;
            FeatureFlagSet var11 = resourcePackLoader.getRequestedFeatures();
            boolean var12 = var7.contains(var10);
            if (!var12 && resourcePackLoader.getPackSource().shouldAddAutomatically()) {
                if (var11.isSubsetOf(var6)) {
                    LOGGER.info("Found new data pack {}, loading it automatically", (Object)var10);
                    var7.add(var10);
                } else {
                    LOGGER.info("Found new data pack {}, but can't load it due to missing features {}", (Object)var10, (Object)FeatureFlags.printMissingFlags(var6, var11));
                }
            }
            if (!var12 || var11.isSubsetOf(var6)) continue;
            LOGGER.warn("Pack {} requires features {} that are not enabled for this world, disabling pack.", (Object)var10, (Object)FeatureFlags.printMissingFlags(var6, var11));
            var7.remove(var10);
        }
        if (var7.isEmpty()) {
            LOGGER.info("No datapacks selected, forcing vanilla");
            var7.add(VANILLA_BRAND);
        }
        return MinecraftServer.configureRepositoryWithSelection(var0, var7, var5, true);
    }

    private static WorldDataConfiguration configureRepositoryWithSelection(ResourcePackRepository var0, Collection<String> var1, FeatureFlagSet var2, boolean var3) {
        var0.setSelected(var1);
        MinecraftServer.enableForcedFeaturePacks(var0, var2);
        DataPackConfiguration var4 = MinecraftServer.getSelectedPacks(var0, var3);
        FeatureFlagSet var5 = var0.getRequestedFeatureFlags().join(var2);
        return new WorldDataConfiguration(var4, var5);
    }

    private static void enableForcedFeaturePacks(ResourcePackRepository var0, FeatureFlagSet var1) {
        FeatureFlagSet var2 = var0.getRequestedFeatureFlags();
        FeatureFlagSet var3 = var1.subtract(var2);
        if (var3.isEmpty()) {
            return;
        }
        ObjectArraySet var4 = new ObjectArraySet(var0.getSelectedIds());
        for (ResourcePackLoader var6 : var0.getAvailablePacks()) {
            if (var3.isEmpty()) break;
            if (var6.getPackSource() != PackSource.FEATURE) continue;
            String var7 = var6.getId();
            FeatureFlagSet var8 = var6.getRequestedFeatures();
            if (var8.isEmpty() || !var8.intersects(var3) || !var8.isSubsetOf(var1)) continue;
            if (!var4.add(var7)) {
                throw new IllegalStateException("Tried to force '" + var7 + "', but it was already enabled");
            }
            LOGGER.info("Found feature pack ('{}') for requested feature, forcing to enabled", (Object)var7);
            var3 = var3.subtract(var8);
        }
        var0.setSelected((Collection<String>)var4);
    }

    private static DataPackConfiguration getSelectedPacks(ResourcePackRepository var0, boolean var12) {
        Collection<String> var2 = var0.getSelectedIds();
        ImmutableList var3 = ImmutableList.copyOf(var2);
        List<String> var4 = var12 ? var0.getAvailableIds().stream().filter(var1 -> !var2.contains(var1)).toList() : List.of();
        return new DataPackConfiguration((List<String>)var3, var4);
    }

    public void kickUnlistedPlayers(CommandListenerWrapper var0) {
        if (!this.isEnforceWhitelist()) {
            return;
        }
        PlayerList var1 = var0.getServer().getPlayerList();
        WhiteList var2 = var1.getWhiteList();
        ArrayList var3 = Lists.newArrayList(var1.getPlayers());
        for (EntityPlayer var5 : var3) {
            if (var2.isWhiteListed(var5.getGameProfile())) continue;
            var5.connection.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.not_whitelisted"));
        }
    }

    public ResourcePackRepository getPackRepository() {
        return this.packRepository;
    }

    public CommandDispatcher getCommands() {
        return this.resources.managers.getCommands();
    }

    public CommandListenerWrapper createCommandSourceStack() {
        WorldServer var0 = this.overworld();
        return new CommandListenerWrapper(this, var0 == null ? Vec3D.ZERO : Vec3D.atLowerCornerOf(var0.getSharedSpawnPos()), Vec2F.ZERO, var0, 4, "Server", IChatBaseComponent.literal("Server"), this, null);
    }

    @Override
    public boolean acceptsSuccess() {
        return true;
    }

    @Override
    public boolean acceptsFailure() {
        return true;
    }

    @Override
    public abstract boolean shouldInformAdmins();

    public CraftingManager getRecipeManager() {
        return this.resources.managers.getRecipeManager();
    }

    public ScoreboardServer getScoreboard() {
        return this.scoreboard;
    }

    public PersistentCommandStorage getCommandStorage() {
        if (this.commandStorage == null) {
            throw new NullPointerException("Called before server init");
        }
        return this.commandStorage;
    }

    public GameRules getGameRules() {
        return this.overworld().getGameRules();
    }

    public BossBattleCustomData getCustomBossEvents() {
        return this.customBossEvents;
    }

    public boolean isEnforceWhitelist() {
        return this.enforceWhitelist;
    }

    public void setEnforceWhitelist(boolean var0) {
        this.enforceWhitelist = var0;
    }

    public float getCurrentSmoothedTickTime() {
        return this.smoothedTickTimeMillis;
    }

    public ServerTickRateManager tickRateManager() {
        return this.tickRateManager;
    }

    public long getAverageTickTimeNanos() {
        return this.aggregatedTickTimesNanos / (long)Math.min(100, Math.max(this.tickCount, 1));
    }

    public long[] getTickTimesNanos() {
        return this.tickTimesNanos;
    }

    public int getProfilePermissions(GameProfile var0) {
        if (this.getPlayerList().isOp(var0)) {
            OpListEntry var1 = (OpListEntry)this.getPlayerList().getOps().get(var0);
            if (var1 != null) {
                return var1.getLevel();
            }
            if (this.isSingleplayerOwner(var0)) {
                return 4;
            }
            if (this.isSingleplayer()) {
                return this.getPlayerList().isAllowCommandsForAllPlayers() ? 4 : 0;
            }
            return this.getOperatorUserPermissionLevel();
        }
        return 0;
    }

    public GameProfilerFiller getProfiler() {
        return this.profiler;
    }

    public abstract boolean isSingleplayerOwner(GameProfile var1);

    public void dumpServerProperties(Path var0) throws IOException {
    }

    private void saveDebugReport(Path var0) {
        Path var1 = var0.resolve("levels");
        try {
            for (Map.Entry<ResourceKey<World>, WorldServer> var3 : this.levels.entrySet()) {
                MinecraftKey var4 = var3.getKey().location();
                Path var5 = var1.resolve(var4.getNamespace()).resolve(var4.getPath());
                Files.createDirectories(var5, new FileAttribute[0]);
                var3.getValue().saveDebugReport(var5);
            }
            this.dumpGameRules(var0.resolve("gamerules.txt"));
            this.dumpClasspath(var0.resolve("classpath.txt"));
            this.dumpMiscStats(var0.resolve("stats.txt"));
            this.dumpThreads(var0.resolve("threads.txt"));
            this.dumpServerProperties(var0.resolve("server.properties.txt"));
            this.dumpNativeModules(var0.resolve("modules.txt"));
        }
        catch (IOException var2) {
            LOGGER.warn("Failed to save debug report", (Throwable)var2);
        }
    }

    private void dumpMiscStats(Path var0) throws IOException {
        try (BufferedWriter var1 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            var1.write(String.format(Locale.ROOT, "pending_tasks: %d\n", this.getPendingTasksCount()));
            var1.write(String.format(Locale.ROOT, "average_tick_time: %f\n", Float.valueOf(this.getCurrentSmoothedTickTime())));
            var1.write(String.format(Locale.ROOT, "tick_times: %s\n", Arrays.toString(this.tickTimesNanos)));
            var1.write(String.format(Locale.ROOT, "queue: %s\n", SystemUtils.backgroundExecutor()));
        }
    }

    private void dumpGameRules(Path var0) throws IOException {
        try (BufferedWriter var1 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            final ArrayList var2 = Lists.newArrayList();
            final GameRules var3 = this.getGameRules();
            GameRules.visitGameRuleTypes(new GameRules.GameRuleVisitor(this){

                @Override
                public <T extends GameRules.GameRuleValue<T>> void visit(GameRules.GameRuleKey<T> var0, GameRules.GameRuleDefinition<T> var1) {
                    var2.add(String.format(Locale.ROOT, "%s=%s\n", var0.getId(), var3.getRule(var0)));
                }
            });
            for (String var5 : var2) {
                var1.write(var5);
            }
        }
    }

    private void dumpClasspath(Path var0) throws IOException {
        try (BufferedWriter var1 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            String var2 = System.getProperty("java.class.path");
            String var3 = System.getProperty("path.separator");
            for (String var5 : Splitter.on((String)var3).split((CharSequence)var2)) {
                var1.write(var5);
                var1.write("\n");
            }
        }
    }

    private void dumpThreads(Path var0) throws IOException {
        ThreadMXBean var1 = ManagementFactory.getThreadMXBean();
        ThreadInfo[] var2 = var1.dumpAllThreads(true, true);
        Arrays.sort(var2, Comparator.comparing(ThreadInfo::getThreadName));
        try (BufferedWriter var3 = Files.newBufferedWriter(var0, new OpenOption[0]);){
            for (ThreadInfo var7 : var2) {
                var3.write(var7.toString());
                ((Writer)var3).write(10);
            }
        }
    }

    private void dumpNativeModules(Path var02) throws IOException {
        BufferedWriter var1 = Files.newBufferedWriter(var02, new OpenOption[0]);
        try {
            ArrayList var2;
            try {
                var2 = Lists.newArrayList(NativeModuleLister.listModules());
            }
            catch (Throwable var3) {
                LOGGER.warn("Failed to list native modules", var3);
                if (var1 != null) {
                    ((Writer)var1).close();
                }
                return;
            }
            var2.sort(Comparator.comparing(var0 -> var0.name));
            for (NativeModuleLister.a var4 : var2) {
                var1.write(var4.toString());
                ((Writer)var1).write(10);
            }
        }
        finally {
            if (var1 != null) {
                try {
                    ((Writer)var1).close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2;
                    throwable2.addSuppressed(throwable);
                }
            }
        }
    }

    private void startMetricsRecordingTick() {
        if (this.willStartRecordingMetrics) {
            this.metricsRecorder = ActiveMetricsRecorder.createStarted(new ServerMetricsSamplersProvider(SystemUtils.timeSource, this.isDedicatedServer()), SystemUtils.timeSource, SystemUtils.ioPool(), new MetricsPersister("server"), this.onMetricsRecordingStopped, var0 -> {
                this.executeBlocking(() -> this.saveDebugReport(var0.resolve("server")));
                this.onMetricsRecordingFinished.accept((Path)var0);
            });
            this.willStartRecordingMetrics = false;
        }
        this.profiler = GameProfilerTick.decorateFiller(this.metricsRecorder.getProfiler(), GameProfilerTick.createTickProfiler("Server"));
        this.metricsRecorder.startTick();
        this.profiler.startTick();
    }

    public void endMetricsRecordingTick() {
        this.profiler.endTick();
        this.metricsRecorder.endTick();
    }

    public boolean isRecordingMetrics() {
        return this.metricsRecorder.isRecording();
    }

    public void startRecordingMetrics(Consumer<MethodProfilerResults> var0, Consumer<Path> var12) {
        this.onMetricsRecordingStopped = var1 -> {
            this.stopRecordingMetrics();
            var0.accept((MethodProfilerResults)var1);
        };
        this.onMetricsRecordingFinished = var12;
        this.willStartRecordingMetrics = true;
    }

    public void stopRecordingMetrics() {
        this.metricsRecorder = InactiveMetricsRecorder.INSTANCE;
    }

    public void finishRecordingMetrics() {
        this.metricsRecorder.end();
    }

    public void cancelRecordingMetrics() {
        this.metricsRecorder.cancel();
        this.profiler = this.metricsRecorder.getProfiler();
    }

    public Path getWorldPath(SavedFile var0) {
        return this.storageSource.getLevelPath(var0);
    }

    public boolean forceSynchronousWrites() {
        return true;
    }

    public StructureTemplateManager getStructureManager() {
        return this.structureTemplateManager;
    }

    public SaveData getWorldData() {
        return this.worldData;
    }

    public IRegistryCustom.Dimension registryAccess() {
        return this.registries.compositeAccess();
    }

    public LayeredRegistryAccess<RegistryLayer> registries() {
        return this.registries;
    }

    public ReloadableServerRegistries.b reloadableRegistries() {
        return this.resources.managers.fullRegistries();
    }

    public ITextFilter createTextFilterForPlayer(EntityPlayer var0) {
        return ITextFilter.DUMMY;
    }

    public PlayerInteractManager createGameModeForPlayer(EntityPlayer var0) {
        return this.isDemo() ? new DemoPlayerInteractManager(var0) : new PlayerInteractManager(var0);
    }

    @Nullable
    public EnumGamemode getForcedGameType() {
        return null;
    }

    public IResourceManager getResourceManager() {
        return this.resources.resourceManager;
    }

    public boolean isCurrentlySaving() {
        return this.isSaving;
    }

    public boolean isTimeProfilerRunning() {
        return this.debugCommandProfilerDelayStart || this.debugCommandProfiler != null;
    }

    public void startTimeProfiler() {
        this.debugCommandProfilerDelayStart = true;
    }

    public MethodProfilerResults stopTimeProfiler() {
        if (this.debugCommandProfiler == null) {
            return MethodProfilerResultsEmpty.EMPTY;
        }
        MethodProfilerResults var0 = this.debugCommandProfiler.stop(SystemUtils.getNanos(), this.tickCount);
        this.debugCommandProfiler = null;
        return var0;
    }

    public int getMaxChainedNeighborUpdates() {
        return 1000000;
    }

    public void logChatMessage(IChatBaseComponent var0, ChatMessageType.a var1, @Nullable String var2) {
        String var3 = var1.decorate(var0).getString();
        if (var2 != null) {
            LOGGER.info("[{}] {}", (Object)var2, (Object)var3);
        } else {
            LOGGER.info("{}", (Object)var3);
        }
    }

    public ChatDecorator getChatDecorator() {
        return ChatDecorator.PLAIN;
    }

    public boolean logIPs() {
        return true;
    }

    public void subscribeToDebugSample(EntityPlayer var0, RemoteDebugSampleType var1) {
    }

    public boolean acceptsTransfers() {
        return false;
    }

    public void reportChunkLoadFailure(ChunkCoordIntPair var0) {
    }

    public void reportChunkSaveFailure(ChunkCoordIntPair var0) {
    }

    public PotionBrewer potionBrewing() {
        return this.potionBrewing;
    }

    @Override
    public /* synthetic */ void doRunTask(Runnable runnable) {
        this.doRunTask((TickTask)runnable);
    }

    @Override
    public /* synthetic */ boolean shouldRun(Runnable runnable) {
        return this.shouldRun((TickTask)runnable);
    }

    @Override
    public /* synthetic */ Runnable wrapRunnable(Runnable runnable) {
        return this.wrapRunnable(runnable);
    }

    public static final class ReloadableResources
    extends Record
    implements AutoCloseable {
        final IReloadableResourceManager resourceManager;
        final DataPackResources managers;

        ReloadableResources(IReloadableResourceManager var0, DataPackResources var1) {
            this.resourceManager = var0;
            this.managers = var1;
        }

        @Override
        public void close() {
            this.resourceManager.close();
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "resourceManager", "managers"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "resourceManager", "managers"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{ReloadableResources.class, "resourceManager;managers", "resourceManager", "managers"}, this, var0);
        }

        public IReloadableResourceManager resourceManager() {
            return this.resourceManager;
        }

        public DataPackResources managers() {
            return this.managers;
        }
    }

    static class TimeProfiler {
        final long startNanos;
        final int startTick;

        TimeProfiler(long var0, int var2) {
            this.startNanos = var0;
            this.startTick = var2;
        }

        MethodProfilerResults stop(final long var0, final int var2) {
            return new MethodProfilerResults(){

                @Override
                public List<MethodProfilerResultsField> getTimes(String var02) {
                    return Collections.emptyList();
                }

                @Override
                public boolean saveResults(Path var02) {
                    return false;
                }

                @Override
                public long getStartTimeNano() {
                    return startNanos;
                }

                @Override
                public int getStartTimeTicks() {
                    return startTick;
                }

                @Override
                public long getEndTimeNano() {
                    return var0;
                }

                @Override
                public int getEndTimeTicks() {
                    return var2;
                }

                @Override
                public String getProfilerResults() {
                    return "";
                }
            };
        }
    }

    public record ServerResourcePackInfo(UUID id, String url, String hash, boolean isRequired, @Nullable IChatBaseComponent prompt) {
    }
}

