/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.minecraft.SharedConstants;
import org.slf4j.Logger;

public class EULA {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Path file;
    private final boolean agreed;

    public EULA(Path var0) {
        this.file = var0;
        this.agreed = SharedConstants.IS_RUNNING_IN_IDE || this.readFile();
    }

    private boolean readFile() {
        boolean bl;
        block8: {
            InputStream var0 = Files.newInputStream(this.file, new OpenOption[0]);
            try {
                Properties var1 = new Properties();
                var1.load(var0);
                bl = Boolean.parseBoolean(var1.getProperty("eula", "false"));
                if (var0 == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (var0 != null) {
                        try {
                            var0.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception var02) {
                    LOGGER.warn("Failed to load {}", (Object)this.file);
                    this.saveDefaults();
                    return false;
                }
            }
            var0.close();
        }
        return bl;
    }

    public boolean hasAgreedToEULA() {
        return this.agreed;
    }

    private void saveDefaults() {
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            return;
        }
        try (OutputStream var0 = Files.newOutputStream(this.file, new OpenOption[0]);){
            Properties var1 = new Properties();
            var1.setProperty("eula", "false");
            var1.store(var0, "By changing the setting below to TRUE you are indicating your agreement to our EULA (https://aka.ms/MinecraftEULA).");
        }
        catch (Exception var02) {
            LOGGER.warn("Failed to save {}", (Object)this.file, (Object)var02);
        }
    }
}

