/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server;

import com.mojang.logging.LogUtils;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandDispatcher;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.AdvancementDataWorld;
import net.minecraft.server.CustomFunctionManager;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.ReloadableServerRegistries;
import net.minecraft.server.packs.resources.IReloadListener;
import net.minecraft.server.packs.resources.IResourceManager;
import net.minecraft.server.packs.resources.Reloadable;
import net.minecraft.tags.TagKey;
import net.minecraft.tags.TagRegistry;
import net.minecraft.util.Unit;
import net.minecraft.world.flag.FeatureFlagSet;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TileEntityFurnace;
import org.slf4j.Logger;

public class DataPackResources {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final CompletableFuture<Unit> DATA_RELOAD_INITIAL_TASK = CompletableFuture.completedFuture(Unit.INSTANCE);
    private final ReloadableServerRegistries.b fullRegistryHolder;
    private final a registryLookup;
    public CommandDispatcher commands;
    private final CraftingManager recipes;
    private final TagRegistry tagManager;
    private final AdvancementDataWorld advancements;
    private final CustomFunctionManager functionLibrary;

    private DataPackResources(IRegistryCustom.Dimension var0, FeatureFlagSet var1, CommandDispatcher.ServerType var2, int var3) {
        this.fullRegistryHolder = new ReloadableServerRegistries.b(var0);
        this.registryLookup = new a(var0);
        this.registryLookup.missingTagAccessPolicy(b.CREATE_NEW);
        this.recipes = new CraftingManager(this.registryLookup);
        this.tagManager = new TagRegistry(var0);
        this.commands = new CommandDispatcher(var2, CommandBuildContext.simple(this.registryLookup, var1));
        this.advancements = new AdvancementDataWorld(this.registryLookup);
        this.functionLibrary = new CustomFunctionManager(var3, this.commands.getDispatcher());
    }

    public CustomFunctionManager getFunctionLibrary() {
        return this.functionLibrary;
    }

    public ReloadableServerRegistries.b fullRegistries() {
        return this.fullRegistryHolder;
    }

    public CraftingManager getRecipeManager() {
        return this.recipes;
    }

    public CommandDispatcher getCommands() {
        return this.commands;
    }

    public AdvancementDataWorld getAdvancements() {
        return this.advancements;
    }

    public List<IReloadListener> listeners() {
        return List.of(this.tagManager, this.recipes, this.functionLibrary, this.advancements);
    }

    public static CompletableFuture<DataPackResources> loadResources(IResourceManager var0, LayeredRegistryAccess<RegistryLayer> var1, FeatureFlagSet var2, CommandDispatcher.ServerType var3, int var4, Executor var5, Executor var62) {
        return ReloadableServerRegistries.reload(var1, var0, var5).thenCompose(var6 -> {
            DataPackResources var7 = new DataPackResources(var6.compositeAccess(), var2, var3, var4);
            return ((CompletableFuture)Reloadable.create(var0, var7.listeners(), var5, var62, DATA_RELOAD_INITIAL_TASK, LOGGER.isDebugEnabled()).done().whenComplete((var1, var2) -> var0.registryLookup.missingTagAccessPolicy(b.FAIL))).thenApply(var1 -> var7);
        });
    }

    public void updateRegistryTags() {
        this.tagManager.getResult().forEach(var0 -> DataPackResources.updateRegistryTags(this.fullRegistryHolder.get(), var0));
        TileEntityFurnace.invalidateCache();
        Blocks.rebuildCache();
    }

    private static <T> void updateRegistryTags(IRegistryCustom var02, TagRegistry.a<T> var12) {
        ResourceKey var2 = var12.key();
        Map var3 = var12.tags().entrySet().stream().collect(Collectors.toUnmodifiableMap(var1 -> TagKey.create(var2, (MinecraftKey)var1.getKey()), var0 -> List.copyOf((Collection)var0.getValue())));
        var02.registryOrThrow(var2).bindTags(var3);
    }

    static class a
    implements HolderLookup.a {
        private final IRegistryCustom registryAccess;
        b missingTagAccessPolicy = b.FAIL;

        a(IRegistryCustom var0) {
            this.registryAccess = var0;
        }

        public void missingTagAccessPolicy(b var0) {
            this.missingTagAccessPolicy = var0;
        }

        @Override
        public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries() {
            return this.registryAccess.listRegistries();
        }

        @Override
        public <T> Optional<HolderLookup.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var02) {
            return this.registryAccess.registry(var02).map(var0 -> this.createDispatchedLookup(var0.asLookup(), var0.asTagAddingLookup()));
        }

        private <T> HolderLookup.b<T> createDispatchedLookup(final HolderLookup.b<T> var0, final HolderLookup.b<T> var1) {
            return new HolderLookup.b.a<T>(){

                @Override
                public HolderLookup.b<T> parent() {
                    return switch (missingTagAccessPolicy.ordinal()) {
                        default -> throw new MatchException(null, null);
                        case 1 -> var0;
                        case 0 -> var1;
                    };
                }
            };
        }
    }

    static final class b
    extends Enum<b> {
        public static final /* enum */ b CREATE_NEW = new b();
        public static final /* enum */ b FAIL = new b();
        private static final /* synthetic */ b[] c;

        public static b[] values() {
            return (b[])c.clone();
        }

        public static b valueOf(String var0) {
            return Enum.valueOf(b.class, var0);
        }

        private static /* synthetic */ b[] a() {
            return new b[]{CREATE_NEW, FAIL};
        }

        static {
            c = b.a();
        }
    }
}

