/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3D;

public class PacketPlayOutEntityVelocity
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutEntityVelocity> STREAM_CODEC = Packet.codec(PacketPlayOutEntityVelocity::write, PacketPlayOutEntityVelocity::new);
    private final int id;
    private final int xa;
    private final int ya;
    private final int za;

    public PacketPlayOutEntityVelocity(Entity var0) {
        this(var0.getId(), var0.getDeltaMovement());
    }

    public PacketPlayOutEntityVelocity(int var0, Vec3D var1) {
        this.id = var0;
        double var2 = 3.9;
        double var4 = MathHelper.clamp(var1.x, -3.9, 3.9);
        double var6 = MathHelper.clamp(var1.y, -3.9, 3.9);
        double var8 = MathHelper.clamp(var1.z, -3.9, 3.9);
        this.xa = (int)(var4 * 8000.0);
        this.ya = (int)(var6 * 8000.0);
        this.za = (int)(var8 * 8000.0);
    }

    private PacketPlayOutEntityVelocity(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.xa = var0.readShort();
        this.ya = var0.readShort();
        this.za = var0.readShort();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeShort(this.xa);
        var0.writeShort(this.ya);
        var0.writeShort(this.za);
    }

    @Override
    public PacketType<PacketPlayOutEntityVelocity> type() {
        return GamePacketTypes.CLIENTBOUND_SET_ENTITY_MOTION;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleSetEntityMotion(this);
    }

    public int getId() {
        return this.id;
    }

    public int getXa() {
        return this.xa;
    }

    public int getYa() {
        return this.ya;
    }

    public int getZa() {
        return this.za;
    }
}

