/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectList;

public class PacketPlayOutEntityEffect
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<RegistryFriendlyByteBuf, PacketPlayOutEntityEffect> STREAM_CODEC = Packet.codec(PacketPlayOutEntityEffect::write, PacketPlayOutEntityEffect::new);
    private static final int FLAG_AMBIENT = 1;
    private static final int FLAG_VISIBLE = 2;
    private static final int FLAG_SHOW_ICON = 4;
    private static final int FLAG_BLEND = 8;
    private final int entityId;
    private final Holder<MobEffectList> effect;
    private final int effectAmplifier;
    private final int effectDurationTicks;
    private final byte flags;

    public PacketPlayOutEntityEffect(int var0, MobEffect var1, boolean var2) {
        this.entityId = var0;
        this.effect = var1.getEffect();
        this.effectAmplifier = var1.getAmplifier();
        this.effectDurationTicks = var1.getDuration();
        byte var3 = 0;
        if (var1.isAmbient()) {
            var3 = (byte)(var3 | 1);
        }
        if (var1.isVisible()) {
            var3 = (byte)(var3 | 2);
        }
        if (var1.showIcon()) {
            var3 = (byte)(var3 | 4);
        }
        if (var2) {
            var3 = (byte)(var3 | 8);
        }
        this.flags = var3;
    }

    private PacketPlayOutEntityEffect(RegistryFriendlyByteBuf var0) {
        this.entityId = var0.readVarInt();
        this.effect = (Holder)ByteBufCodecs.holderRegistry(Registries.MOB_EFFECT).decode(var0);
        this.effectAmplifier = var0.readVarInt();
        this.effectDurationTicks = var0.readVarInt();
        this.flags = var0.readByte();
    }

    private void write(RegistryFriendlyByteBuf var0) {
        var0.writeVarInt(this.entityId);
        ByteBufCodecs.holderRegistry(Registries.MOB_EFFECT).encode(var0, this.effect);
        var0.writeVarInt(this.effectAmplifier);
        var0.writeVarInt(this.effectDurationTicks);
        var0.writeByte(this.flags);
    }

    @Override
    public PacketType<PacketPlayOutEntityEffect> type() {
        return GamePacketTypes.CLIENTBOUND_UPDATE_MOB_EFFECT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleUpdateMobEffect(this);
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Holder<MobEffectList> getEffect() {
        return this.effect;
    }

    public int getEffectAmplifier() {
        return this.effectAmplifier;
    }

    public int getEffectDurationTicks() {
        return this.effectDurationTicks;
    }

    public boolean isEffectVisible() {
        return (this.flags & 2) != 0;
    }

    public boolean isEffectAmbient() {
        return (this.flags & 1) != 0;
    }

    public boolean effectShowsIcon() {
        return (this.flags & 4) != 0;
    }

    public boolean shouldBlend() {
        return (this.flags & 8) != 0;
    }
}

