/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.List;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.chunk.Chunk;
import net.minecraft.world.level.chunk.ChunkSection;

public record ClientboundChunksBiomesPacket(List<a> chunkBiomeData) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<PacketDataSerializer, ClientboundChunksBiomesPacket> STREAM_CODEC = Packet.codec(ClientboundChunksBiomesPacket::write, ClientboundChunksBiomesPacket::new);
    private static final int TWO_MEGABYTES = 0x200000;

    private ClientboundChunksBiomesPacket(PacketDataSerializer var0) {
        this(var0.readList(a::new));
    }

    public static ClientboundChunksBiomesPacket forChunks(List<Chunk> var0) {
        return new ClientboundChunksBiomesPacket(var0.stream().map(a::new).toList());
    }

    private void write(PacketDataSerializer var02) {
        var02.writeCollection(this.chunkBiomeData, (var0, var1) -> var1.write((PacketDataSerializer)((Object)var0)));
    }

    @Override
    public PacketType<ClientboundChunksBiomesPacket> type() {
        return GamePacketTypes.CLIENTBOUND_CHUNKS_BIOMES;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleChunksBiomes(this);
    }

    public record a(ChunkCoordIntPair pos, byte[] buffer) {
        public a(Chunk var0) {
            this(var0.getPos(), new byte[a.calculateChunkSize(var0)]);
            a.extractChunkData(new PacketDataSerializer(this.getWriteBuffer()), var0);
        }

        public a(PacketDataSerializer var0) {
            this(var0.readChunkPos(), var0.readByteArray(0x200000));
        }

        private static int calculateChunkSize(Chunk var0) {
            int var1 = 0;
            for (ChunkSection var5 : var0.getSections()) {
                var1 += var5.getBiomes().getSerializedSize();
            }
            return var1;
        }

        public PacketDataSerializer getReadBuffer() {
            return new PacketDataSerializer(Unpooled.wrappedBuffer((byte[])this.buffer));
        }

        private ByteBuf getWriteBuffer() {
            ByteBuf var0 = Unpooled.wrappedBuffer((byte[])this.buffer);
            var0.writerIndex(0);
            return var0;
        }

        public static void extractChunkData(PacketDataSerializer var0, Chunk var1) {
            for (ChunkSection var5 : var1.getSections()) {
                var5.getBiomes().write(var0);
            }
        }

        public void write(PacketDataSerializer var0) {
            var0.writeChunkPos(this.pos);
            var0.writeByteArray(this.buffer);
        }
    }
}

