/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public record BrainDebugPayload(a brainDump) implements CustomPacketPayload
{
    public static final StreamCodec<PacketDataSerializer, BrainDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BrainDebugPayload::write, BrainDebugPayload::new);
    public static final CustomPacketPayload.b<BrainDebugPayload> TYPE = CustomPacketPayload.createType("debug/brain");

    private BrainDebugPayload(PacketDataSerializer var0) {
        this(new a(var0));
    }

    private void write(PacketDataSerializer var0) {
        this.brainDump.write(var0);
    }

    public CustomPacketPayload.b<BrainDebugPayload> type() {
        return TYPE;
    }

    public record a(UUID uuid, int id, String name, String profession, int xp, float health, float maxHealth, Vec3D pos, String inventory, @Nullable PathEntity path, boolean wantsGolem, int angerLevel, List<String> activities, List<String> behaviors, List<String> memories, List<String> gossips, Set<BlockPosition> pois, Set<BlockPosition> potentialPois) {
        public a(PacketDataSerializer var0) {
            this(var0.readUUID(), var0.readInt(), var0.readUtf(), var0.readUtf(), var0.readInt(), var0.readFloat(), var0.readFloat(), var0.readVec3(), var0.readUtf(), var0.readNullable(PathEntity::createFromStream), var0.readBoolean(), var0.readInt(), var0.readList(PacketDataSerializer::readUtf), var0.readList(PacketDataSerializer::readUtf), var0.readList(PacketDataSerializer::readUtf), var0.readList(PacketDataSerializer::readUtf), var0.readCollection(HashSet::new, BlockPosition.STREAM_CODEC), var0.readCollection(HashSet::new, BlockPosition.STREAM_CODEC));
        }

        public void write(PacketDataSerializer var02) {
            var02.writeUUID(this.uuid);
            var02.writeInt(this.id);
            var02.writeUtf(this.name);
            var02.writeUtf(this.profession);
            var02.writeInt(this.xp);
            var02.writeFloat(this.health);
            var02.writeFloat(this.maxHealth);
            var02.writeVec3(this.pos);
            var02.writeUtf(this.inventory);
            var02.writeNullable(this.path, (var0, var1) -> var1.writeToStream((PacketDataSerializer)((Object)var0)));
            var02.writeBoolean(this.wantsGolem);
            var02.writeInt(this.angerLevel);
            var02.writeCollection(this.activities, PacketDataSerializer::writeUtf);
            var02.writeCollection(this.behaviors, PacketDataSerializer::writeUtf);
            var02.writeCollection(this.memories, PacketDataSerializer::writeUtf);
            var02.writeCollection(this.gossips, PacketDataSerializer::writeUtf);
            var02.writeCollection(this.pois, BlockPosition.STREAM_CODEC);
            var02.writeCollection(this.potentialPois, BlockPosition.STREAM_CODEC);
        }

        public boolean hasPoi(BlockPosition var0) {
            return this.pois.contains(var0);
        }

        public boolean hasPotentialPoi(BlockPosition var0) {
            return this.potentialPois.contains(var0);
        }
    }
}

