/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    private final EnumProtocol protocol;
    private final EnumProtocolDirection flow;
    private final List<a<T, ?, B>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(EnumProtocol var0, EnumProtocolDirection var1) {
        this.protocol = var0;
        this.flow = var1;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> addPacket(PacketType<P> var0, StreamCodec<? super B, P> var1) {
        this.codecs.add(new a(var0, var1));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> withBundlePacket(PacketType<P> var0, Function<Iterable<Packet<? super T>>, P> var1, D var2) {
        StreamCodec var3 = StreamCodec.unit(var2);
        PacketType<BundleDelimiterPacket<? super T>> var4 = var2.type();
        this.codecs.add(new a(var4, var3));
        this.bundlerInfo = BundlerInfo.createForPacket(var0, var1, var2);
        return this;
    }

    private StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> var0, List<a<T, ?, B>> var1) {
        ProtocolCodecBuilder var2 = new ProtocolCodecBuilder(this.flow);
        for (a a2 : var1) {
            a2.addToBuilder(var2, var0);
        }
        return var2.build();
    }

    public ProtocolInfo<T> build(Function<ByteBuf, B> var0) {
        return new b(this.protocol, this.flow, this.buildPacketCodec(var0, this.codecs), this.bundlerInfo);
    }

    public ProtocolInfo.a<T, B> buildUnbound() {
        List<a<T, ?, B>> var0 = List.copyOf(this.codecs);
        BundlerInfo var1 = this.bundlerInfo;
        return var2 -> new b(this.protocol, this.flow, this.buildPacketCodec(var2, var0), var1);
    }

    private static <L extends PacketListener> ProtocolInfo<L> protocol(EnumProtocol var0, EnumProtocolDirection var1, Consumer<ProtocolInfoBuilder<L, PacketDataSerializer>> var2) {
        ProtocolInfoBuilder var3 = new ProtocolInfoBuilder(var0, var1);
        var2.accept(var3);
        return var3.build(PacketDataSerializer::new);
    }

    public static <T extends ServerboundPacketListener> ProtocolInfo<T> serverboundProtocol(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, PacketDataSerializer>> var1) {
        return ProtocolInfoBuilder.protocol(var0, EnumProtocolDirection.SERVERBOUND, var1);
    }

    public static <T extends ClientboundPacketListener> ProtocolInfo<T> clientboundProtocol(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, PacketDataSerializer>> var1) {
        return ProtocolInfoBuilder.protocol(var0, EnumProtocolDirection.CLIENTBOUND, var1);
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.a<L, B> protocolUnbound(EnumProtocol var0, EnumProtocolDirection var1, Consumer<ProtocolInfoBuilder<L, B>> var2) {
        ProtocolInfoBuilder var3 = new ProtocolInfoBuilder(var0, var1);
        var2.accept(var3);
        return var3.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> serverboundProtocolUnbound(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, B>> var1) {
        return ProtocolInfoBuilder.protocolUnbound(var0, EnumProtocolDirection.SERVERBOUND, var1);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> clientboundProtocolUnbound(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, B>> var1) {
        return ProtocolInfoBuilder.protocolUnbound(var0, EnumProtocolDirection.CLIENTBOUND, var1);
    }

    record a<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>(PacketType<P> type, StreamCodec<? super B, P> serializer) {
        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> var0, Function<ByteBuf, B> var1) {
            StreamCodec<ByteBuf, P> var2 = this.serializer.mapStream(var1);
            var0.add(this.type, var2);
        }
    }

    record b<L extends PacketListener>(EnumProtocol id, EnumProtocolDirection flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

