/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import com.mojang.logging.LogUtils;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.ReportedException;
import net.minecraft.network.PacketListener;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.thread.IAsyncTaskHandler;
import org.slf4j.Logger;

public class PlayerConnectionUtils {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, WorldServer var2) throws CancelledPacketHandleException {
        PlayerConnectionUtils.ensureRunningOnSameThread(var0, var1, var2.getServer());
    }

    public static <T extends PacketListener> void ensureRunningOnSameThread(Packet<T> var0, T var1, IAsyncTaskHandler<?> var2) throws CancelledPacketHandleException {
        if (!var2.isSameThread()) {
            var2.executeIfPossible(() -> {
                if (var1.shouldHandleMessage(var0)) {
                    try {
                        var0.handle(var1);
                    }
                    catch (Exception var2) {
                        ReportedException var3;
                        if (var2 instanceof ReportedException && (var3 = (ReportedException)var2).getCause() instanceof OutOfMemoryError) {
                            throw PlayerConnectionUtils.makeReportedException(var2, var0, var1);
                        }
                        var1.onPacketError(var0, var2);
                    }
                } else {
                    LOGGER.debug("Ignoring packet due to disconnection: {}", (Object)var0);
                }
            });
            throw CancelledPacketHandleException.RUNNING_ON_DIFFERENT_THREAD;
        }
    }

    public static <T extends PacketListener> ReportedException makeReportedException(Exception var0, Packet<T> var1, T var2) {
        if (var0 instanceof ReportedException) {
            ReportedException var3 = (ReportedException)var0;
            PlayerConnectionUtils.fillCrashReport(var3.getReport(), var2, var1);
            return var3;
        }
        CrashReport var4 = CrashReport.forThrowable(var0, "Main thread packet handler");
        PlayerConnectionUtils.fillCrashReport(var4, var2, var1);
        return new ReportedException(var4);
    }

    private static <T extends PacketListener> void fillCrashReport(CrashReport var0, T var1, Packet<T> var2) {
        CrashReportSystemDetails var3 = var0.addCategory("Incoming Packet");
        var3.setDetail("Type", () -> var2.type().toString());
        var3.setDetail("Is Terminal", () -> Boolean.toString(var2.isTerminal()));
        var3.setDetail("Is Skippable", () -> Boolean.toString(var2.isSkippable()));
        var1.fillCrashReport(var0);
    }
}

