/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Stream;
import net.minecraft.EnumChatFormat;
import net.minecraft.FileUtils;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.structures.DebugReportNBT;
import net.minecraft.gametest.framework.GameTestBatchListener;
import net.minecraft.gametest.framework.GameTestHarnessBatch;
import net.minecraft.gametest.framework.GameTestHarnessCollector;
import net.minecraft.gametest.framework.GameTestHarnessInfo;
import net.minecraft.gametest.framework.GameTestHarnessListener;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessRunner;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestClassArgument;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.gametest.framework.GameTestHarnessTicker;
import net.minecraft.gametest.framework.RetryOptions;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.StructureGridSpawner;
import net.minecraft.gametest.framework.TestFinder;
import net.minecraft.gametest.framework.TestFunctionFinder;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketDebug;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.util.MathHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EnumBlockRotation;
import net.minecraft.world.level.block.entity.TileEntityStructure;
import net.minecraft.world.level.levelgen.HeightMap;
import net.minecraft.world.level.levelgen.structure.StructureBoundingBox;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;

public class GameTestHarnessTestCommand {
    public static final int STRUCTURE_BLOCK_NEARBY_SEARCH_RADIUS = 15;
    public static final int STRUCTURE_BLOCK_FULL_SEARCH_RADIUS = 200;
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final int DEFAULT_CLEAR_RADIUS = 200;
    private static final int MAX_CLEAR_RADIUS = 1024;
    private static final int TEST_POS_Z_OFFSET_FROM_PLAYER = 3;
    private static final int SHOW_POS_DURATION_MS = 10000;
    private static final int DEFAULT_X_SIZE = 5;
    private static final int DEFAULT_Y_SIZE = 5;
    private static final int DEFAULT_Z_SIZE = 5;
    private static final String STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND = "Structure block entity could not be found";
    private static final TestFinder.a<a> testFinder = new TestFinder.a<a>(a::new);

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptions(ArgumentBuilder<CommandListenerWrapper, ?> var0, Function<CommandContext<CommandListenerWrapper>, a> var12, Function<ArgumentBuilder<CommandListenerWrapper, ?>, ArgumentBuilder<CommandListenerWrapper, ?>> var2) {
        return var0.executes(var1 -> ((a)var12.apply(var1)).run()).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("numberOfTimes", IntegerArgumentType.integer((int)0)).executes(var1 -> ((a)var12.apply(var1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), false)))).then(var2.apply(net.minecraft.commands.CommandDispatcher.argument("untilFailed", BoolArgumentType.bool()).executes(var1 -> ((a)var12.apply(var1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")))))));
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptions(ArgumentBuilder<CommandListenerWrapper, ?> var02, Function<CommandContext<CommandListenerWrapper>, a> var1) {
        return GameTestHarnessTestCommand.runWithRetryOptions(var02, var1, var0 -> var0);
    }

    private static ArgumentBuilder<CommandListenerWrapper, ?> runWithRetryOptionsAndBuildInfo(ArgumentBuilder<CommandListenerWrapper, ?> var0, Function<CommandContext<CommandListenerWrapper>, a> var1) {
        return GameTestHarnessTestCommand.runWithRetryOptions(var0, var1, var12 -> var12.then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("rotationSteps", IntegerArgumentType.integer()).executes(var1 -> ((a)var1.apply(var1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps")))).then(net.minecraft.commands.CommandDispatcher.argument("testsPerRow", IntegerArgumentType.integer()).executes(var1 -> ((a)var1.apply(var1)).run(new RetryOptions(IntegerArgumentType.getInteger((CommandContext)var1, (String)"numberOfTimes"), BoolArgumentType.getBool((CommandContext)var1, (String)"untilFailed")), IntegerArgumentType.getInteger((CommandContext)var1, (String)"rotationSteps"), IntegerArgumentType.getInteger((CommandContext)var1, (String)"testsPerRow"))))));
    }

    public static void register(CommandDispatcher<CommandListenerWrapper> var02) {
        ArgumentBuilder<CommandListenerWrapper, ?> var1 = GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.argument("onlyRequiredTests", BoolArgumentType.bool()), var0 -> testFinder.failedTests((CommandContext<CommandListenerWrapper>)var0, BoolArgumentType.getBool((CommandContext)var0, (String)"onlyRequiredTests")));
        ArgumentBuilder<CommandListenerWrapper, ?> var2 = GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.argument("testClassName", GameTestHarnessTestClassArgument.testClassName()), var0 -> testFinder.allTestsInClass((CommandContext<CommandListenerWrapper>)var0, GameTestHarnessTestClassArgument.getTestClassName((CommandContext<CommandListenerWrapper>)var0, "testClassName")));
        var02.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("test").then(net.minecraft.commands.CommandDispatcher.literal("run").then(GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.argument("testName", GameTestHarnessTestFunctionArgument.testFunctionArgument()), var0 -> testFinder.byArgument((CommandContext<CommandListenerWrapper>)var0, "testName"))))).then(net.minecraft.commands.CommandDispatcher.literal("runmultiple").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("testName", GameTestHarnessTestFunctionArgument.testFunctionArgument()).executes(var0 -> testFinder.byArgument((CommandContext<CommandListenerWrapper>)var0, "testName").run())).then(net.minecraft.commands.CommandDispatcher.argument("amount", IntegerArgumentType.integer()).executes(var0 -> testFinder.createMultipleCopies(IntegerArgumentType.getInteger((CommandContext)var0, (String)"amount")).byArgument((CommandContext<CommandListenerWrapper>)var0, "testName").run()))))).then(GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.literal("runall").then(var2), testFinder::allTests))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runthese"), testFinder::allNearby))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runclosest"), testFinder::nearest))).then(GameTestHarnessTestCommand.runWithRetryOptions(net.minecraft.commands.CommandDispatcher.literal("runthat"), testFinder::lookedAt))).then(GameTestHarnessTestCommand.runWithRetryOptionsAndBuildInfo(net.minecraft.commands.CommandDispatcher.literal("runfailed").then(var1), testFinder::failedTests))).then(net.minecraft.commands.CommandDispatcher.literal("locate").then(net.minecraft.commands.CommandDispatcher.argument("testName", GameTestHarnessTestFunctionArgument.testFunctionArgument()).executes(var0 -> testFinder.locateByName((CommandContext<CommandListenerWrapper>)var0, "minecraft:" + GameTestHarnessTestFunctionArgument.getTestFunction((CommandContext<CommandListenerWrapper>)var0, "testName").structureName()).locate())))).then(net.minecraft.commands.CommandDispatcher.literal("resetclosest").executes(var0 -> testFinder.nearest((CommandContext<CommandListenerWrapper>)var0).reset()))).then(net.minecraft.commands.CommandDispatcher.literal("resetthese").executes(var0 -> testFinder.allNearby((CommandContext<CommandListenerWrapper>)var0).reset()))).then(net.minecraft.commands.CommandDispatcher.literal("resetthat").executes(var0 -> testFinder.lookedAt((CommandContext<CommandListenerWrapper>)var0).reset()))).then(net.minecraft.commands.CommandDispatcher.literal("export").then(net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.exportTestStructure((CommandListenerWrapper)var0.getSource(), "minecraft:" + StringArgumentType.getString((CommandContext)var0, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.literal("exportclosest").executes(var0 -> testFinder.nearest((CommandContext<CommandListenerWrapper>)var0).export()))).then(net.minecraft.commands.CommandDispatcher.literal("exportthese").executes(var0 -> testFinder.allNearby((CommandContext<CommandListenerWrapper>)var0).export()))).then(net.minecraft.commands.CommandDispatcher.literal("exportthat").executes(var0 -> testFinder.lookedAt((CommandContext<CommandListenerWrapper>)var0).export()))).then(net.minecraft.commands.CommandDispatcher.literal("clearthat").executes(var0 -> testFinder.lookedAt((CommandContext<CommandListenerWrapper>)var0).clear()))).then(net.minecraft.commands.CommandDispatcher.literal("clearthese").executes(var0 -> testFinder.allNearby((CommandContext<CommandListenerWrapper>)var0).clear()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("clearall").executes(var0 -> testFinder.radius((CommandContext<CommandListenerWrapper>)var0, 200).clear())).then(net.minecraft.commands.CommandDispatcher.argument("radius", IntegerArgumentType.integer()).executes(var0 -> testFinder.radius((CommandContext<CommandListenerWrapper>)var0, MathHelper.clamp(IntegerArgumentType.getInteger((CommandContext)var0, (String)"radius"), 0, 1024)).clear())))).then(net.minecraft.commands.CommandDispatcher.literal("import").then(net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.importTestStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName")))))).then(net.minecraft.commands.CommandDispatcher.literal("stop").executes(var0 -> GameTestHarnessTestCommand.stopTests()))).then(((LiteralArgumentBuilder)net.minecraft.commands.CommandDispatcher.literal("pos").executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), "pos"))).then(net.minecraft.commands.CommandDispatcher.argument("var", StringArgumentType.word()).executes(var0 -> GameTestHarnessTestCommand.showPos((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"var")))))).then(net.minecraft.commands.CommandDispatcher.literal("create").then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("testName", StringArgumentType.word()).suggests(GameTestHarnessTestFunctionArgument::suggestTestFunction).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), 5, 5, 5))).then(((RequiredArgumentBuilder)net.minecraft.commands.CommandDispatcher.argument("width", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width")))).then(net.minecraft.commands.CommandDispatcher.argument("height", IntegerArgumentType.integer()).then(net.minecraft.commands.CommandDispatcher.argument("depth", IntegerArgumentType.integer()).executes(var0 -> GameTestHarnessTestCommand.createNewStructure((CommandListenerWrapper)var0.getSource(), StringArgumentType.getString((CommandContext)var0, (String)"testName"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"width"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"height"), IntegerArgumentType.getInteger((CommandContext)var0, (String)"depth")))))))));
    }

    private static int resetGameTestInfo(GameTestHarnessInfo var02) {
        var02.getLevel().getEntities(null, var02.getStructureBounds()).stream().forEach(var0 -> var0.remove(Entity.RemovalReason.DISCARDED));
        var02.getStructureBlockEntity().placeStructure(var02.getLevel());
        GameTestHarnessStructures.removeBarriers(var02.getStructureBounds(), var02.getLevel());
        GameTestHarnessTestCommand.say(var02.getLevel(), "Reset succeded for: " + var02.getTestName(), EnumChatFormat.GREEN);
        return 1;
    }

    static Stream<GameTestHarnessInfo> toGameTestInfos(CommandListenerWrapper var0, RetryOptions var1, StructureBlockPosFinder var22) {
        return var22.findStructureBlockPos().map(var2 -> GameTestHarnessTestCommand.createGameTestInfo(var2, var0.getLevel(), var1)).flatMap(Optional::stream);
    }

    static Stream<GameTestHarnessInfo> toGameTestInfo(CommandListenerWrapper var0, RetryOptions var12, TestFunctionFinder var2, int var32) {
        return var2.findTestFunctions().filter(var1 -> GameTestHarnessTestCommand.verifyStructureExists(var0.getLevel(), var1.structureName())).map(var3 -> new GameTestHarnessInfo((GameTestHarnessTestFunction)var3, GameTestHarnessStructures.getRotationForRotationSteps(var32), var0.getLevel(), var12));
    }

    private static Optional<GameTestHarnessInfo> createGameTestInfo(BlockPosition var0, WorldServer var1, RetryOptions var2) {
        TileEntityStructure var3 = (TileEntityStructure)var1.getBlockEntity(var0);
        if (var3 == null) {
            GameTestHarnessTestCommand.say(var1, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, EnumChatFormat.RED);
            return Optional.empty();
        }
        String var4 = var3.getMetaData();
        Optional<GameTestHarnessTestFunction> var5 = GameTestHarnessRegistry.findTestFunction(var4);
        if (var5.isEmpty()) {
            GameTestHarnessTestCommand.say(var1, "Test function for test " + var4 + " could not be found", EnumChatFormat.RED);
            return Optional.empty();
        }
        GameTestHarnessTestFunction var6 = var5.get();
        GameTestHarnessInfo var7 = new GameTestHarnessInfo(var6, var3.getRotation(), var1, var2);
        var7.setStructureBlockPos(var0);
        if (!GameTestHarnessTestCommand.verifyStructureExists(var1, var7.getStructureName())) {
            return Optional.empty();
        }
        return Optional.of(var7);
    }

    private static int createNewStructure(CommandListenerWrapper var0, String var12, int var2, int var3, int var4) {
        if (var2 > 48 || var3 > 48 || var4 > 48) {
            throw new IllegalArgumentException("The structure must be less than 48 blocks big in each axis");
        }
        WorldServer var5 = var0.getLevel();
        BlockPosition var6 = GameTestHarnessTestCommand.createTestPositionAround(var0).below();
        GameTestHarnessStructures.createNewEmptyStructureBlock(var12.toLowerCase(), var6, new BaseBlockPosition(var2, var3, var4), EnumBlockRotation.NONE, var5);
        BlockPosition var7 = var6.above();
        BlockPosition var8 = var7.offset(var2 - 1, 0, var4 - 1);
        BlockPosition.betweenClosedStream(var7, var8).forEach(var1 -> var5.setBlockAndUpdate((BlockPosition)var1, Blocks.BEDROCK.defaultBlockState()));
        GameTestHarnessStructures.addCommandBlockAndButtonToStartTest(var6, new BlockPosition(1, 0, -1), EnumBlockRotation.NONE, var5);
        return 0;
    }

    private static int showPos(CommandListenerWrapper var0, String var1) throws CommandSyntaxException {
        WorldServer var4;
        MovingObjectPositionBlock var2 = (MovingObjectPositionBlock)var0.getPlayerOrException().pick(10.0, 1.0f, false);
        BlockPosition var3 = var2.getBlockPos();
        Optional<BlockPosition> var5 = GameTestHarnessStructures.findStructureBlockContainingPos(var3, 15, var4 = var0.getLevel());
        if (var5.isEmpty()) {
            var5 = GameTestHarnessStructures.findStructureBlockContainingPos(var3, 200, var4);
        }
        if (var5.isEmpty()) {
            var0.sendFailure(IChatBaseComponent.literal("Can't find a structure block that contains the targeted pos " + String.valueOf(var3)));
            return 0;
        }
        TileEntityStructure var6 = (TileEntityStructure)var4.getBlockEntity(var5.get());
        if (var6 == null) {
            GameTestHarnessTestCommand.say(var4, STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, EnumChatFormat.RED);
            return 0;
        }
        BlockPosition var7 = var3.subtract(var5.get());
        String var8 = var7.getX() + ", " + var7.getY() + ", " + var7.getZ();
        String var9 = var6.getMetaData();
        IChatMutableComponent var10 = IChatBaseComponent.literal(var8).setStyle(ChatModifier.EMPTY.withBold(true).withColor(EnumChatFormat.GREEN).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.literal("Click to copy to clipboard"))).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.COPY_TO_CLIPBOARD, "final BlockPos " + var1 + " = new BlockPos(" + var8 + ");")));
        var0.sendSuccess(() -> IChatBaseComponent.literal("Position relative to " + var9 + ": ").append(var10), false);
        PacketDebug.sendGameTestAddMarker(var4, new BlockPosition(var3), var8, -2147418368, 10000);
        return 1;
    }

    static int stopTests() {
        GameTestHarnessTicker.SINGLETON.clear();
        return 1;
    }

    static int trackAndStartRunner(CommandListenerWrapper var02, WorldServer var1, GameTestHarnessRunner var2) {
        var2.addListener(new b(var02));
        GameTestHarnessCollector var3 = new GameTestHarnessCollector(var2.getTestInfos());
        var3.addListener(new c(var1, var3));
        var3.addFailureListener(var0 -> GameTestHarnessRegistry.rememberFailedTest(var0.getTestFunction()));
        var2.start();
        return 1;
    }

    static int saveAndExportTestStructure(CommandListenerWrapper var0, TileEntityStructure var1) {
        String var2 = var1.getStructureName();
        if (!var1.saveStructure(true)) {
            GameTestHarnessTestCommand.say(var0, "Failed to save structure " + var2);
        }
        return GameTestHarnessTestCommand.exportTestStructure(var0, var2);
    }

    private static int exportTestStructure(CommandListenerWrapper var0, String var1) {
        Path var2 = Paths.get(GameTestHarnessStructures.testStructuresDir, new String[0]);
        MinecraftKey var3 = new MinecraftKey(var1);
        Path var4 = var0.getLevel().getStructureManager().getPathToGeneratedStructure(var3, ".nbt");
        Path var5 = DebugReportNBT.convertStructure(CachedOutput.NO_CACHE, var4, var3.getPath(), var2);
        if (var5 == null) {
            GameTestHarnessTestCommand.say(var0, "Failed to export " + String.valueOf(var4));
            return 1;
        }
        try {
            FileUtils.createDirectoriesSafe(var5.getParent());
        }
        catch (IOException var6) {
            GameTestHarnessTestCommand.say(var0, "Could not create folder " + String.valueOf(var5.getParent()));
            LOGGER.error("Could not create export folder", (Throwable)var6);
            return 1;
        }
        GameTestHarnessTestCommand.say(var0, "Exported " + var1 + " to " + String.valueOf(var5.toAbsolutePath()));
        return 0;
    }

    private static boolean verifyStructureExists(WorldServer var0, String var1) {
        if (var0.getStructureManager().get(new MinecraftKey(var1)).isEmpty()) {
            GameTestHarnessTestCommand.say(var0, "Test structure " + var1 + " could not be found", EnumChatFormat.RED);
            return false;
        }
        return true;
    }

    static BlockPosition createTestPositionAround(CommandListenerWrapper var0) {
        BlockPosition var1 = BlockPosition.containing(var0.getPosition());
        int var2 = var0.getLevel().getHeightmapPos(HeightMap.Type.WORLD_SURFACE, var1).getY();
        return new BlockPosition(var1.getX(), var2 + 1, var1.getZ() + 3);
    }

    static void say(CommandListenerWrapper var0, String var1) {
        var0.sendSuccess(() -> IChatBaseComponent.literal(var1), false);
    }

    private static int importTestStructure(CommandListenerWrapper var0, String var1) {
        Path var2 = Paths.get(GameTestHarnessStructures.testStructuresDir, var1 + ".snbt");
        MinecraftKey var3 = new MinecraftKey("minecraft", var1);
        Path var4 = var0.getLevel().getStructureManager().getPathToGeneratedStructure(var3, ".nbt");
        try {
            BufferedReader var5 = Files.newBufferedReader(var2);
            String var6 = IOUtils.toString((Reader)var5);
            Files.createDirectories(var4.getParent(), new FileAttribute[0]);
            try (OutputStream var7 = Files.newOutputStream(var4, new OpenOption[0]);){
                NBTCompressedStreamTools.writeCompressed(GameProfileSerializer.snbtToStructure(var6), var7);
            }
            var0.getLevel().getStructureManager().remove(var3);
            GameTestHarnessTestCommand.say(var0, "Imported to " + String.valueOf(var4.toAbsolutePath()));
            return 0;
        }
        catch (CommandSyntaxException | IOException var5) {
            LOGGER.error("Failed to load structure {}", (Object)var1, (Object)var5);
            return 1;
        }
    }

    static void say(WorldServer var02, String var1, EnumChatFormat var22) {
        var02.getPlayers(var0 -> true).forEach(var2 -> var2.sendSystemMessage(IChatBaseComponent.literal(var1).withStyle(var22)));
    }

    record b(CommandListenerWrapper source) implements GameTestBatchListener
    {
        @Override
        public void testBatchStarting(GameTestHarnessBatch var0) {
            GameTestHarnessTestCommand.say(this.source, "Starting batch: " + var0.name());
        }

        @Override
        public void testBatchFinished(GameTestHarnessBatch var0) {
        }
    }

    public record c(WorldServer level, GameTestHarnessCollector tracker) implements GameTestHarnessListener
    {
        @Override
        public void testStructureLoaded(GameTestHarnessInfo var0) {
        }

        @Override
        public void testPassed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
            c.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testFailed(GameTestHarnessInfo var0, GameTestHarnessRunner var1) {
            c.showTestSummaryIfAllDone(this.level, this.tracker);
        }

        @Override
        public void testAddedForRerun(GameTestHarnessInfo var0, GameTestHarnessInfo var1, GameTestHarnessRunner var2) {
            this.tracker.addTestToTrack(var1);
        }

        private static void showTestSummaryIfAllDone(WorldServer var0, GameTestHarnessCollector var1) {
            if (var1.isDone()) {
                GameTestHarnessTestCommand.say(var0, "GameTest done! " + var1.getTotalCount() + " tests were run", EnumChatFormat.WHITE);
                if (var1.hasFailedRequired()) {
                    GameTestHarnessTestCommand.say(var0, var1.getFailedRequiredCount() + " required tests failed :(", EnumChatFormat.RED);
                } else {
                    GameTestHarnessTestCommand.say(var0, "All required tests passed :)", EnumChatFormat.GREEN);
                }
                if (var1.hasFailedOptional()) {
                    GameTestHarnessTestCommand.say(var0, var1.getFailedOptionalCount() + " optional tests failed", EnumChatFormat.GRAY);
                }
            }
        }
    }

    public static class a {
        private final TestFinder<a> finder;

        public a(TestFinder<a> var0) {
            this.finder = var0;
        }

        public int reset() {
            GameTestHarnessTestCommand.stopTests();
            return GameTestHarnessTestCommand.toGameTestInfos(this.finder.source(), RetryOptions.noRetries(), this.finder).map(GameTestHarnessTestCommand::resetGameTestInfo).toList().isEmpty() ? 0 : 1;
        }

        private <T> void logAndRun(Stream<T> var0, ToIntFunction<T> var1, Runnable var2, Consumer<Integer> var3) {
            int var4 = var0.mapToInt(var1).sum();
            if (var4 == 0) {
                var2.run();
            } else {
                var3.accept(var4);
            }
        }

        public int clear() {
            GameTestHarnessTestCommand.stopTests();
            CommandListenerWrapper var0 = this.finder.source();
            WorldServer var12 = var0.getLevel();
            GameTestHarnessRunner.clearMarkers(var12);
            this.logAndRun(this.finder.findStructureBlockPos(), var1 -> {
                TileEntityStructure var2 = (TileEntityStructure)var12.getBlockEntity((BlockPosition)var1);
                if (var2 == null) {
                    return 0;
                }
                StructureBoundingBox var3 = GameTestHarnessStructures.getStructureBoundingBox(var2);
                GameTestHarnessStructures.clearSpaceForStructure(var3, var12);
                return 1;
            }, () -> GameTestHarnessTestCommand.say(var12, "Could not find any structures to clear", EnumChatFormat.RED), var1 -> GameTestHarnessTestCommand.say(var0, "Cleared " + var1 + " structures"));
            return 1;
        }

        public int export() {
            MutableBoolean var0 = new MutableBoolean(true);
            CommandListenerWrapper var12 = this.finder.source();
            WorldServer var2 = var12.getLevel();
            this.logAndRun(this.finder.findStructureBlockPos(), var3 -> {
                TileEntityStructure var4 = (TileEntityStructure)var2.getBlockEntity((BlockPosition)var3);
                if (var4 == null) {
                    GameTestHarnessTestCommand.say(var2, GameTestHarnessTestCommand.STRUCTURE_BLOCK_ENTITY_COULD_NOT_BE_FOUND, EnumChatFormat.RED);
                    var0.setFalse();
                    return 0;
                }
                if (GameTestHarnessTestCommand.saveAndExportTestStructure(var12, var4) != 0) {
                    var0.setFalse();
                }
                return 1;
            }, () -> GameTestHarnessTestCommand.say(var2, "Could not find any structures to export", EnumChatFormat.RED), var1 -> GameTestHarnessTestCommand.say(var12, "Exported " + var1 + " structures"));
            return var0.getValue() != false ? 0 : 1;
        }

        public int run(RetryOptions var0, int var1, int var2) {
            GameTestHarnessTestCommand.stopTests();
            CommandListenerWrapper var3 = this.finder.source();
            WorldServer var4 = var3.getLevel();
            BlockPosition var5 = GameTestHarnessTestCommand.createTestPositionAround(var3);
            List<GameTestHarnessInfo> var6 = Stream.concat(GameTestHarnessTestCommand.toGameTestInfos(var3, var0, this.finder), GameTestHarnessTestCommand.toGameTestInfo(var3, var0, this.finder, var1)).toList();
            if (var6.isEmpty()) {
                GameTestHarnessTestCommand.say(var3, "No tests found");
                return 0;
            }
            GameTestHarnessRunner.clearMarkers(var4);
            GameTestHarnessRegistry.forgetFailedTests();
            GameTestHarnessTestCommand.say(var3, "Running " + var6.size() + " tests...");
            GameTestHarnessRunner var7 = GameTestHarnessRunner.a.fromInfo(var6, var4).newStructureSpawner(new StructureGridSpawner(var5, var2)).build();
            return GameTestHarnessTestCommand.trackAndStartRunner(var3, var4, var7);
        }

        public int run(int var0, int var1) {
            return this.run(RetryOptions.noRetries(), var0, var1);
        }

        public int run(int var0) {
            return this.run(RetryOptions.noRetries(), var0, 8);
        }

        public int run(RetryOptions var0, int var1) {
            return this.run(var0, var1, 8);
        }

        public int run(RetryOptions var0) {
            return this.run(var0, 0, 8);
        }

        public int run() {
            return this.run(RetryOptions.noRetries());
        }

        public int locate() {
            GameTestHarnessTestCommand.say(this.finder.source(), "Started locating test structures, this might take a while..");
            MutableInt var0 = new MutableInt(0);
            BlockPosition var1 = BlockPosition.containing(this.finder.source().getPosition());
            this.finder.findStructureBlockPos().forEach(var2 -> {
                TileEntityStructure var3 = (TileEntityStructure)this.finder.source().getLevel().getBlockEntity((BlockPosition)var2);
                if (var3 == null) {
                    return;
                }
                EnumDirection var4 = var3.getRotation().rotate(EnumDirection.NORTH);
                BlockPosition var5 = var3.getBlockPos().relative(var4, 2);
                int var6 = (int)var4.getOpposite().toYRot();
                String var7 = String.format("/tp @s %d %d %d %d 0", var5.getX(), var5.getY(), var5.getZ(), var6);
                int var8 = var1.getX() - var2.getX();
                int var9 = var1.getZ() - var2.getZ();
                int var10 = MathHelper.floor(MathHelper.sqrt(var8 * var8 + var9 * var9));
                IChatMutableComponent var11 = ChatComponentUtils.wrapInSquareBrackets(IChatBaseComponent.translatable("chat.coordinates", var2.getX(), var2.getY(), var2.getZ())).withStyle(var1 -> var1.withColor(EnumChatFormat.GREEN).withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, var7)).withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, IChatBaseComponent.translatable("chat.coordinates.tooltip"))));
                IChatMutableComponent var122 = IChatBaseComponent.literal("Found structure at: ").append(var11).append(" (distance: " + var10 + ")");
                this.finder.source().sendSuccess(() -> var122, false);
                var0.increment();
            });
            int var22 = var0.intValue();
            if (var22 == 0) {
                GameTestHarnessTestCommand.say(this.finder.source().getLevel(), "No such test structure found", EnumChatFormat.RED);
                return 0;
            }
            GameTestHarnessTestCommand.say(this.finder.source().getLevel(), "Finished locating, found " + var22 + " structure(s)", EnumChatFormat.GREEN);
            return 1;
        }
    }
}

