/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.IBlockData;

public class ParticleParamBlock
implements ParticleParam {
    private static final Codec<IBlockData> BLOCK_STATE_CODEC = Codec.withAlternative(IBlockData.CODEC, BuiltInRegistries.BLOCK.byNameCodec(), Block::defaultBlockState);
    private final Particle<ParticleParamBlock> type;
    private final IBlockData state;

    public static MapCodec<ParticleParamBlock> codec(Particle<ParticleParamBlock> var02) {
        return BLOCK_STATE_CODEC.xmap(var1 -> new ParticleParamBlock(var02, (IBlockData)var1), var0 -> var0.state).fieldOf("block_state");
    }

    public static StreamCodec<? super RegistryFriendlyByteBuf, ParticleParamBlock> streamCodec(Particle<ParticleParamBlock> var02) {
        return ByteBufCodecs.idMapper(Block.BLOCK_STATE_REGISTRY).map(var1 -> new ParticleParamBlock(var02, (IBlockData)var1), var0 -> var0.state);
    }

    public ParticleParamBlock(Particle<ParticleParamBlock> var0, IBlockData var1) {
        this.type = var0;
        this.state = var1;
    }

    public Particle<ParticleParamBlock> getType() {
        return this.type;
    }

    public IBlockData getState() {
        return this.state;
    }
}

