/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.particles;

import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.ColorUtil;
import net.minecraft.util.ExtraCodecs;

public class ColorParticleOption
implements ParticleParam {
    private final Particle<ColorParticleOption> type;
    private final int color;

    public static MapCodec<ColorParticleOption> codec(Particle<ColorParticleOption> var02) {
        return ExtraCodecs.ARGB_COLOR_CODEC.xmap(var1 -> new ColorParticleOption(var02, (int)var1), var0 -> var0.color).fieldOf("color");
    }

    public static StreamCodec<? super ByteBuf, ColorParticleOption> streamCodec(Particle<ColorParticleOption> var02) {
        return ByteBufCodecs.INT.map(var1 -> new ColorParticleOption(var02, (int)var1), var0 -> var0.color);
    }

    private ColorParticleOption(Particle<ColorParticleOption> var0, int var1) {
        this.type = var0;
        this.color = var1;
    }

    public Particle<ColorParticleOption> getType() {
        return this.type;
    }

    public float getRed() {
        return (float)ColorUtil.b.red(this.color) / 255.0f;
    }

    public float getGreen() {
        return (float)ColorUtil.b.green(this.color) / 255.0f;
    }

    public float getBlue() {
        return (float)ColorUtil.b.blue(this.color) / 255.0f;
    }

    public float getAlpha() {
        return (float)ColorUtil.b.alpha(this.color) / 255.0f;
    }

    public static ColorParticleOption create(Particle<ColorParticleOption> var0, int var1) {
        return new ColorParticleOption(var0, var1);
    }

    public static ColorParticleOption create(Particle<ColorParticleOption> var0, float var1, float var2, float var3) {
        return ColorParticleOption.create(var0, ColorUtil.b.colorFromFloat(1.0f, var1, var2, var3));
    }
}

