/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import java.util.Map;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.PatchedDataComponentMap;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;

public record TypedDataComponent<T>(DataComponentType<T> type, T value) {
    public static final StreamCodec<RegistryFriendlyByteBuf, TypedDataComponent<?>> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, TypedDataComponent<?>>(){

        @Override
        public TypedDataComponent<?> decode(RegistryFriendlyByteBuf var0) {
            DataComponentType var1 = (DataComponentType)DataComponentType.STREAM_CODEC.decode(var0);
            return 1.decodeTyped(var0, var1);
        }

        private static <T> TypedDataComponent<T> decodeTyped(RegistryFriendlyByteBuf var0, DataComponentType<T> var1) {
            return new TypedDataComponent<T>(var1, var1.streamCodec().decode(var0));
        }

        @Override
        public void encode(RegistryFriendlyByteBuf var0, TypedDataComponent<?> var1) {
            1.encodeCap(var0, var1);
        }

        private static <T> void encodeCap(RegistryFriendlyByteBuf var0, TypedDataComponent<T> var1) {
            DataComponentType.STREAM_CODEC.encode(var0, var1.type());
            var1.type().streamCodec().encode(var0, var1.value());
        }

        @Override
        public /* synthetic */ void encode(Object object, Object object2) {
            this.encode((RegistryFriendlyByteBuf)((Object)object), (TypedDataComponent)object2);
        }

        @Override
        public /* synthetic */ Object decode(Object object) {
            return this.decode((RegistryFriendlyByteBuf)((Object)object));
        }
    };

    static TypedDataComponent<?> fromEntryUnchecked(Map.Entry<DataComponentType<?>, Object> var0) {
        return TypedDataComponent.createUnchecked(var0.getKey(), var0.getValue());
    }

    static <T> TypedDataComponent<T> createUnchecked(DataComponentType<T> var0, Object var1) {
        return new TypedDataComponent<Object>(var0, var1);
    }

    public void applyTo(PatchedDataComponentMap var0) {
        var0.set(this.type, this.value);
    }

    public <D> DataResult<D> encodeValue(DynamicOps<D> var0) {
        Codec<T> var1 = this.type.codec();
        if (var1 == null) {
            return DataResult.error(() -> "Component of type " + String.valueOf(this.type) + " is not encodable");
        }
        return var1.encodeStart(var0, this.value);
    }

    @Override
    public String toString() {
        return String.valueOf(this.type) + "=>" + String.valueOf(this.value);
    }
}

