/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.function.UnaryOperator;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.EncoderCache;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Unit;
import net.minecraft.world.ChestLock;
import net.minecraft.world.food.FoodInfo;
import net.minecraft.world.item.AdventureModePredicate;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.EnumItemRarity;
import net.minecraft.world.item.Instrument;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraft.world.item.component.BlockItemStateProperties;
import net.minecraft.world.item.component.BundleContents;
import net.minecraft.world.item.component.ChargedProjectiles;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.component.CustomModelData;
import net.minecraft.world.item.component.DebugStickState;
import net.minecraft.world.item.component.DyedItemColor;
import net.minecraft.world.item.component.FireworkExplosion;
import net.minecraft.world.item.component.Fireworks;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.item.component.ItemContainerContents;
import net.minecraft.world.item.component.ItemLore;
import net.minecraft.world.item.component.LodestoneTracker;
import net.minecraft.world.item.component.MapDecorations;
import net.minecraft.world.item.component.MapItemColor;
import net.minecraft.world.item.component.MapPostProcessing;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.component.SeededContainerLoot;
import net.minecraft.world.item.component.SuspiciousStewEffects;
import net.minecraft.world.item.component.Tool;
import net.minecraft.world.item.component.Unbreakable;
import net.minecraft.world.item.component.WritableBookContent;
import net.minecraft.world.item.component.WrittenBookContent;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.minecraft.world.level.block.entity.BannerPatternLayers;
import net.minecraft.world.level.block.entity.PotDecorations;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.saveddata.maps.MapId;

public class DataComponents {
    static final EncoderCache ENCODER_CACHE = new EncoderCache(512);
    public static final DataComponentType<CustomData> CUSTOM_DATA = DataComponents.register("custom_data", var0 -> var0.persistent(CustomData.CODEC));
    public static final DataComponentType<Integer> MAX_STACK_SIZE = DataComponents.register("max_stack_size", var0 -> var0.persistent(ExtraCodecs.intRange(1, 99)).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> MAX_DAMAGE = DataComponents.register("max_damage", var0 -> var0.persistent(ExtraCodecs.POSITIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Integer> DAMAGE = DataComponents.register("damage", var0 -> var0.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unbreakable> UNBREAKABLE = DataComponents.register("unbreakable", var0 -> var0.persistent(Unbreakable.CODEC).networkSynchronized(Unbreakable.STREAM_CODEC));
    public static final DataComponentType<IChatBaseComponent> CUSTOM_NAME = DataComponents.register("custom_name", var0 -> var0.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<IChatBaseComponent> ITEM_NAME = DataComponents.register("item_name", var0 -> var0.persistent(ComponentSerialization.FLAT_CODEC).networkSynchronized(ComponentSerialization.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemLore> LORE = DataComponents.register("lore", var0 -> var0.persistent(ItemLore.CODEC).networkSynchronized(ItemLore.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<EnumItemRarity> RARITY = DataComponents.register("rarity", var0 -> var0.persistent(EnumItemRarity.CODEC).networkSynchronized(EnumItemRarity.STREAM_CODEC));
    public static final DataComponentType<ItemEnchantments> ENCHANTMENTS = DataComponents.register("enchantments", var0 -> var0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_PLACE_ON = DataComponents.register("can_place_on", var0 -> var0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<AdventureModePredicate> CAN_BREAK = DataComponents.register("can_break", var0 -> var0.persistent(AdventureModePredicate.CODEC).networkSynchronized(AdventureModePredicate.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemAttributeModifiers> ATTRIBUTE_MODIFIERS = DataComponents.register("attribute_modifiers", var0 -> var0.persistent(ItemAttributeModifiers.CODEC).networkSynchronized(ItemAttributeModifiers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<CustomModelData> CUSTOM_MODEL_DATA = DataComponents.register("custom_model_data", var0 -> var0.persistent(CustomModelData.CODEC).networkSynchronized(CustomModelData.STREAM_CODEC));
    public static final DataComponentType<Unit> HIDE_ADDITIONAL_TOOLTIP = DataComponents.register("hide_additional_tooltip", var0 -> var0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Unit> HIDE_TOOLTIP = DataComponents.register("hide_tooltip", var0 -> var0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Integer> REPAIR_COST = DataComponents.register("repair_cost", var0 -> var0.persistent(ExtraCodecs.NON_NEGATIVE_INT).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<Unit> CREATIVE_SLOT_LOCK = DataComponents.register("creative_slot_lock", var0 -> var0.networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Boolean> ENCHANTMENT_GLINT_OVERRIDE = DataComponents.register("enchantment_glint_override", var0 -> var0.persistent(Codec.BOOL).networkSynchronized(ByteBufCodecs.BOOL));
    public static final DataComponentType<Unit> INTANGIBLE_PROJECTILE = DataComponents.register("intangible_projectile", var0 -> var0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))));
    public static final DataComponentType<FoodInfo> FOOD = DataComponents.register("food", var0 -> var0.persistent(FoodInfo.DIRECT_CODEC).networkSynchronized(FoodInfo.DIRECT_STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Unit> FIRE_RESISTANT = DataComponents.register("fire_resistant", var0 -> var0.persistent(Codec.unit((Object)((Object)Unit.INSTANCE))).networkSynchronized(StreamCodec.unit(Unit.INSTANCE)));
    public static final DataComponentType<Tool> TOOL = DataComponents.register("tool", var0 -> var0.persistent(Tool.CODEC).networkSynchronized(Tool.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemEnchantments> STORED_ENCHANTMENTS = DataComponents.register("stored_enchantments", var0 -> var0.persistent(ItemEnchantments.CODEC).networkSynchronized(ItemEnchantments.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DyedItemColor> DYED_COLOR = DataComponents.register("dyed_color", var0 -> var0.persistent(DyedItemColor.CODEC).networkSynchronized(DyedItemColor.STREAM_CODEC));
    public static final DataComponentType<MapItemColor> MAP_COLOR = DataComponents.register("map_color", var0 -> var0.persistent(MapItemColor.CODEC).networkSynchronized(MapItemColor.STREAM_CODEC));
    public static final DataComponentType<MapId> MAP_ID = DataComponents.register("map_id", var0 -> var0.persistent(MapId.CODEC).networkSynchronized(MapId.STREAM_CODEC));
    public static final DataComponentType<MapDecorations> MAP_DECORATIONS = DataComponents.register("map_decorations", var0 -> var0.persistent(MapDecorations.CODEC).cacheEncoding());
    public static final DataComponentType<MapPostProcessing> MAP_POST_PROCESSING = DataComponents.register("map_post_processing", var0 -> var0.networkSynchronized(MapPostProcessing.STREAM_CODEC));
    public static final DataComponentType<ChargedProjectiles> CHARGED_PROJECTILES = DataComponents.register("charged_projectiles", var0 -> var0.persistent(ChargedProjectiles.CODEC).networkSynchronized(ChargedProjectiles.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BundleContents> BUNDLE_CONTENTS = DataComponents.register("bundle_contents", var0 -> var0.persistent(BundleContents.CODEC).networkSynchronized(BundleContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<PotionContents> POTION_CONTENTS = DataComponents.register("potion_contents", var0 -> var0.persistent(PotionContents.CODEC).networkSynchronized(PotionContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<SuspiciousStewEffects> SUSPICIOUS_STEW_EFFECTS = DataComponents.register("suspicious_stew_effects", var0 -> var0.persistent(SuspiciousStewEffects.CODEC).networkSynchronized(SuspiciousStewEffects.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WritableBookContent> WRITABLE_BOOK_CONTENT = DataComponents.register("writable_book_content", var0 -> var0.persistent(WritableBookContent.CODEC).networkSynchronized(WritableBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<WrittenBookContent> WRITTEN_BOOK_CONTENT = DataComponents.register("written_book_content", var0 -> var0.persistent(WrittenBookContent.CODEC).networkSynchronized(WrittenBookContent.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ArmorTrim> TRIM = DataComponents.register("trim", var0 -> var0.persistent(ArmorTrim.CODEC).networkSynchronized(ArmorTrim.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<DebugStickState> DEBUG_STICK_STATE = DataComponents.register("debug_stick_state", var0 -> var0.persistent(DebugStickState.CODEC).cacheEncoding());
    public static final DataComponentType<CustomData> ENTITY_DATA = DataComponents.register("entity_data", var0 -> var0.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<CustomData> BUCKET_ENTITY_DATA = DataComponents.register("bucket_entity_data", var0 -> var0.persistent(CustomData.CODEC).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<CustomData> BLOCK_ENTITY_DATA = DataComponents.register("block_entity_data", var0 -> var0.persistent(CustomData.CODEC_WITH_ID).networkSynchronized(CustomData.STREAM_CODEC));
    public static final DataComponentType<Holder<Instrument>> INSTRUMENT = DataComponents.register("instrument", var0 -> var0.persistent(Instrument.CODEC).networkSynchronized(Instrument.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Integer> OMINOUS_BOTTLE_AMPLIFIER = DataComponents.register("ominous_bottle_amplifier", var0 -> var0.persistent(ExtraCodecs.intRange(0, 4)).networkSynchronized(ByteBufCodecs.VAR_INT));
    public static final DataComponentType<List<MinecraftKey>> RECIPES = DataComponents.register("recipes", var0 -> var0.persistent(MinecraftKey.CODEC.listOf()).cacheEncoding());
    public static final DataComponentType<LodestoneTracker> LODESTONE_TRACKER = DataComponents.register("lodestone_tracker", var0 -> var0.persistent(LodestoneTracker.CODEC).networkSynchronized(LodestoneTracker.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<FireworkExplosion> FIREWORK_EXPLOSION = DataComponents.register("firework_explosion", var0 -> var0.persistent(FireworkExplosion.CODEC).networkSynchronized(FireworkExplosion.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<Fireworks> FIREWORKS = DataComponents.register("fireworks", var0 -> var0.persistent(Fireworks.CODEC).networkSynchronized(Fireworks.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ResolvableProfile> PROFILE = DataComponents.register("profile", var0 -> var0.persistent(ResolvableProfile.CODEC).networkSynchronized(ResolvableProfile.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<MinecraftKey> NOTE_BLOCK_SOUND = DataComponents.register("note_block_sound", var0 -> var0.persistent(MinecraftKey.CODEC).networkSynchronized(MinecraftKey.STREAM_CODEC));
    public static final DataComponentType<BannerPatternLayers> BANNER_PATTERNS = DataComponents.register("banner_patterns", var0 -> var0.persistent(BannerPatternLayers.CODEC).networkSynchronized(BannerPatternLayers.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<EnumColor> BASE_COLOR = DataComponents.register("base_color", var0 -> var0.persistent(EnumColor.CODEC).networkSynchronized(EnumColor.STREAM_CODEC));
    public static final DataComponentType<PotDecorations> POT_DECORATIONS = DataComponents.register("pot_decorations", var0 -> var0.persistent(PotDecorations.CODEC).networkSynchronized(PotDecorations.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<ItemContainerContents> CONTAINER = DataComponents.register("container", var0 -> var0.persistent(ItemContainerContents.CODEC).networkSynchronized(ItemContainerContents.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<BlockItemStateProperties> BLOCK_STATE = DataComponents.register("block_state", var0 -> var0.persistent(BlockItemStateProperties.CODEC).networkSynchronized(BlockItemStateProperties.STREAM_CODEC).cacheEncoding());
    public static final DataComponentType<List<TileEntityBeehive.c>> BEES = DataComponents.register("bees", var0 -> var0.persistent(TileEntityBeehive.c.LIST_CODEC).networkSynchronized(TileEntityBeehive.c.STREAM_CODEC.apply(ByteBufCodecs.list())).cacheEncoding());
    public static final DataComponentType<ChestLock> LOCK = DataComponents.register("lock", var0 -> var0.persistent(ChestLock.CODEC));
    public static final DataComponentType<SeededContainerLoot> CONTAINER_LOOT = DataComponents.register("container_loot", var0 -> var0.persistent(SeededContainerLoot.CODEC));
    public static final DataComponentMap COMMON_ITEM_COMPONENTS = DataComponentMap.builder().set(MAX_STACK_SIZE, 64).set(LORE, ItemLore.EMPTY).set(ENCHANTMENTS, ItemEnchantments.EMPTY).set(REPAIR_COST, 0).set(ATTRIBUTE_MODIFIERS, ItemAttributeModifiers.EMPTY).set(RARITY, EnumItemRarity.COMMON).build();

    public static DataComponentType<?> bootstrap(IRegistry<DataComponentType<?>> var0) {
        return CUSTOM_DATA;
    }

    private static <T> DataComponentType<T> register(String var0, UnaryOperator<DataComponentType.a<T>> var1) {
        return IRegistry.register(BuiltInRegistries.DATA_COMPONENT_TYPE, var0, ((DataComponentType.a)var1.apply(DataComponentType.builder())).build());
    }
}

