/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Pair;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Lifecycle;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.SystemUtils;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryWritable;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import org.slf4j.Logger;

public class RegistryMaterials<T>
implements IRegistryWritable<T> {
    private static final Logger LOGGER = LogUtils.getLogger();
    final ResourceKey<? extends IRegistry<T>> key;
    private final ObjectList<Holder.c<T>> byId = new ObjectArrayList(256);
    private final Reference2IntMap<T> toId = (Reference2IntMap)SystemUtils.make(new Reference2IntOpenHashMap(), var0 -> var0.defaultReturnValue(-1));
    private final Map<MinecraftKey, Holder.c<T>> byLocation = new HashMap<MinecraftKey, Holder.c<T>>();
    private final Map<ResourceKey<T>, Holder.c<T>> byKey = new HashMap<ResourceKey<T>, Holder.c<T>>();
    private final Map<T, Holder.c<T>> byValue = new IdentityHashMap<T, Holder.c<T>>();
    private final Map<ResourceKey<T>, RegistrationInfo> registrationInfos = new IdentityHashMap<ResourceKey<T>, RegistrationInfo>();
    private Lifecycle registryLifecycle;
    private volatile Map<TagKey<T>, HolderSet.Named<T>> tags = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>();
    private boolean frozen;
    @Nullable
    private Map<T, Holder.c<T>> unregisteredIntrusiveHolders;
    private final HolderLookup.b<T> lookup = new HolderLookup.b<T>(){

        @Override
        public ResourceKey<? extends IRegistry<? extends T>> key() {
            return RegistryMaterials.this.key;
        }

        @Override
        public Lifecycle registryLifecycle() {
            return RegistryMaterials.this.registryLifecycle();
        }

        @Override
        public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
            return RegistryMaterials.this.getHolder(var0);
        }

        @Override
        public Stream<Holder.c<T>> listElements() {
            return RegistryMaterials.this.holders();
        }

        @Override
        public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
            return RegistryMaterials.this.getTag(var0);
        }

        @Override
        public Stream<HolderSet.Named<T>> listTags() {
            return RegistryMaterials.this.getTags().map(Pair::getSecond);
        }
    };
    private final Object tagAdditionLock = new Object();

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var0, Lifecycle var1) {
        this(var0, var1, false);
    }

    public RegistryMaterials(ResourceKey<? extends IRegistry<T>> var02, Lifecycle var1, boolean var2) {
        this.key = var02;
        this.registryLifecycle = var1;
        if (var2) {
            this.unregisteredIntrusiveHolders = new IdentityHashMap<T, Holder.c<T>>();
        }
    }

    @Override
    public ResourceKey<? extends IRegistry<T>> key() {
        return this.key;
    }

    public String toString() {
        return "Registry[" + String.valueOf(this.key) + " (" + String.valueOf(this.registryLifecycle) + ")]";
    }

    private void validateWrite() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen");
        }
    }

    private void validateWrite(ResourceKey<T> var0) {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen (trying to add key " + String.valueOf(var0) + ")");
        }
    }

    @Override
    public Holder.c<T> register(ResourceKey<T> var02, T var1, RegistrationInfo var2) {
        Holder.c var3;
        this.validateWrite(var02);
        Objects.requireNonNull(var02);
        Objects.requireNonNull(var1);
        if (this.byLocation.containsKey(var02.location())) {
            SystemUtils.pauseInIde(new IllegalStateException("Adding duplicate key '" + String.valueOf(var02) + "' to registry"));
        }
        if (this.byValue.containsKey(var1)) {
            SystemUtils.pauseInIde(new IllegalStateException("Adding duplicate value '" + String.valueOf(var1) + "' to registry"));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            var3 = this.unregisteredIntrusiveHolders.remove(var1);
            if (var3 == null) {
                throw new AssertionError((Object)("Missing intrusive holder for " + String.valueOf(var02) + ":" + String.valueOf(var1)));
            }
            var3.bindKey(var02);
        } else {
            var3 = this.byKey.computeIfAbsent(var02, var0 -> Holder.c.createStandAlone(this.holderOwner(), var0));
        }
        this.byKey.put(var02, var3);
        this.byLocation.put(var02.location(), var3);
        this.byValue.put(var1, var3);
        int var4 = this.byId.size();
        this.byId.add((Object)var3);
        this.toId.put(var1, var4);
        this.registrationInfos.put(var02, var2);
        this.registryLifecycle = this.registryLifecycle.add(var2.lifecycle());
        return var3;
    }

    @Override
    @Nullable
    public MinecraftKey getKey(T var0) {
        Holder.c<T> var1 = this.byValue.get(var0);
        return var1 != null ? var1.key().location() : null;
    }

    @Override
    public Optional<ResourceKey<T>> getResourceKey(T var0) {
        return Optional.ofNullable(this.byValue.get(var0)).map(Holder.c::key);
    }

    @Override
    public int getId(@Nullable T var0) {
        return this.toId.getInt(var0);
    }

    @Override
    @Nullable
    public T get(@Nullable ResourceKey<T> var0) {
        return RegistryMaterials.getValueFromNullable(this.byKey.get(var0));
    }

    @Override
    @Nullable
    public T byId(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return null;
        }
        return ((Holder.c)this.byId.get(var0)).value();
    }

    @Override
    public Optional<Holder.c<T>> getHolder(int var0) {
        if (var0 < 0 || var0 >= this.byId.size()) {
            return Optional.empty();
        }
        return Optional.ofNullable((Holder.c)this.byId.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> getHolder(MinecraftKey var0) {
        return Optional.ofNullable(this.byLocation.get(var0));
    }

    @Override
    public Optional<Holder.c<T>> getHolder(ResourceKey<T> var0) {
        return Optional.ofNullable(this.byKey.get(var0));
    }

    @Override
    public Holder<T> wrapAsHolder(T var0) {
        Holder.c<T> var1 = this.byValue.get(var0);
        return var1 != null ? var1 : Holder.direct(var0);
    }

    Holder.c<T> getOrCreateHolderOrThrow(ResourceKey<T> var02) {
        return this.byKey.computeIfAbsent(var02, var0 -> {
            if (this.unregisteredIntrusiveHolders != null) {
                throw new IllegalStateException("This registry can't create new holders without value");
            }
            this.validateWrite((ResourceKey<T>)var0);
            return Holder.c.createStandAlone(this.holderOwner(), var0);
        });
    }

    @Override
    public int size() {
        return this.byKey.size();
    }

    @Override
    public Optional<RegistrationInfo> registrationInfo(ResourceKey<T> var0) {
        return Optional.ofNullable(this.registrationInfos.get(var0));
    }

    @Override
    public Lifecycle registryLifecycle() {
        return this.registryLifecycle;
    }

    @Override
    public Iterator<T> iterator() {
        return Iterators.transform((Iterator)this.byId.iterator(), Holder::value);
    }

    @Override
    @Nullable
    public T get(@Nullable MinecraftKey var0) {
        Holder.c<T> var1 = this.byLocation.get(var0);
        return RegistryMaterials.getValueFromNullable(var1);
    }

    @Nullable
    private static <T> T getValueFromNullable(@Nullable Holder.c<T> var0) {
        return var0 != null ? (T)var0.value() : null;
    }

    @Override
    public Set<MinecraftKey> keySet() {
        return Collections.unmodifiableSet(this.byLocation.keySet());
    }

    @Override
    public Set<ResourceKey<T>> registryKeySet() {
        return Collections.unmodifiableSet(this.byKey.keySet());
    }

    @Override
    public Set<Map.Entry<ResourceKey<T>, T>> entrySet() {
        return Collections.unmodifiableSet(Maps.transformValues(this.byKey, Holder::value).entrySet());
    }

    @Override
    public Stream<Holder.c<T>> holders() {
        return this.byId.stream();
    }

    @Override
    public Stream<Pair<TagKey<T>, HolderSet.Named<T>>> getTags() {
        return this.tags.entrySet().stream().map(var0 -> Pair.of((Object)((TagKey)var0.getKey()), (Object)((HolderSet.Named)var0.getValue())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HolderSet.Named<T> getOrCreateTag(TagKey<T> var0) {
        HolderSet.Named<T> var1 = this.tags.get(var0);
        if (var1 != null) {
            return var1;
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            var1 = this.tags.get(var0);
            if (var1 != null) {
                return var1;
            }
            var1 = this.createTag(var0);
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var3 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            var3.put(var0, var1);
            this.tags = var3;
        }
        return var1;
    }

    private HolderSet.Named<T> createTag(TagKey<T> var0) {
        return new HolderSet.Named<T>(this.holderOwner(), var0);
    }

    @Override
    public Stream<TagKey<T>> getTagNames() {
        return this.tags.keySet().stream();
    }

    @Override
    public boolean isEmpty() {
        return this.byKey.isEmpty();
    }

    @Override
    public Optional<Holder.c<T>> getRandom(RandomSource var0) {
        return SystemUtils.getRandomSafe(this.byId, var0);
    }

    @Override
    public boolean containsKey(MinecraftKey var0) {
        return this.byLocation.containsKey(var0);
    }

    @Override
    public boolean containsKey(ResourceKey<T> var0) {
        return this.byKey.containsKey(var0);
    }

    @Override
    public IRegistry<T> freeze() {
        if (this.frozen) {
            return this;
        }
        this.frozen = true;
        this.byValue.forEach((? super K var0, ? super V var1) -> var1.bindValue(var0));
        List<MinecraftKey> var02 = this.byKey.entrySet().stream().filter(var0 -> !((Holder.c)var0.getValue()).isBound()).map(var0 -> ((ResourceKey)var0.getKey()).location()).sorted().toList();
        if (!var02.isEmpty()) {
            throw new IllegalStateException("Unbound values in registry " + String.valueOf(this.key()) + ": " + String.valueOf(var02));
        }
        if (this.unregisteredIntrusiveHolders != null) {
            if (!this.unregisteredIntrusiveHolders.isEmpty()) {
                throw new IllegalStateException("Some intrusive holders were not registered: " + String.valueOf(this.unregisteredIntrusiveHolders.values()));
            }
            this.unregisteredIntrusiveHolders = null;
        }
        return this;
    }

    @Override
    public Holder.c<T> createIntrusiveHolder(T var02) {
        if (this.unregisteredIntrusiveHolders == null) {
            throw new IllegalStateException("This registry can't create intrusive holders");
        }
        this.validateWrite();
        return this.unregisteredIntrusiveHolders.computeIfAbsent(var02, var0 -> Holder.c.createIntrusive(this.asLookup(), var0));
    }

    @Override
    public Optional<HolderSet.Named<T>> getTag(TagKey<T> var0) {
        return Optional.ofNullable(this.tags.get(var0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindTags(Map<TagKey<T>, List<Holder<T>>> var02) {
        IdentityHashMap<Holder.c, List> var12 = new IdentityHashMap<Holder.c, List>();
        this.byKey.values().forEach(var1 -> var12.put((Holder.c)var1, new ArrayList()));
        var02.forEach((? super K var1, ? super V var2) -> {
            for (Holder var4 : var2) {
                if (!var4.canSerializeIn(this.asLookup())) {
                    throw new IllegalStateException("Can't create named set " + String.valueOf(var1) + " containing value " + String.valueOf(var4) + " from outside registry " + String.valueOf(this));
                }
                if (var4 instanceof Holder.c) {
                    Holder.c var5 = (Holder.c)var4;
                    ((List)var12.get(var5)).add(var1);
                    continue;
                }
                throw new IllegalStateException("Found direct holder " + String.valueOf(var4) + " value in tag " + String.valueOf(var1));
            }
        });
        Sets.SetView var22 = Sets.difference(this.tags.keySet(), var02.keySet());
        if (!var22.isEmpty()) {
            LOGGER.warn("Not all defined tags for registry {} are present in data pack: {}", this.key(), (Object)var22.stream().map(var0 -> var0.location().toString()).sorted().collect(Collectors.joining(", ")));
        }
        Object object = this.tagAdditionLock;
        synchronized (object) {
            IdentityHashMap<TagKey<T>, HolderSet.Named<T>> var4 = new IdentityHashMap<TagKey<T>, HolderSet.Named<T>>(this.tags);
            var02.forEach((? super K var1, ? super V var2) -> var4.computeIfAbsent((TagKey<T>)var1, this::createTag).bind(var2));
            var12.forEach(Holder.c::bindTags);
            this.tags = var4;
        }
    }

    @Override
    public void resetTags() {
        this.tags.values().forEach(var0 -> var0.bind(List.of()));
        this.byKey.values().forEach(var0 -> var0.bindTags(Set.of()));
    }

    @Override
    public HolderGetter<T> createRegistrationLookup() {
        this.validateWrite();
        return new HolderGetter<T>(){

            @Override
            public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
                return Optional.of(this.getOrThrow(var0));
            }

            @Override
            public Holder.c<T> getOrThrow(ResourceKey<T> var0) {
                return RegistryMaterials.this.getOrCreateHolderOrThrow(var0);
            }

            @Override
            public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return Optional.of(this.getOrThrow(var0));
            }

            @Override
            public HolderSet.Named<T> getOrThrow(TagKey<T> var0) {
                return RegistryMaterials.this.getOrCreateTag(var0);
            }
        };
    }

    @Override
    public HolderOwner<T> holderOwner() {
        return this.lookup;
    }

    @Override
    public HolderLookup.b<T> asLookup() {
        return this.lookup;
    }
}

