/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.annotations.VisibleForTesting;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.serialization.Codec;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;

public class ResourceOrIdArgument<T>
implements ArgumentType<Holder<T>> {
    private static final Collection<String> EXAMPLES = List.of("foo", "foo:bar", "012", "{}", "true");
    public static final DynamicCommandExceptionType ERROR_FAILED_TO_PARSE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.resource_or_id.failed_to_parse", var0));
    private static final SimpleCommandExceptionType ERROR_INVALID = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.resource_or_id.invalid"));
    private final HolderLookup.a registryLookup;
    private final boolean hasRegistry;
    private final Codec<Holder<T>> codec;

    protected ResourceOrIdArgument(CommandBuildContext var0, ResourceKey<IRegistry<T>> var1, Codec<Holder<T>> var2) {
        this.registryLookup = var0;
        this.hasRegistry = var0.lookup(var1).isPresent();
        this.codec = var2;
    }

    public static c lootTable(CommandBuildContext var0) {
        return new c(var0);
    }

    public static Holder<LootTable> getLootTable(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static a lootModifier(CommandBuildContext var0) {
        return new a(var0);
    }

    public static Holder<LootItemFunction> getLootModifier(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    public static b lootPredicate(CommandBuildContext var0) {
        return new b(var0);
    }

    public static Holder<LootItemCondition> getLootPredicate(CommandContext<CommandListenerWrapper> var0, String var1) {
        return ResourceOrIdArgument.getResource(var0, var1);
    }

    private static <T> Holder<T> getResource(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (Holder)var0.getArgument(var1, Holder.class);
    }

    @Nullable
    public Holder<T> parse(StringReader var0) throws CommandSyntaxException {
        NBTBase var12 = ResourceOrIdArgument.parseInlineOrId(var0);
        if (!this.hasRegistry) {
            return null;
        }
        RegistryOps<NBTBase> var2 = this.registryLookup.createSerializationContext(DynamicOpsNBT.INSTANCE);
        return (Holder)this.codec.parse(var2, (Object)var12).getOrThrow(var1 -> ERROR_FAILED_TO_PARSE.createWithContext((ImmutableStringReader)var0, var1));
    }

    @VisibleForTesting
    static NBTBase parseInlineOrId(StringReader var0) throws CommandSyntaxException {
        int var1 = var0.getCursor();
        NBTBase var2 = new MojangsonParser(var0).readValue();
        if (ResourceOrIdArgument.hasConsumedWholeArg(var0)) {
            return var2;
        }
        var0.setCursor(var1);
        MinecraftKey var3 = MinecraftKey.read(var0);
        if (ResourceOrIdArgument.hasConsumedWholeArg(var0)) {
            return NBTTagString.valueOf(var3.toString());
        }
        var0.setCursor(var1);
        throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0);
    }

    private static boolean hasConsumedWholeArg(StringReader var0) {
        return !var0.canRead() || var0.peek() == ' ';
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    @Nullable
    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    public static class c
    extends ResourceOrIdArgument<LootTable> {
        protected c(CommandBuildContext var0) {
            super(var0, Registries.LOOT_TABLE, LootTable.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class a
    extends ResourceOrIdArgument<LootItemFunction> {
        protected a(CommandBuildContext var0) {
            super(var0, Registries.ITEM_MODIFIER, LootItemFunctions.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }

    public static class b
    extends ResourceOrIdArgument<LootItemCondition> {
        protected b(CommandBuildContext var0) {
            super(var0, Registries.PREDICATE, LootItemConditions.CODEC);
        }

        @Override
        @Nullable
        public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
            return super.parse(stringReader);
        }
    }
}

