/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.google.common.collect.Lists;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.arguments.ArgumentEntity;
import net.minecraft.commands.arguments.selector.ArgumentParserSelector;
import net.minecraft.commands.arguments.selector.EntitySelector;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.level.EntityPlayer;

public class ArgumentProfile
implements ArgumentType<a> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Player", "0123", "dd12be42-52a9-4a91-a8a1-11c01849e498", "@e");
    public static final SimpleCommandExceptionType ERROR_UNKNOWN_PLAYER = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.player.unknown"));

    public static Collection<GameProfile> getGameProfiles(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return ((a)var0.getArgument(var1, a.class)).getNames((CommandListenerWrapper)var0.getSource());
    }

    public static ArgumentProfile gameProfile() {
        return new ArgumentProfile();
    }

    public a parse(StringReader var0) throws CommandSyntaxException {
        if (var0.canRead() && var0.peek() == '@') {
            ArgumentParserSelector var12 = new ArgumentParserSelector(var0);
            EntitySelector var2 = var12.parse();
            if (var2.includesEntities()) {
                throw ArgumentEntity.ERROR_ONLY_PLAYERS_ALLOWED.createWithContext((ImmutableStringReader)var0);
            }
            return new b(var2);
        }
        int var13 = var0.getCursor();
        while (var0.canRead() && var0.peek() != ' ') {
            var0.skip();
        }
        String var2 = var0.getString().substring(var13, var0.getCursor());
        return var1 -> {
            Optional<GameProfile> var2 = var1.getServer().getProfileCache().get(var2);
            return Collections.singleton(var2.orElseThrow(() -> ((SimpleCommandExceptionType)ERROR_UNKNOWN_PLAYER).create()));
        };
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var12) {
        if (var0.getSource() instanceof ICompletionProvider) {
            StringReader var2 = new StringReader(var12.getInput());
            var2.setCursor(var12.getStart());
            ArgumentParserSelector var3 = new ArgumentParserSelector(var2);
            try {
                var3.parse();
            }
            catch (CommandSyntaxException commandSyntaxException) {
                // empty catch block
            }
            return var3.fillSuggestions(var12, var1 -> ICompletionProvider.suggest(((ICompletionProvider)var0.getSource()).getOnlinePlayerNames(), var1));
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }

    @FunctionalInterface
    public static interface a {
        public Collection<GameProfile> getNames(CommandListenerWrapper var1) throws CommandSyntaxException;
    }

    public static class b
    implements a {
        private final EntitySelector selector;

        public b(EntitySelector var0) {
            this.selector = var0;
        }

        @Override
        public Collection<GameProfile> getNames(CommandListenerWrapper var0) throws CommandSyntaxException {
            List<EntityPlayer> var1 = this.selector.findPlayers(var0);
            if (var1.isEmpty()) {
                throw ArgumentEntity.NO_PLAYERS_FOUND.create();
            }
            ArrayList var2 = Lists.newArrayList();
            for (EntityPlayer var4 : var1) {
                var2.add(var4.getGameProfile());
            }
            return var2;
        }
    }
}

