/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.particles.Particle;
import net.minecraft.core.particles.ParticleParam;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;

public class ArgumentParticle
implements ArgumentType<ParticleParam> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "particle{foo:bar}");
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_PARTICLE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("particle.notFound", var0));
    public static final DynamicCommandExceptionType ERROR_INVALID_OPTIONS = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("particle.invalidOptions", var0));
    private final HolderLookup.a registries;

    public ArgumentParticle(CommandBuildContext var0) {
        this.registries = var0;
    }

    public static ArgumentParticle particle(CommandBuildContext var0) {
        return new ArgumentParticle(var0);
    }

    public static ParticleParam getParticle(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (ParticleParam)var0.getArgument(var1, ParticleParam.class);
    }

    public ParticleParam parse(StringReader var0) throws CommandSyntaxException {
        return ArgumentParticle.readParticle(var0, this.registries);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static ParticleParam readParticle(StringReader var0, HolderLookup.a var1) throws CommandSyntaxException {
        Particle<?> var2 = ArgumentParticle.readParticleType(var0, var1.lookupOrThrow(Registries.PARTICLE_TYPE));
        return ArgumentParticle.readParticle(var0, var2, var1);
    }

    private static Particle<?> readParticleType(StringReader var0, HolderLookup<Particle<?>> var1) throws CommandSyntaxException {
        MinecraftKey var2 = MinecraftKey.read(var0);
        ResourceKey<Particle<?>> var3 = ResourceKey.create(Registries.PARTICLE_TYPE, var2);
        return var1.get(var3).orElseThrow(() -> ERROR_UNKNOWN_PARTICLE.createWithContext((ImmutableStringReader)var0, (Object)var2)).value();
    }

    private static <T extends ParticleParam> T readParticle(StringReader var0, Particle<T> var1, HolderLookup.a var2) throws CommandSyntaxException {
        NBTTagCompound var3 = var0.canRead() && var0.peek() == '{' ? new MojangsonParser(var0).readStruct() : new NBTTagCompound();
        return (T)((ParticleParam)var1.codec().codec().parse(var2.createSerializationContext(DynamicOpsNBT.INSTANCE), (Object)var3).getOrThrow(arg_0 -> ((DynamicCommandExceptionType)ERROR_INVALID_OPTIONS).create(arg_0)));
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        HolderLookup.b<Particle<?>> var2 = this.registries.lookupOrThrow(Registries.PARTICLE_TYPE);
        return ICompletionProvider.suggestResource(var2.listElementIds().map(ResourceKey::location), var1);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

