/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.server.network.Filterable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.WrittenBookContent;

public record ItemWrittenBookPredicate(Optional<CollectionPredicate<Filterable<IChatBaseComponent>, a>> pages, Optional<String> author, Optional<String> title, CriterionConditionValue.IntegerRange generation, Optional<Boolean> resolved) implements SingleComponentItemPredicate<WrittenBookContent>
{
    public static final Codec<ItemWrittenBookPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CollectionPredicate.codec(a.CODEC).optionalFieldOf("pages").forGetter(ItemWrittenBookPredicate::pages), (App)Codec.STRING.optionalFieldOf("author").forGetter(ItemWrittenBookPredicate::author), (App)Codec.STRING.optionalFieldOf("title").forGetter(ItemWrittenBookPredicate::title), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("generation", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(ItemWrittenBookPredicate::generation), (App)Codec.BOOL.optionalFieldOf("resolved").forGetter(ItemWrittenBookPredicate::resolved)).apply((Applicative)var0, ItemWrittenBookPredicate::new));

    @Override
    public DataComponentType<WrittenBookContent> componentType() {
        return DataComponents.WRITTEN_BOOK_CONTENT;
    }

    @Override
    public boolean matches(ItemStack var0, WrittenBookContent var1) {
        if (this.author.isPresent() && !this.author.get().equals(var1.author())) {
            return false;
        }
        if (this.title.isPresent() && !this.title.get().equals(var1.title().raw())) {
            return false;
        }
        if (!this.generation.matches(var1.generation())) {
            return false;
        }
        if (this.resolved.isPresent() && this.resolved.get().booleanValue() != var1.resolved()) {
            return false;
        }
        return !this.pages.isPresent() || this.pages.get().test(var1.pages());
    }

    public record a(IChatBaseComponent contents) implements Predicate<Filterable<IChatBaseComponent>>
    {
        public static final Codec<a> CODEC = ComponentSerialization.CODEC.xmap(a::new, a::contents);

        @Override
        public boolean test(Filterable<IChatBaseComponent> var0) {
            return var0.raw().equals(this.contents);
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((Filterable)object);
        }
    }
}

