/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionInOpenWater;
import net.minecraft.advancements.critereon.CriterionConditionPlayer;
import net.minecraft.advancements.critereon.EntitySubPredicate;
import net.minecraft.advancements.critereon.LightningBoltPredicate;
import net.minecraft.advancements.critereon.RaiderPredicate;
import net.minecraft.advancements.critereon.SlimePredicate;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.EntityCat;
import net.minecraft.world.entity.animal.EntityFox;
import net.minecraft.world.entity.animal.EntityMushroomCow;
import net.minecraft.world.entity.animal.EntityParrot;
import net.minecraft.world.entity.animal.EntityRabbit;
import net.minecraft.world.entity.animal.EntityTropicalFish;
import net.minecraft.world.entity.animal.EntityWolf;
import net.minecraft.world.entity.animal.FrogVariant;
import net.minecraft.world.entity.animal.WolfVariant;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.animal.frog.Frog;
import net.minecraft.world.entity.animal.horse.EntityHorse;
import net.minecraft.world.entity.animal.horse.EntityLlama;
import net.minecraft.world.entity.animal.horse.HorseColor;
import net.minecraft.world.entity.decoration.EntityPainting;
import net.minecraft.world.entity.decoration.PaintingVariant;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.phys.Vec3D;

public class EntitySubPredicates {
    public static final MapCodec<LightningBoltPredicate> LIGHTNING = EntitySubPredicates.register("lightning", LightningBoltPredicate.CODEC);
    public static final MapCodec<CriterionConditionInOpenWater> FISHING_HOOK = EntitySubPredicates.register("fishing_hook", CriterionConditionInOpenWater.CODEC);
    public static final MapCodec<CriterionConditionPlayer> PLAYER = EntitySubPredicates.register("player", CriterionConditionPlayer.CODEC);
    public static final MapCodec<SlimePredicate> SLIME = EntitySubPredicates.register("slime", SlimePredicate.CODEC);
    public static final MapCodec<RaiderPredicate> RAIDER = EntitySubPredicates.register("raider", RaiderPredicate.CODEC);
    public static final b<Axolotl.Variant> AXOLOTL = EntitySubPredicates.register("axolotl", b.create(Axolotl.Variant.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof Axolotl) {
            Axolotl var1 = (Axolotl)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityBoat.EnumBoatType> BOAT = EntitySubPredicates.register("boat", b.create(EntityBoat.EnumBoatType.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityBoat) {
            EntityBoat var1 = (EntityBoat)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityFox.Type> FOX = EntitySubPredicates.register("fox", b.create(EntityFox.Type.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityFox) {
            EntityFox var1 = (EntityFox)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityMushroomCow.Type> MOOSHROOM = EntitySubPredicates.register("mooshroom", b.create(EntityMushroomCow.Type.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityMushroomCow) {
            EntityMushroomCow var1 = (EntityMushroomCow)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityRabbit.Variant> RABBIT = EntitySubPredicates.register("rabbit", b.create(EntityRabbit.Variant.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityRabbit) {
            EntityRabbit var1 = (EntityRabbit)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<HorseColor> HORSE = EntitySubPredicates.register("horse", b.create(HorseColor.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityHorse) {
            EntityHorse var1 = (EntityHorse)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityLlama.Variant> LLAMA = EntitySubPredicates.register("llama", b.create(EntityLlama.Variant.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityLlama) {
            EntityLlama var1 = (EntityLlama)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<VillagerType> VILLAGER = EntitySubPredicates.register("villager", b.create(BuiltInRegistries.VILLAGER_TYPE.byNameCodec(), var0 -> {
        Optional<Object> optional;
        if (var0 instanceof VillagerDataHolder) {
            VillagerDataHolder var1 = (VillagerDataHolder)((Object)var0);
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityParrot.Variant> PARROT = EntitySubPredicates.register("parrot", b.create(EntityParrot.Variant.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityParrot) {
            EntityParrot var1 = (EntityParrot)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final b<EntityTropicalFish.Variant> TROPICAL_FISH = EntitySubPredicates.register("tropical_fish", b.create(EntityTropicalFish.Variant.CODEC, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityTropicalFish) {
            EntityTropicalFish var1 = (EntityTropicalFish)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final a<PaintingVariant> PAINTING = EntitySubPredicates.register("painting", a.create(Registries.PAINTING_VARIANT, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityPainting) {
            EntityPainting var1 = (EntityPainting)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final a<CatVariant> CAT = EntitySubPredicates.register("cat", a.create(Registries.CAT_VARIANT, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityCat) {
            EntityCat var1 = (EntityCat)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final a<FrogVariant> FROG = EntitySubPredicates.register("frog", a.create(Registries.FROG_VARIANT, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof Frog) {
            Frog var1 = (Frog)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));
    public static final a<WolfVariant> WOLF = EntitySubPredicates.register("wolf", a.create(Registries.WOLF_VARIANT, var0 -> {
        Optional<Object> optional;
        if (var0 instanceof EntityWolf) {
            EntityWolf var1 = (EntityWolf)var0;
            optional = Optional.of(var1.getVariant());
        } else {
            optional = Optional.empty();
        }
        return optional;
    }));

    private static <T extends EntitySubPredicate> MapCodec<T> register(String var0, MapCodec<T> var1) {
        return IRegistry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, var0, var1);
    }

    private static <V> b<V> register(String var0, b<V> var1) {
        IRegistry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, var0, var1.codec);
        return var1;
    }

    private static <V> a<V> register(String var0, a<V> var1) {
        IRegistry.register(BuiltInRegistries.ENTITY_SUB_PREDICATE_TYPE, var0, var1.codec);
        return var1;
    }

    public static MapCodec<? extends EntitySubPredicate> bootstrap(IRegistry<MapCodec<? extends EntitySubPredicate>> var0) {
        return LIGHTNING;
    }

    public static EntitySubPredicate catVariant(Holder<CatVariant> var0) {
        return CAT.createPredicate(HolderSet.direct(var0));
    }

    public static EntitySubPredicate frogVariant(Holder<FrogVariant> var0) {
        return FROG.createPredicate(HolderSet.direct(var0));
    }

    public static EntitySubPredicate wolfVariant(HolderSet<WolfVariant> var0) {
        return WOLF.createPredicate(var0);
    }

    public static class b<V> {
        final MapCodec<a> codec;
        final Function<Entity, Optional<V>> getter;

        public static <V> b<V> create(IRegistry<V> var0, Function<Entity, Optional<V>> var1) {
            return new b<V>(var0.byNameCodec(), var1);
        }

        public static <V> b<V> create(Codec<V> var0, Function<Entity, Optional<V>> var1) {
            return new b<V>(var0, var1);
        }

        public b(Codec<V> var0, Function<Entity, Optional<V>> var12) {
            this.getter = var12;
            this.codec = RecordCodecBuilder.mapCodec(var1 -> var1.group((App)var0.fieldOf("variant").forGetter(var0 -> var0.variant)).apply((Applicative)var1, var0 -> new a(var0)));
        }

        public EntitySubPredicate createPredicate(V var0) {
            return new a(var0);
        }

        class a
        implements EntitySubPredicate {
            final V variant;

            a(Object var1) {
                this.variant = var1;
            }

            public MapCodec<a> codec() {
                return b.this.codec;
            }

            @Override
            public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
                return b.this.getter.apply(var0).filter(this.variant::equals).isPresent();
            }
        }
    }

    public static class net.minecraft.advancements.critereon.EntitySubPredicates$a<V> {
        final MapCodec<a> codec;
        final Function<Entity, Optional<Holder<V>>> getter;

        public static <V> net.minecraft.advancements.critereon.EntitySubPredicates$a<V> create(ResourceKey<? extends IRegistry<V>> var0, Function<Entity, Optional<Holder<V>>> var1) {
            return new net.minecraft.advancements.critereon.EntitySubPredicates$a<V>(var0, var1);
        }

        public net.minecraft.advancements.critereon.EntitySubPredicates$a(ResourceKey<? extends IRegistry<V>> var0, Function<Entity, Optional<Holder<V>>> var12) {
            this.getter = var12;
            this.codec = RecordCodecBuilder.mapCodec(var1 -> var1.group((App)RegistryCodecs.homogeneousList(var0).fieldOf("variant").forGetter(var0 -> var0.variants)).apply((Applicative)var1, var0 -> new a((HolderSet)var0)));
        }

        public EntitySubPredicate createPredicate(HolderSet<V> var0) {
            return new a(var0);
        }

        class a
        implements EntitySubPredicate {
            final HolderSet<V> variants;

            a(HolderSet var1) {
                this.variants = var1;
            }

            public MapCodec<a> codec() {
                return a.this.codec;
            }

            @Override
            public boolean matches(Entity var0, WorldServer var1, @Nullable Vec3D var2) {
                return a.this.getter.apply(var0).filter(this.variants::contains).isPresent();
            }
        }
    }
}

