/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionBlock;
import net.minecraft.advancements.critereon.CriterionConditionFluid;
import net.minecraft.advancements.critereon.CriterionConditionLight;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.World;
import net.minecraft.world.level.biome.BiomeBase;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.levelgen.structure.Structure;

public record CriterionConditionLocation(Optional<b> position, Optional<HolderSet<BiomeBase>> biomes, Optional<HolderSet<Structure>> structures, Optional<ResourceKey<World>> dimension, Optional<Boolean> smokey, Optional<CriterionConditionLight> light, Optional<CriterionConditionBlock> block, Optional<CriterionConditionFluid> fluid) {
    public static final Codec<CriterionConditionLocation> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)b.CODEC.optionalFieldOf("position").forGetter(CriterionConditionLocation::position), (App)RegistryCodecs.homogeneousList(Registries.BIOME).optionalFieldOf("biomes").forGetter(CriterionConditionLocation::biomes), (App)RegistryCodecs.homogeneousList(Registries.STRUCTURE).optionalFieldOf("structures").forGetter(CriterionConditionLocation::structures), (App)ResourceKey.codec(Registries.DIMENSION).optionalFieldOf("dimension").forGetter(CriterionConditionLocation::dimension), (App)Codec.BOOL.optionalFieldOf("smokey").forGetter(CriterionConditionLocation::smokey), (App)CriterionConditionLight.CODEC.optionalFieldOf("light").forGetter(CriterionConditionLocation::light), (App)CriterionConditionBlock.CODEC.optionalFieldOf("block").forGetter(CriterionConditionLocation::block), (App)CriterionConditionFluid.CODEC.optionalFieldOf("fluid").forGetter(CriterionConditionLocation::fluid)).apply((Applicative)var0, CriterionConditionLocation::new));

    public boolean matches(WorldServer var0, double var1, double var3, double var5) {
        if (this.position.isPresent() && !this.position.get().matches(var1, var3, var5)) {
            return false;
        }
        if (this.dimension.isPresent() && this.dimension.get() != var0.dimension()) {
            return false;
        }
        BlockPosition var7 = BlockPosition.containing(var1, var3, var5);
        boolean var8 = var0.isLoaded(var7);
        if (!(!this.biomes.isPresent() || var8 && this.biomes.get().contains(var0.getBiome(var7)))) {
            return false;
        }
        if (!(!this.structures.isPresent() || var8 && var0.structureManager().getStructureWithPieceAt(var7, this.structures.get()).isValid())) {
            return false;
        }
        if (this.smokey.isPresent() && (!var8 || this.smokey.get() != BlockCampfire.isSmokeyPos(var0, var7))) {
            return false;
        }
        if (this.light.isPresent() && !this.light.get().matches(var0, var7)) {
            return false;
        }
        if (this.block.isPresent() && !this.block.get().matches(var0, var7)) {
            return false;
        }
        return !this.fluid.isPresent() || this.fluid.get().matches(var0, var7);
    }

    record b(CriterionConditionValue.DoubleRange x, CriterionConditionValue.DoubleRange y, CriterionConditionValue.DoubleRange z) {
        public static final Codec<b> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("x", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(b::x), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("y", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(b::y), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("z", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(b::z)).apply((Applicative)var0, b::new));

        static Optional<b> of(CriterionConditionValue.DoubleRange var0, CriterionConditionValue.DoubleRange var1, CriterionConditionValue.DoubleRange var2) {
            if (var0.isAny() && var1.isAny() && var2.isAny()) {
                return Optional.empty();
            }
            return Optional.of(new b(var0, var1, var2));
        }

        public boolean matches(double var0, double var2, double var4) {
            return this.x.matches(var0) && this.y.matches(var2) && this.z.matches(var4);
        }
    }

    public static class a {
        private CriterionConditionValue.DoubleRange x = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange y = CriterionConditionValue.DoubleRange.ANY;
        private CriterionConditionValue.DoubleRange z = CriterionConditionValue.DoubleRange.ANY;
        private Optional<HolderSet<BiomeBase>> biomes = Optional.empty();
        private Optional<HolderSet<Structure>> structures = Optional.empty();
        private Optional<ResourceKey<World>> dimension = Optional.empty();
        private Optional<Boolean> smokey = Optional.empty();
        private Optional<CriterionConditionLight> light = Optional.empty();
        private Optional<CriterionConditionBlock> block = Optional.empty();
        private Optional<CriterionConditionFluid> fluid = Optional.empty();

        public static a location() {
            return new a();
        }

        public static a inBiome(Holder<BiomeBase> var0) {
            return a.location().setBiomes(HolderSet.direct(var0));
        }

        public static a inDimension(ResourceKey<World> var0) {
            return a.location().setDimension(var0);
        }

        public static a inStructure(Holder<Structure> var0) {
            return a.location().setStructures(HolderSet.direct(var0));
        }

        public static a atYLocation(CriterionConditionValue.DoubleRange var0) {
            return a.location().setY(var0);
        }

        public a setX(CriterionConditionValue.DoubleRange var0) {
            this.x = var0;
            return this;
        }

        public a setY(CriterionConditionValue.DoubleRange var0) {
            this.y = var0;
            return this;
        }

        public a setZ(CriterionConditionValue.DoubleRange var0) {
            this.z = var0;
            return this;
        }

        public a setBiomes(HolderSet<BiomeBase> var0) {
            this.biomes = Optional.of(var0);
            return this;
        }

        public a setStructures(HolderSet<Structure> var0) {
            this.structures = Optional.of(var0);
            return this;
        }

        public a setDimension(ResourceKey<World> var0) {
            this.dimension = Optional.of(var0);
            return this;
        }

        public a setLight(CriterionConditionLight.a var0) {
            this.light = Optional.of(var0.build());
            return this;
        }

        public a setBlock(CriterionConditionBlock.a var0) {
            this.block = Optional.of(var0.build());
            return this;
        }

        public a setFluid(CriterionConditionFluid.a var0) {
            this.fluid = Optional.of(var0.build());
            return this;
        }

        public a setSmokey(boolean var0) {
            this.smokey = Optional.of(var0);
            return this;
        }

        public CriterionConditionLocation build() {
            Optional<b> var0 = b.of(this.x, this.y, this.z);
            return new CriterionConditionLocation(var0, this.biomes, this.structures, this.dimension, this.smokey, this.light, this.block, this.fluid);
        }
    }
}

