/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.ItemSubPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.IMaterial;

public record CriterionConditionItem(Optional<HolderSet<Item>> items, CriterionConditionValue.IntegerRange count, DataComponentPredicate components, Map<ItemSubPredicate.a<?>, ItemSubPredicate> subPredicates) implements Predicate<ItemStack>
{
    public static final Codec<CriterionConditionItem> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ITEM).optionalFieldOf("items").forGetter(CriterionConditionItem::items), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("count", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionItem::count), (App)DataComponentPredicate.CODEC.optionalFieldOf("components", (Object)DataComponentPredicate.EMPTY).forGetter(CriterionConditionItem::components), (App)ItemSubPredicate.CODEC.optionalFieldOf("predicates", Map.of()).forGetter(CriterionConditionItem::subPredicates)).apply((Applicative)var0, CriterionConditionItem::new));

    @Override
    public boolean test(ItemStack var0) {
        if (this.items.isPresent() && !var0.is(this.items.get())) {
            return false;
        }
        if (!this.count.matches(var0.getCount())) {
            return false;
        }
        if (!this.components.test(var0)) {
            return false;
        }
        for (ItemSubPredicate var2 : this.subPredicates.values()) {
            if (var2.matches(var0)) continue;
            return false;
        }
        return true;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ItemStack)object);
    }

    public static class a {
        private Optional<HolderSet<Item>> items = Optional.empty();
        private CriterionConditionValue.IntegerRange count = CriterionConditionValue.IntegerRange.ANY;
        private DataComponentPredicate components = DataComponentPredicate.EMPTY;
        private final ImmutableMap.Builder<ItemSubPredicate.a<?>, ItemSubPredicate> subPredicates = ImmutableMap.builder();

        private a() {
        }

        public static a item() {
            return new a();
        }

        public a of(IMaterial ... var02) {
            this.items = Optional.of(HolderSet.direct(var0 -> var0.asItem().builtInRegistryHolder(), var02));
            return this;
        }

        public a of(TagKey<Item> var0) {
            this.items = Optional.of(BuiltInRegistries.ITEM.getOrCreateTag(var0));
            return this;
        }

        public a withCount(CriterionConditionValue.IntegerRange var0) {
            this.count = var0;
            return this;
        }

        public <T extends ItemSubPredicate> a withSubPredicate(ItemSubPredicate.a<T> var0, T var1) {
            this.subPredicates.put(var0, var1);
            return this;
        }

        public a hasComponents(DataComponentPredicate var0) {
            this.components = var0;
            return this;
        }

        public CriterionConditionItem build() {
            return new CriterionConditionItem(this.items, this.count, this.components, (Map<ItemSubPredicate.a<?>, ItemSubPredicate>)this.subPredicates.build());
        }
    }
}

