/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;

public record CriterionConditionEntityFlags(Optional<Boolean> isOnFire, Optional<Boolean> isCrouching, Optional<Boolean> isSprinting, Optional<Boolean> isSwimming, Optional<Boolean> isBaby) {
    public static final Codec<CriterionConditionEntityFlags> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.BOOL.optionalFieldOf("is_on_fire").forGetter(CriterionConditionEntityFlags::isOnFire), (App)Codec.BOOL.optionalFieldOf("is_sneaking").forGetter(CriterionConditionEntityFlags::isCrouching), (App)Codec.BOOL.optionalFieldOf("is_sprinting").forGetter(CriterionConditionEntityFlags::isSprinting), (App)Codec.BOOL.optionalFieldOf("is_swimming").forGetter(CriterionConditionEntityFlags::isSwimming), (App)Codec.BOOL.optionalFieldOf("is_baby").forGetter(CriterionConditionEntityFlags::isBaby)).apply((Applicative)var0, CriterionConditionEntityFlags::new));

    public boolean matches(Entity var0) {
        EntityLiving var1;
        if (this.isOnFire.isPresent() && var0.isOnFire() != this.isOnFire.get().booleanValue()) {
            return false;
        }
        if (this.isCrouching.isPresent() && var0.isCrouching() != this.isCrouching.get().booleanValue()) {
            return false;
        }
        if (this.isSprinting.isPresent() && var0.isSprinting() != this.isSprinting.get().booleanValue()) {
            return false;
        }
        if (this.isSwimming.isPresent() && var0.isSwimming() != this.isSwimming.get().booleanValue()) {
            return false;
        }
        return !this.isBaby.isPresent() || !(var0 instanceof EntityLiving) || (var1 = (EntityLiving)var0).isBaby() == this.isBaby.get().booleanValue();
    }

    public static class a {
        private Optional<Boolean> isOnFire = Optional.empty();
        private Optional<Boolean> isCrouching = Optional.empty();
        private Optional<Boolean> isSprinting = Optional.empty();
        private Optional<Boolean> isSwimming = Optional.empty();
        private Optional<Boolean> isBaby = Optional.empty();

        public static a flags() {
            return new a();
        }

        public a setOnFire(Boolean var0) {
            this.isOnFire = Optional.of(var0);
            return this;
        }

        public a setCrouching(Boolean var0) {
            this.isCrouching = Optional.of(var0);
            return this;
        }

        public a setSprinting(Boolean var0) {
            this.isSprinting = Optional.of(var0);
            return this;
        }

        public a setSwimming(Boolean var0) {
            this.isSwimming = Optional.of(var0);
            return this;
        }

        public a setIsBaby(Boolean var0) {
            this.isBaby = Optional.of(var0);
            return this;
        }

        public CriterionConditionEntityFlags build() {
            return new CriterionConditionEntityFlags(this.isOnFire, this.isCrouching, this.isSprinting, this.isSwimming, this.isBaby);
        }
    }
}

