/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Optional;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.ItemEnchantments;

public record CriterionConditionEnchantments(Optional<Holder<Enchantment>> enchantment, CriterionConditionValue.IntegerRange level) {
    public static final Codec<CriterionConditionEnchantments> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)BuiltInRegistries.ENCHANTMENT.holderByNameCodec().optionalFieldOf("enchantment").forGetter(CriterionConditionEnchantments::enchantment), (App)CriterionConditionValue.IntegerRange.CODEC.optionalFieldOf("levels", (Object)CriterionConditionValue.IntegerRange.ANY).forGetter(CriterionConditionEnchantments::level)).apply((Applicative)var0, CriterionConditionEnchantments::new));

    public CriterionConditionEnchantments(Enchantment var0, CriterionConditionValue.IntegerRange var1) {
        this(Optional.of(var0.builtInRegistryHolder()), var1);
    }

    public boolean containedIn(ItemEnchantments var0) {
        if (this.enchantment.isPresent()) {
            Enchantment var1 = this.enchantment.get().value();
            int var2 = var0.getLevel(var1);
            if (var2 == 0) {
                return false;
            }
            if (this.level != CriterionConditionValue.IntegerRange.ANY && !this.level.matches(var2)) {
                return false;
            }
        } else if (this.level != CriterionConditionValue.IntegerRange.ANY) {
            for (Object2IntMap.Entry<Holder<Enchantment>> var2 : var0.entrySet()) {
                if (!this.level.matches(var2.getIntValue())) continue;
                return true;
            }
            return false;
        }
        return true;
    }
}

