/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.score;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.core.IRegistry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.level.storage.loot.providers.score.ContextScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.FixedScoreboardNameProvider;
import net.minecraft.world.level.storage.loot.providers.score.LootScoreProviderType;
import net.minecraft.world.level.storage.loot.providers.score.ScoreboardNameProvider;

public class ScoreboardNameProviders {
    private static final Codec<ScoreboardNameProvider> TYPED_CODEC = BuiltInRegistries.LOOT_SCORE_PROVIDER_TYPE.byNameCodec().dispatch(ScoreboardNameProvider::getType, LootScoreProviderType::codec);
    public static final Codec<ScoreboardNameProvider> CODEC = ExtraCodecs.lazyInitializedCodec(() -> Codec.either(ContextScoreboardNameProvider.INLINE_CODEC, TYPED_CODEC).xmap(var0 -> (ScoreboardNameProvider)var0.map(Function.identity(), Function.identity()), var0 -> {
        Either either;
        if (var0 instanceof ContextScoreboardNameProvider) {
            ContextScoreboardNameProvider var1 = (ContextScoreboardNameProvider)var0;
            either = Either.left((Object)var1);
        } else {
            either = Either.right((Object)var0);
        }
        return either;
    }));
    public static final LootScoreProviderType FIXED = ScoreboardNameProviders.register("fixed", FixedScoreboardNameProvider.CODEC);
    public static final LootScoreProviderType CONTEXT = ScoreboardNameProviders.register("context", ContextScoreboardNameProvider.CODEC);

    private static LootScoreProviderType register(String var0, Codec<? extends ScoreboardNameProvider> var1) {
        return IRegistry.register(BuiltInRegistries.LOOT_SCORE_PROVIDER_TYPE, new MinecraftKey(var0), new LootScoreProviderType(var1));
    }
}

