/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.predicates;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.IntRange;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditions;
import net.minecraft.world.scores.ReadOnlyScoreInfo;
import net.minecraft.world.scores.Scoreboard;
import net.minecraft.world.scores.ScoreboardObjective;

public record LootItemConditionEntityScore(Map<String, IntRange> scores, LootTableInfo.EntityTarget entityTarget) implements LootItemCondition
{
    public static final Codec<LootItemConditionEntityScore> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)Codec.unboundedMap((Codec)Codec.STRING, IntRange.CODEC).fieldOf("scores").forGetter(LootItemConditionEntityScore::scores), (App)LootTableInfo.EntityTarget.CODEC.fieldOf("entity").forGetter(LootItemConditionEntityScore::entityTarget)).apply((Applicative)var0, LootItemConditionEntityScore::new));

    @Override
    public LootItemConditionType getType() {
        return LootItemConditions.ENTITY_SCORES;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return (Set)Stream.concat(Stream.of(this.entityTarget.getParam()), this.scores.values().stream().flatMap(var0 -> var0.getReferencedContextParams().stream())).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    public boolean test(LootTableInfo var0) {
        Entity var1 = var0.getParamOrNull(this.entityTarget.getParam());
        if (var1 == null) {
            return false;
        }
        Scoreboard var2 = var1.level().getScoreboard();
        for (Map.Entry<String, IntRange> var4 : this.scores.entrySet()) {
            if (this.hasScore(var0, var1, var2, var4.getKey(), var4.getValue())) continue;
            return false;
        }
        return true;
    }

    protected boolean hasScore(LootTableInfo var0, Entity var1, Scoreboard var2, String var3, IntRange var4) {
        ScoreboardObjective var5 = var2.getObjective(var3);
        if (var5 == null) {
            return false;
        }
        ReadOnlyScoreInfo var6 = var2.getPlayerScoreInfo(var1, var5);
        if (var6 == null) {
            return false;
        }
        return var4.test(var0, var6.value());
    }

    public static a hasScores(LootTableInfo.EntityTarget var0) {
        return new a(var0);
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((LootTableInfo)object);
    }

    public static class a
    implements LootItemCondition.a {
        private final ImmutableMap.Builder<String, IntRange> scores = ImmutableMap.builder();
        private final LootTableInfo.EntityTarget entityTarget;

        public a(LootTableInfo.EntityTarget var0) {
            this.entityTarget = var0;
        }

        public a withScore(String var0, IntRange var1) {
            this.scores.put((Object)var0, (Object)var1);
            return this;
        }

        @Override
        public LootItemCondition build() {
            return new LootItemConditionEntityScore((Map<String, IntRange>)this.scores.build(), this.entityTarget);
        }
    }
}

