/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.EnumBannerPatternType;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class SetBannerPatternFunction
extends LootItemFunctionConditional {
    private static final Codec<Pair<Holder<EnumBannerPatternType>, EnumColor>> PATTERN_CODEC = Codec.mapPair((MapCodec)BuiltInRegistries.BANNER_PATTERN.holderByNameCodec().fieldOf("pattern"), (MapCodec)EnumColor.CODEC.fieldOf("color")).codec();
    public static final Codec<SetBannerPatternFunction> CODEC = RecordCodecBuilder.create(var02 -> SetBannerPatternFunction.commonFields(var02).and(var02.group((App)PATTERN_CODEC.listOf().fieldOf("patterns").forGetter(var0 -> var0.patterns), (App)Codec.BOOL.fieldOf("append").forGetter(var0 -> var0.append))).apply((Applicative)var02, SetBannerPatternFunction::new));
    private final List<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns;
    private final boolean append;

    SetBannerPatternFunction(List<LootItemCondition> var0, List<Pair<Holder<EnumBannerPatternType>, EnumColor>> var1, boolean var2) {
        super(var0);
        this.patterns = var1;
        this.append = var2;
    }

    @Override
    protected ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTTagList var5;
        NBTTagCompound var2 = ItemBlock.getBlockEntityData(var0);
        if (var2 == null) {
            var2 = new NBTTagCompound();
        }
        EnumBannerPatternType.a var3 = new EnumBannerPatternType.a();
        this.patterns.forEach(var3::addPattern);
        NBTTagList var4 = var3.toListTag();
        if (this.append) {
            var5 = var2.getList("Patterns", 10).copy();
            var5.addAll(var4);
        } else {
            var5 = var4;
        }
        var2.put("Patterns", var5);
        ItemBlock.setBlockEntityData(var0, TileEntityTypes.BANNER, var2);
        return var0;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_BANNER_PATTERN;
    }

    public static a setBannerPattern(boolean var0) {
        return new a(var0);
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private final ImmutableList.Builder<Pair<Holder<EnumBannerPatternType>, EnumColor>> patterns = ImmutableList.builder();
        private final boolean append;

        a(boolean var0) {
            this.append = var0;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new SetBannerPatternFunction(this.getConditions(), (List<Pair<Holder<EnumBannerPatternType>, EnumColor>>)this.patterns.build(), this.append);
        }

        public a addPattern(ResourceKey<EnumBannerPatternType> var0, EnumColor var1) {
            return this.addPattern(BuiltInRegistries.BANNER_PATTERN.getHolderOrThrow(var0), var1);
        }

        public a addPattern(Holder<EnumBannerPatternType> var0, EnumColor var1) {
            this.patterns.add((Object)Pair.of(var0, (Object)var1));
            return this;
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

