/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.TileEntityTypes;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootDataId;
import net.minecraft.world.level.storage.loot.LootDataType;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetTable
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetTable> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetTable.commonFields(var02).and(var02.group((App)MinecraftKey.CODEC.fieldOf("name").forGetter(var0 -> var0.name), (App)ExtraCodecs.strictOptionalField(Codec.LONG, "seed", 0L).forGetter(var0 -> var0.seed), (App)BuiltInRegistries.BLOCK_ENTITY_TYPE.holderByNameCodec().fieldOf("type").forGetter(var0 -> var0.type))).apply((Applicative)var02, LootItemFunctionSetTable::new));
    private final MinecraftKey name;
    private final long seed;
    private final Holder<TileEntityTypes<?>> type;

    private LootItemFunctionSetTable(List<LootItemCondition> var0, MinecraftKey var1, long var2, Holder<TileEntityTypes<?>> var4) {
        super(var0);
        this.name = var1;
        this.seed = var2;
        this.type = var4;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_LOOT_TABLE;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (var0.isEmpty()) {
            return var0;
        }
        NBTTagCompound var2 = ItemBlock.getBlockEntityData(var0);
        if (var2 == null) {
            var2 = new NBTTagCompound();
        }
        var2.putString("LootTable", this.name.toString());
        if (this.seed != 0L) {
            var2.putLong("LootTableSeed", this.seed);
        }
        ItemBlock.setBlockEntityData(var0, this.type.value(), var2);
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        LootDataId<LootTable> var1 = new LootDataId<LootTable>(LootDataType.TABLE, this.name);
        if (var0.resolver().getElementOptional(var1).isEmpty()) {
            var0.reportProblem("Missing loot table used for container: " + this.name);
        }
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, MinecraftKey var1) {
        return LootItemFunctionSetTable.simpleBuilder(var2 -> new LootItemFunctionSetTable((List<LootItemCondition>)var2, var1, 0L, (Holder<TileEntityTypes<?>>)var0.builtInRegistryHolder()));
    }

    public static LootItemFunctionConditional.a<?> withLootTable(TileEntityTypes<?> var0, MinecraftKey var1, long var2) {
        return LootItemFunctionSetTable.simpleBuilder(var4 -> new LootItemFunctionSetTable((List<LootItemCondition>)var4, var1, var2, (Holder<TileEntityTypes<?>>)var0.builtInRegistryHolder()));
    }
}

