/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionSetName;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class LootItemFunctionSetLore
extends LootItemFunctionConditional {
    public static final Codec<LootItemFunctionSetLore> CODEC = RecordCodecBuilder.create(var02 -> LootItemFunctionSetLore.commonFields(var02).and(var02.group((App)Codec.BOOL.fieldOf("replace").orElse((Object)false).forGetter(var0 -> var0.replace), (App)ComponentSerialization.CODEC.listOf().fieldOf("lore").forGetter(var0 -> var0.lore), (App)ExtraCodecs.strictOptionalField(LootTableInfo.EntityTarget.CODEC, "entity").forGetter(var0 -> var0.resolutionContext))).apply((Applicative)var02, LootItemFunctionSetLore::new));
    private final boolean replace;
    private final List<IChatBaseComponent> lore;
    private final Optional<LootTableInfo.EntityTarget> resolutionContext;

    public LootItemFunctionSetLore(List<LootItemCondition> var0, boolean var1, List<IChatBaseComponent> var2, Optional<LootTableInfo.EntityTarget> var3) {
        super(var0);
        this.replace = var1;
        this.lore = List.copyOf(var2);
        this.resolutionContext = var3;
    }

    @Override
    public LootItemFunctionType getType() {
        return LootItemFunctions.SET_LORE;
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return this.resolutionContext.map(var0 -> Set.of(var0.getParam())).orElseGet(Set::of);
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        NBTTagList var2 = this.getLoreTag(var0, !this.lore.isEmpty());
        if (var2 != null) {
            if (this.replace) {
                var2.clear();
            }
            UnaryOperator<IChatBaseComponent> var3 = LootItemFunctionSetName.createResolver(var1, this.resolutionContext.orElse(null));
            this.lore.stream().map(var3).map(IChatBaseComponent.ChatSerializer::toJson).map(NBTTagString::valueOf).forEach(var2::add);
        }
        return var0;
    }

    @Nullable
    private NBTTagList getLoreTag(ItemStack var0, boolean var1) {
        NBTTagCompound var3;
        NBTTagCompound var2;
        if (var0.hasTag()) {
            var2 = var0.getTag();
        } else if (var1) {
            var2 = new NBTTagCompound();
            var0.setTag(var2);
        } else {
            return null;
        }
        if (var2.contains("display", 10)) {
            var3 = var2.getCompound("display");
        } else if (var1) {
            var3 = new NBTTagCompound();
            var2.put("display", var3);
        } else {
            return null;
        }
        if (var3.contains("Lore", 9)) {
            return var3.getList("Lore", 8);
        }
        if (var1) {
            NBTTagList var4 = new NBTTagList();
            var3.put("Lore", var4);
            return var4;
        }
        return null;
    }

    public static a setLore() {
        return new a();
    }

    public static class a
    extends LootItemFunctionConditional.a<a> {
        private boolean replace;
        private Optional<LootTableInfo.EntityTarget> resolutionContext = Optional.empty();
        private final ImmutableList.Builder<IChatBaseComponent> lore = ImmutableList.builder();

        public a setReplace(boolean var0) {
            this.replace = var0;
            return this;
        }

        public a setResolutionContext(LootTableInfo.EntityTarget var0) {
            this.resolutionContext = Optional.of(var0);
            return this;
        }

        public a addLine(IChatBaseComponent var0) {
            this.lore.add((Object)var0);
            return this;
        }

        @Override
        protected a getThis() {
            return this;
        }

        @Override
        public LootItemFunction build() {
            return new LootItemFunctionSetLore(this.getConditions(), this.replace, (List<IChatBaseComponent>)this.lore.build(), this.resolutionContext);
        }

        @Override
        protected /* synthetic */ LootItemFunctionConditional.a getThis() {
            return this.getThis();
        }
    }
}

